/***************************************************************************
                          knarticlemanager.cpp  -  description
                             -------------------
   
    copyright            : (C) 1999 by Christian Thurner
    email                : cthurner@freepage.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "knarticlemanager.h"
#include "knthread.h"
#include "knscoredialog.h"
#include "utilities.h"
#include "knglobals.h"
#include "knhdrviewitem.h"
#include "knstringsplitter.h"

KNArticleManager::KNArticleManager(QListView *v) : QObject(0,0)
{
	c_urrent=0;
	g_roup=0;
	f_ilter=0;
	tOut=3000;
	view=v;
	
	timer=new QTimer();
	connect(timer, SIGNAL(timeout()), this, SLOT(slotTimeOut()));
	
	readConfig();
}




KNArticleManager::~KNArticleManager()
{
	delete timer;
}



void KNArticleManager::readConfig()
{
	KConfig *c=CONF();
	c->setGroup("READNEWS");
	tOut=1000*c->readNumEntry("markSecs", 3);
}



void KNArticleManager::showHdrs()
{
	
	if(!g_roup) return;
	
	view->clear();	
  KNReadHeaderList &hList=g_roup->hList;
	QString statStr;
	int displCnt;
  	
	if(f_ilter) {
		f_ilter->doFilter(hList);
		displCnt=f_ilter->count();
	}
	else for (uint i=0; i<hList.length(); i++) {
		hList[i]->setFilterResult(true);
		displCnt=g_roup->count();
	}
		
	
	
	for (uint i=0; i<hList.length(); i++){
		  hList[i]->setFiltered(false);
			if(!hList[i]->item && hList[i]->filterResult())
				if(g_roup->threaded()) createThread(hList[i]);
				else createHdrItem(hList[i]);
	}
		

	statStr.sprintf("%s : %d new , %d displayed",
		g_roup->name().data(), g_roup->newCount(), displCnt);
	xTop->setStatusMsg(statStr, SB_GROUP);
}



void KNArticleManager::expandAllHdrs(bool e)
{
	KNReadHeaderList &hList=g_roup->hList;
	
	for(uint idx=0; idx<hList.length(); idx++)
		if(hList[idx]->item) hList[idx]->item->setOpen(e);
}



bool KNArticleManager::setCurrentHdr(KNHeaderBase *h)
{
	if(!h) c_urrent=0;
		
	else {	

		c_urrent=(KNReadHeader*)h;
		debug("age: %d", c_urrent->age);	
		debug("message selected : %d  %s\n",c_urrent->artNr, c_urrent->mID.data());
	
		if(!c_urrent->message) {
			QStrList *msg=0;
		  debug("message not cached. Fetching it :\nby number ... ");
			
			if(c_urrent->artNr!=-1) msg=xClient->cmdArticle(c_urrent->artNr);
      if(!msg) {
      	debug("FAILED trying with mID ...");
      	msg=xClient->cmdArticle(c_urrent->mID);
      }
			
      if(msg)	{
      	debug("Done\n");
      	c_urrent->message=new KNReadMessage(msg);
      	char *rt=c_urrent->message->getHeaderLine("reply-to");
      	if(rt) c_urrent->setReplyToLine(rt);
      }
			
			else 	{
				debug("FAILED\n");
				c_urrent=0;
			}
	
		}
		
		else debug("message is cached.\n");
	}
	
	return (c_urrent!=0);		
}



bool KNArticleManager::setCurrentHdr(const QString &mID)
{
	uint idx=0; bool found=false;
	KNReadHeaderList &hList=g_roup->hList;
	
	if(c_urrent)
		if(c_urrent->item) c_urrent->item->setSelected(false);
		
	c_urrent=0;
		
	while(!found && idx<hList.length())
		if(hList[idx++]->mID==mID) {
			found=true;
			idx--;
		}
		
	if(found) c_urrent=hList[idx];
	else {
		QStrList *art=xClient->cmdArticle(mID);
		
		if(art) {
			
			KNReadMessage *msg=new KNReadMessage(art);
			KNReadHeader *hdr=new KNReadHeader();
			DwDateTime dt;
			KNStringSplitter split;
			char *tmp;
			
			hdr->artNr=-1;
			hdr->setNew(true);						
						
			hdr->mID=msg->getHeaderLine("Message-ID");
			
			hdr->subject=decodeRFC1522String(msg->getHeaderLine("Subject"));
			
			hdr->setFromLine(QString(msg->getHeaderLine("From")));
			
			
			dt.FromString(msg->getHeaderLine("Date"));
			dt.Parse();
			hdr->time=dt.AsUnixTime();
			
			hdr->lines=atoi(msg->getHeaderLine("Lines"));
			
			tmp=msg->getHeaderLine("References");
						
			if(tmp) {
				
				split.init(tmp, " ");
				bool isRef=split.last();
								
				if(!isRef) hdr->references[0]=tmp;
				
				else {
					int RefNr=0;
					QString ref;
					
					while(isRef && RefNr < 5) {
						ref=split.string().simplifyWhiteSpace();	
					
					  if(hdr->mID!=ref) {	
							hdr->references[RefNr]=ref;
							RefNr++;
						}									
						
						isRef=split.prev();
					}
				}
			}
				
			
			hdr->message=msg;
			
			if(hList.append(hdr)) {
				c_urrent=hdr;
				g_roup->mCount=hList.length();
				g_roup->mNewCnt++;
				g_roup->updListItem();
				
				g_roup->saveStaticData(1, false);
				g_roup->sortHdrs(1);
				g_roup->updateThreadInfo();
				showHdrs();
			}
			else delete hdr;
						
	 	}
	}
	
	if(c_urrent) if(!c_urrent->item) {		
		c_urrent->setFilterResult(true);
		c_urrent->setFiltered(true);
		showHdrs();
	}		
			
			
	return (c_urrent!=0);
		
}


	
void KNArticleManager::setCurrentHdrRead(bool r=true)
{
	if(c_urrent) {
		setHdrRead(c_urrent, r);
	 	g_roup->updListItem();
	}		
}


		
void KNArticleManager::setCurrentThreadRead(bool r=true)
{
	if(c_urrent) {
		KNThread *thr=new KNThread(&g_roup->hList, c_urrent);
		int cnt, n_ew;
		cnt=thr->setRead(r, n_ew);
		
		if(cnt>0) {
			
			if(r) {
				g_roup->mRead+=cnt;
				g_roup->mNewCnt-=n_ew;
			}
			else {
				g_roup->mRead-=cnt;
				g_roup->mNewCnt+=n_ew;
			}
			
			g_roup->updListItem();
		}
		
		delete thr;
	}
		
}



void KNArticleManager::setAllHdrsRead(bool r=true)
{
	KNReadHeaderList &hList=g_roup->hList;	

	for(uint i=0; i < hList.length(); i++)
		setHdrRead(hList[i], r);

	g_roup->updListItem();
}



void KNArticleManager::setScoreOfThread()
{
	if(c_urrent) {
			
		KNScoreDialog *sd=new KNScoreDialog(c_urrent->score, xTop);
		
		if(sd->exec()){
		 KNThread *thr=new KNThread(&g_roup->hList, c_urrent);
		 thr->setScore(sd->score());
		 delete thr;
		}
		
		delete sd;
	}
}



void KNArticleManager::slotFilterChanged(KNMessageFilter *f)
{
	timer->stop();
	f_ilter=f;
	showHdrs();
}



void KNArticleManager::setHdrRead(KNReadHeader *hdr, bool r=true)
{
	if(hdr->isRead()!=r) {
			
		KNReadHeader *ref;
		int idRef;
		KNReadHeaderList &hList=g_roup->hList;
		
		hdr->setRead(r);	
	 	hdr->setHasChanged(true);
	 	if(hdr->item) hdr->updateItem();
	 	
	 	idRef=hdr->idRef;
	 	
	 	while(idRef!=0) {
			ref=hList.byID(idRef);
			if(r) ref->unrSubCnt-=1;
			else ref->unrSubCnt+=1;
			idRef=ref->idRef;
			if(ref->item && (ref->unrSubCnt==0 || ref->unrSubCnt==1))
				ref->updateItem();
		}	  	
	  	
		
		
	 	if(r) {
	 		g_roup->mRead++;
	 		if(hdr->isNew()) g_roup->mNewCnt--;
	 	}
	 	else {
	 		g_roup->mRead--;
	 		if(hdr->isNew()) g_roup->mNewCnt++;
	 	}
	}	
}



void KNArticleManager::createHdrItem(KNReadHeader *h)
{
	h->setItem(new KNHdrViewItem(view));
	h->initItem();
}



void KNArticleManager::createThread(KNReadHeader *h)
{
	KNReadHeader *ref;	
  int idRef;
	bool found;
  KNReadHeaderList &hList=g_roup->hList;

	if(h->idRef==0) createHdrItem(h);
		
	else {
		
		idRef=h->idRef;
		found=false;
		
		while(idRef!=0 && !found) {
				ref=hList.byID(idRef);
				if(ref->filterResult()) found=true;
				else idRef=ref->idRef;
		}	
		
		if(found) {	
			if(!ref->item)  createThread(ref);
			h->setItem(new KNHdrViewItem(ref->item));
			h->initItem();
		}
		else createHdrItem(h);
			
		
	}
}



void KNArticleManager::slotTimeOut()
{
	setCurrentHdrRead(true);
}
























