/***************************************************************************
                          convert.cpp  -  description
                             -------------------
   
    copyright            : (C) 1999 by Christian Thurner
    email                : cthurner@freepage.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "utilities.h"
#include <qfile.h>
#include <qdir.h>
#include <stdlib.h>

enum Importance {ignored=0, normal=1, watched=2};

struct dynDataOld {
	uint id, idRef;
	Importance imp;
	bool read;
	short thrLevel;
};

struct dynDataNew {
	uint id, idRef;
	bool read;
	short thrLevel, score;
};

void convert011();

void convert(const char *ver)
{
	if(
			(strcmp(ver, "0.1.1")==0) ||
			(strcmp(ver, "0.1")==0)				) convert011();
			
	else if((strcmp(ver, "0.1.5")==0) ||
					(strcmp(ver, "0.1.6")==0)	||
					(strcmp(ver, "0.1.7")==0) ||
					(strcmp(ver, "0.1.8")==0)
					)
					
					debug("Your files are up to date. No need to convert.");
					
	else {
		debug("Unknown version : %s", ver);
		exit(1);
	}
}



void convert011()
{
	QList<dynDataNew> newList;
	newList.setAutoDelete(true);
	
	QFile f;
	QString fName;
	QStrList *entries;
	dynDataOld oldDat;
	dynDataNew *newDat;
			
	QDir d=QDir::home();
	d.cd(".knode");
	entries=(QStrList*)d.entryList("*.grp", QDir::Dirs);
	
	if(!d.cd("Filters")) {
		d.mkdir("Filters");
	  QString cmd="cp " + kapp->kde_datadir() + "/knode/filters/* ";
		cmd+=knDir()+"Filters/";
		
		system(cmd);
	}		
	
	for(char *var=entries->first(); var; var=entries->next()) {
		
	  newList.clear();
		fName=knDir();
		fName+=var;
		fName+="/dynamic";
		
		f.setName(fName);
		
		if(f.open(IO_ReadOnly)) {
		  	
			while(!f.atEnd()) {
		  	
				f.readBlock((char*) &oldDat, sizeof(dynDataOld));
		  		
				newDat=new dynDataNew;
		 		newDat->id=oldDat.id;
		 		newDat->idRef=oldDat.idRef;
		 		newDat->thrLevel=oldDat.thrLevel;
		 		newDat->read=oldDat.read;
		 		newDat->score=50;
		  		
		 		newList.append(newDat);
		 	}
		  	
		 	f.close();
		
		 	if (f.open(IO_WriteOnly)) {	  		
		 		for(dynDataNew *var=newList.first(); var; var=newList.next())
		 			f.writeBlock((char*) var, sizeof(dynDataNew));
		 	  f.close();
		 	  debug("%s : converted successfully !", fName.data());
		 	}
		  			
		 	else {
		 		debug("Could not open new file in %s !!", var);
		 	  exit(1);
		 	}
		}
		
		else {
			debug("Could not read file in %s !!", var);
		  exit(1);
		}
		  	
	}		
		  		


}






