/***************************************************************************
                          nodewidget.cpp  -  A simple netconfig tool
                             -------------------
    begin                : Thu Oct 7 1999
    copyright            : (C) 1999 by Federico David Sacerdoti
    email                : fds@slinuxmachines.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "nodewidget.h"
#include <qpainter.h>
//#include <qcolor.h>
#include <qpixmap.h>


nodeWidget::nodeWidget(compass bearing, QWidget *parent, const char *name) :
	QWidget(parent, name),
	finding(false),
	timerCount(0),
	bearing(bearing),
	linklength(50)
{
	// link length defaults to 50. Add other length calculations here.
}

nodeWidget::~nodeWidget(){
}


void nodeWidget::paintEvent( QPaintEvent *e )
{
	QRect updateR = e->rect();
	QPainter p;
	p.begin(this);
	
	if ( updateR.intersects(nodeRect()) )
		paintNode(p);	
	if ( updateR.intersects(linkRect()) )
		paintLink(p);
	p.end();
}

void nodeWidget::paintNode (QPainter & p)
{	
	QRect nodeR = nodeRect();
	QColor salmon(250, 128, 114);
	QColor midnightblue(25,25,112);
	QColor postit(250,250,200);
	
	//Draw outer circle	
	p.setBrush(salmon);
	p.setPen(NoPen);
	p.drawEllipse( nodeR );
	
	//Draw inner circle
	QRect sR;
	sR.setWidth ( nodeR.width() - 2 );
	sR.setHeight( nodeR.height() - 2 );
	sR.moveCenter( nodeR.center() );
	p.setBrush(postit);
	p.drawEllipse(sR);
	
	//Draw name (only 2 letters will fit)
	p.setPen (midnightblue);
	//QRect tR = p.fontMetrics().boundingRect(name(), 2);
	p.drawText(sR, AlignCenter, name(), 2);
}

void nodeWidget::paintLink ( QPainter & p)
{
	QColor darkgreen(0, 100, 0);
	QRect lr = linkRect();
	QPixmap pix ( lr.size() );
	QPainter tmp;
	
	pix.fill (this, lr.topLeft() );
	
	tmp.begin( &pix );
 	tmp.setBrush(darkgreen);
 	tmp.setPen(NoPen);
 	tmp.drawRect ( rect() );
 	tmp.end();
 	
 	p.drawPixmap (lr.topLeft(), pix);
}

void nodeWidget::timerEvent ( QTimerEvent *)
{
	erase( linkRect() );
	// Wrap timerCount if past the length of link

	timerCount = (timerCount > linklength) ? 0 : timerCount+1;
	
	QRect linkR = linkRect();
	
	repaint( linkR );
}

void nodeWidget::ready()
{
	// Could be used, but I dont need it right now.
}

void nodeWidget::find()
{
	if (finding) return;
	timerCount = -1;
	erase ( linkRect() );
	finding = true;
	startTimer (50);
}

void nodeWidget::found()
{
	finding = false;
	killTimers();
	
	//Draw full link in green
	timerCount = -1;
	repaint ( linkRect() );	
	
}

void nodeWidget::lost()
{
	finding = false;
	erase( linkRect() );
	killTimers();
	
	// Draw text 'Broken!' in red halfway across link
	timerCount = -1;
	QRect lR = linkRect();
	QPainter p;
	
	p.begin(this);
	p.setPen (red);
	p.drawText(lR, AlignCenter, "X");
	p.end();
}

void nodeWidget::reset()
{
	timerCount = -1;
	erase( linkRect() );
}

QRect nodeWidget::linkRect () const
{
	QRect l;
	QRect s;
	QRect n = nodeRect();
	

	switch (bearing) {
  	case North: //Link pointing up
  		l = QRect(n.left() + 5, n.top() - timerCount - 2, n.width() - 10, timerCount);
  		s = QRect(n.left() + 5, n.top() - 2, n.width() - 10, height() - n.height() - 4);
  		break;
  		
		case South:   //Link pointing down
			//l = QRect(n.left() + 5, n.bottom() + 2, n.width() - 10, timerCount);
			l = QRect(n.left() + 5, n.bottom() + timerCount + 2, n.width() - 10, timerCount);
			s = QRect( n.left() + 5, n.bottom() + 2, n.width() - 10, height() - n.height() - 4);
	    break;
	
	  case East:   //Link pointing right
			//l = QRect(n.right() + 2, n.top() + 5, timerCount, n.height() - 10);
			l = QRect(n.right() + 2 + timerCount, n.top() + 5, timerCount, n.height() - 10);
			s = QRect(n.right() + 2, n.top() + 5, width() - n.width() - 4, n.height() - 10);
  		break;
  	
  	case West:
  		l = QRect(n.left() - timerCount, n.top() + 5, timerCount, n.height() - 10);
  		s = QRect(n.left(), n.top() + 5, width() - n.width() - 4, n.height() - 10);
  		break;
  }

	if (timerCount < 0) return s;   //Solid Link
	// Animated link
	return l;
}


QRect nodeWidget::nodeRect() const
{
	QRect r;
	
	switch (bearing) {
		case North:
			r = QRect(0,height() - width(),width(),width());
			break;
		case South:
			r = QRect(0,0,width(),width());
			break;
		case East:
			r = QRect(0,0,height(),height());
			break;
		case West:
			r = QRect(width() - height(),0,height(),height());
			break;
	}		
	return r;		
}	





















































