/***************************************************************************
                          kcmkeafnode3.cpp  -  description                              
                             -------------------                                         
    begin                : Tue Aug 10 1999                                           
    copyright            : (C) 1999 by Guenter Schwann                         
    email                : vogel@ibk.dyn.priv.at                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <qwidget.h>
#include <qlayout.h>
#include <qstring.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qdir.h>

#include <kapp.h>
#include <kconfig.h>

#include "kcmkeafnode3.h"


KDEkeafConfig3::KDEkeafConfig3(Parser *p, QWidget *parent, const char *name)
    : KConfigWidget(parent, name)
{
 pars=p;

 QDir qd("/var/spool/news/interesting.groups");
 if (qd.exists())
 {
  qd.setFilter(2);
  qstl=qd.entryList();
 }

 QVBoxLayout *top_lay = new QVBoxLayout(this, 10);

 QHBoxLayout *h1_lay = new QHBoxLayout();
 top_lay->addLayout(h1_lay);

 qlv = new QListView(this);
 qlv->setFixedSize(350,200);
 qlv->addColumn("news-group",270);
 qlv->addColumn("expire",60);
 connect(qlv,SIGNAL(selectionChanged(QListViewItem*)),this,SLOT(newCurrent(QListViewItem*)));

 QListViewItem *qlvi;
 qstl->first();
 while (qstl->current()!=0)
 {
  qlvi = new QListViewItem(qlv);
  qlvi->setText(0,qstl->current());
  qlvi->setText(1,"default");
  qstl->next();
 }

 h1_lay->addWidget(qlv);
 top_lay->addStretch(1);

 QHBoxLayout *h2_lay = new QHBoxLayout();
 top_lay->addLayout(h2_lay);

 qle = new QLineEdit(this);
 qle->setFixedSize(260,25);
 top_lay->addStretch(1);
 h2_lay->addWidget(qle);

 kil = new KIntegerLine(this);
 kil->setFixedSize(60,25);
 h2_lay->addWidget(kil);

 QHBoxLayout *h3_lay = new QHBoxLayout();
 top_lay->addLayout(h3_lay);

 qpb = new QPushButton(this,"ok");
 qpb->setFixedSize(100,28);
 qpb->setText("Apply");
 h3_lay->addStretch(1);
 h3_lay->addWidget(qpb);
 h3_lay->addStretch(1);
 top_lay->addStretch(1);
 connect(qpb,SIGNAL(pressed()),this,SLOT(okPressed()));

 citem=0;

 loadSettings();
}


KDEkeafConfig3::~KDEkeafConfig3()
{
}

void KDEkeafConfig3::loadSettings()
{
 QStrList gex, tex;
 QString st, gst;
 QListViewItem *item;

 conf_file=pars->CFileName();

 gex=pars->ExpireGroups();
 tex=pars->ExpireTimes();

 item=qlv->firstChild();

 while (item!=0)
 {
  gex.first();
  tex.first();
  st=item->text(0);
  while(gex.current()!=0)
  {
   gst=gex.current();
   if (gst.contains("*")==1)
   {
    if ( st.contains(gst.left(gst.length()-1)) )
     item->setText(1,tex.current());
    gex.next();
    tex.next();
   }
   else
   {
    if (gst==st)
    {
     item->setText(1,tex.current());
     gex.remove();
     tex.remove();
    }
    gex.next();
    tex.next();
   }
   item->repaint();
  }
  item=item->nextSibling();
 }

 gex.first();
 tex.first();

 QListViewItem *it;

 while (gex.current()!=0)
 {
  it = new QListViewItem(qlv);
  it->setText(0,gex.current());
  it->setText(1,tex.current());
  gex.next();
  tex.next();
 }

 updateSettings();
}


void KDEkeafConfig3::applySettings()
{
 FILE *f;
 QString s, st, gt, et;
 QListViewItem *tmp;


  conf_file=pars->CFileName();
 if ((f=fopen(conf_file.data(),"a"))!=0)
 {
  fprintf(f,"\n\n## Non-standard expire times (glob(7) wildcard constructs possible)\n");
  fprintf(f,"# groupexpire comp.os.linux.* = 5 # groups too big to hold articles 20 days\n");
  fprintf(f,"# groupexpire any.local.newsgroup = 100 # very interesting, hold articles longer\n");

  tmp=qlv->firstChild();
  while(tmp!=0)
  {
   st=tmp->text(1);
   if (st!="default")
   {
    st=tmp->text(0);
    if (st.contains(gt.data())==1)
    {
     s=tmp->text(1);
     if (s!=et)
     {
      s="groupexpire "+st+" = ";
      st=tmp->text(1);
      s=s+st+"\n";
      fprintf(f,s.data());
     }
    }
    else
    {
     s="groupexpire "+st+" = ";
     st=tmp->text(1);
     s=s+st+"\n";
     fprintf(f,s.data());
    }
    st=tmp->text(0);
    if (st.contains("*")==1)
    {
     gt=tmp->text(0);
     gt=gt.left(gt.length()-1);
     et=tmp->text(1);
    }
   }
   tmp=tmp->nextSibling();
  }

  fclose(f);
 }
 else printf("Error opening file!");
}

void KDEkeafConfig3::defaultSettings()
{
    updateSettings();
}

void KDEkeafConfig3::updateSettings()
{
}

void KDEkeafConfig3::newCurrent(QListViewItem *it)
{
 citem=it;
 qle->setText(citem->text(0));
 QString qst=citem->text(1);
 kil->setValue(qst.toInt());
}

void KDEkeafConfig3::okPressed()
{
 QString gn, gn1, its, val, valtmp;
 QListViewItem *itmp;
 if (citem!=0) valtmp=citem->text(1);
  else valtmp="nix";
 if (citem!=0) gn=citem->text(0);
  else gn="nIx";
 if (kil->value()!=0)
  val.setNum(kil->value());
 else
  val="default";
 if (gn==qle->text())
  citem->setText(1,val);
 else
 {
  QListViewItem *it;
  it = new QListViewItem(qlv);
  it->setText(0,qle->text());
  it->setText(1,val);
  citem=it;
  qlv->setCurrentItem(citem);
  valtmp="new";
 }
 gn=qle->text();
 gn1=gn.left(gn.length()-1);
 if (gn.contains("*")==1)
 {
  itmp=qlv->firstChild();
  while(itmp!=0)
  {
   its=itmp->text(0);
   its=its.left(gn1.length());
   if (gn1==its)
    if (valtmp==itmp->text(1)) itmp->setText(1,val);
    else
     if (valtmp=="new") itmp->setText(1,val);
   itmp=itmp->nextSibling();
  }
 }

}


