/*
 * Implements the "CdPlayPanel"
 *
 * $Id $
 *
 */

#include "playpanel.h"
#include "playpanel.moc"


CdPlayPanel::CdPlayPanel( Cdrom *aCdrom, QWidget *parent=0 )
  : QWidget( parent, "PlayPanel" ) 
{
  cdrom = aCdrom;

  curTrack = 0;
  _locked = false;


  setFixedSize( 124, 170 );
  
  int PB_H = 30;
  int PB_Y = 70;
  
  playPB = new QPushButton( "play", this );
  playPB->setGeometry( 2, PB_Y, 80, PB_H );
  stopPB = new QPushButton( "stop", this );
  stopPB->setGeometry( 82, PB_Y, 40, PB_H );
  prevPB = new QPushButton( "<-<-", this );
  prevPB->setGeometry( 2, PB_Y+PB_H, 60, PB_H );
  nextPB = new QPushButton( "->->", this );
  nextPB->setGeometry( 62, PB_Y+PB_H, 60, PB_H );
  ejectPB = new QPushButton( "eject", this );
  ejectPB->setGeometry( 2, PB_Y+2*PB_H, 120, PB_H );

  // need to add pixmaps here.....
  // text-buttons are REALLY ugly !


  connect( playPB, SIGNAL( clicked() ), this, SLOT( playPressed()  ) );
  connect( stopPB, SIGNAL( clicked() ), this, SLOT( stopPressed()  ) );
  connect( nextPB, SIGNAL( clicked() ), this, SLOT( nextPressed()  ) );
  connect( prevPB, SIGNAL( clicked() ), this, SLOT( prevPressed()  ) );
  connect(ejectPB, SIGNAL( clicked() ), this, SLOT( ejectPressed() ) );
	   
  
  // and now some labels

  BW_LED_Number *tmpLed = make_BW_LED( 60-14, ":" );
  // tmpLed->display( 0 );

  infoMin1 = make_BW_LED( 2,  "minutes1" );
  infoMin1->display( 0 );
  infoMin2 = make_BW_LED( 27, "minutes2" );
  infoMin2->display( 0 );
 
  infoSec1 = make_BW_LED( 69, "seconds1" );
  infoSec1->display( 0 );
  infoSec2 = make_BW_LED( 94, "seconds2" );
  infoSec2->display( 0 );

  QColor color( 225, 225, 255 );
  QColorGroup colgrp( color, black, color, color, color, color, white ); 

  infoStatus = new QLabel( this, "status" );
  infoStatus->setBackgroundColor( QColor( 0, 0, 0 ) );
  infoStatus->setPalette( QPalette( colgrp, colgrp, colgrp ) );
  infoStatus->setGeometry( 2, 47, 80, 18 );
  infoStatus->setText( " Ready" );
  infoTrack = new QLabel( this, "track" );
  infoTrack->setPalette( QPalette( colgrp, colgrp, colgrp ) );
  infoTrack->setGeometry( 80, 47, 42, 18 );

  updateDisplay();
  oldStatus = Ready;
  startTimer( 1000 );
}

CdPlayPanel::~CdPlayPanel()
{
  killTimers();
}


QSize CdPlayPanel::sizeHint() const
{
  return minimumSize();
}

BW_LED_Number *CdPlayPanel::make_BW_LED( int x, char *name = 0 )
{
  BW_LED_Number *led = new BW_LED_Number( this, name );
  led->setGeometry( x, 0, 28, 47 );
  // led->setSmallLED( TRUE );
  led->setLEDoffColor( QColor( 0, 0, 0 ) );
  led->setLEDColor( QColor( 224, 224, 255 ), QColor( 0, 0, 0 ) );
  return led;
}

void CdPlayPanel::disable()
{
}

void CdPlayPanel::enable()
{
}

void CdPlayPanel::playPressed()
{
}

void CdPlayPanel::stopPressed()
{
}

void CdPlayPanel::nextPressed()
{
  if( curTrack+1 < cdrom->trackCount() ) {
    curTrack++;
    updateDisplay();
    emit skip( curTrack );
  }
}

void CdPlayPanel::prevPressed()
{
  if( curTrack > 0 ) {
    curTrack--;
    updateDisplay();
    emit skip( curTrack );
  }
}

void CdPlayPanel::ejectPressed()
{
  if ( _locked ) { emit lockFault(); }
  else {
    cdrom->openTray();
  };
}

void CdPlayPanel::updateDisplay()
{
  QString tmp;
  
  tmp.sprintf("%02d/%02d", curTrack+1, cdrom->trackCount() );
  infoTrack->setText( tmp );
  
}

void CdPlayPanel::lock( bool lockNow )
{
  _locked = lockNow;
}

bool CdPlayPanel::isLocked()
{
  return _locked;
}

void CdPlayPanel::timerEvent( QTimerEvent *e )
{
  CdPanelStatus status = Ready;

  if ( cdrom->isReady() ) {
  } else {
    status = NotReady;
  };
    
  if ( status != oldStatus ) {
    oldStatus = status;
    emit statusChange( status );
  };
}
