/* $Id: krootpict.cpp,v 1.1.1.1 1998/07/03 14:28:27 matt Exp $
   $Log: krootpict.cpp,v $
   Revision 1.1.1.1  1998/07/03 14:28:27  matt
   Imported sources


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/


#include <time.h>
#include <stdlib.h>

#include <qfile.h>

#include <kapp.h>

#include "krootpict.h"
#include "docking.h"
#include "version.h"

DockWidget *pdock;
KRootPict *proot;


KConfig *config;

int main( int argc, char **argv ) {
  KApplication a( argc, argv, "krootpict" );

  config = a.getConfig();

  time_t now = time(NULL);
  srand((unsigned int)now);	/* randomize */

  proot = new KRootPict();
  pdock = new DockWidget("dockw");

  a.setMainWidget(proot);

  return a.exec();
}


KRootPict::KRootPict(const char *name) : KTopLevelWidget(name) {
  initMetaObject();

  this->setCaption( "KRootPict "KROOTPICTVERSION );
  this->resize( 333, 245 );

  QLabel *tmp1 = new QLabel ( this, "");
  tmp1->setGeometry( 8, 12, 61, 29 );
  tmp1->setText( "Filename :" );

  QLabel *tmp2 = new QLabel ( this, "");
  tmp2->setGeometry( 8, 92, 81, 29 );
  tmp2->setText( "Timer Delay :" );

  linedFilename = new QLineEdit ( this, "QLineEdit1" );
  linedFilename->setGeometry( 80, 12, 245, 29 );
  linedFilename->setText( "" );
  linedFilename->setFrame( TRUE );

  linedTimerDelay = new KIntegerLine ( this, "QLineEdit2" );
  linedTimerDelay->setGeometry( 100, 92, 39, 29 );
  linedTimerDelay->setFrame( TRUE );

  QLabel *tmp10 = new QLabel ( this, "");
  tmp10->setGeometry( 150, 92, 40, 29 );
  tmp10->setText( "min" );

  linedCommand = new QLineEdit ( this, "QLineEdit3" );
  linedCommand->setGeometry( 80, 52, 245, 29 );
  linedCommand->setFrame( TRUE );

  QLabel *tmp6 = new QLabel ( this, "");
  tmp6->setGeometry( 8, 52, 61, 29 );
  tmp6->setText( "Command :" );

  QLabel *tmp7 = new QLabel ( this, "");
  tmp7->setGeometry( 28, 144, 77, 81 );
  QString pixdir = KApplication::getKApplication()->kde_icondir();  
  QPixmap pm((pixdir + "/krootpict.xpm").data());
  tmp7->setPixmap( pm );

  QLabel *tmp8 = new QLabel ( this, "");
  tmp8->setGeometry( 140, 144, 173, 81 );
  tmp8->setText( "Copyright (c) 1998\nMatej Koss\nkoss@napri.sk" );

  QPushButton *tmp9 = new QPushButton ( this , "");
  tmp9->setGeometry( 240, 92, 69, 29 );
  tmp9->setText( "Ok" );
  tmp9->setToggleButton( FALSE );

  connect(tmp9, SIGNAL(clicked()), this, SLOT(slotOK()));

  readSettings();

  clocktimer = new QTimer(this);
  connect(clocktimer, SIGNAL(timeout()), SLOT(timeclick()));
  clocktimer->start( timerDelay );

  timeclick(); // Initial picture - do not wait for delay

}



KRootPict::~KRootPict() {
  clocktimer->stop();

  delete linedFilename;
  delete linedTimerDelay;
  delete linedCommand;
  delete clocktimer;

}


void KRootPict::slotOK() {
  command = linedCommand->text();
  timerDelay = linedTimerDelay->value() * 60000;
  picturesFile = linedFilename->text();

  clocktimer->stop();
  clocktimer->start( timerDelay );

  writeSettings();
  this->hide();
}



void KRootPict::timeclick() {
  QFile f(picturesFile);
  int i, cnt = 0;

  if ( f.open(IO_ReadOnly) ) {
    QTextStream t( &f );

    QString s;

    while ( !t.eof() ) {      // count the lines in the file
      s = t.readLine();
      cnt++;
    }

    cnt -= 2;
    f.reset();    // return to the beginning of the file

    i=rand()%cnt;

    while ( --i >= 0)
      t.readLine();

    s = command + " " + t.readLine();
    warning( s );
    system( (const char *)s );
    f.close();

    clocktimer->stop();
    clocktimer->start( timerDelay );
  }
}



void KRootPict::readSettings() {

  config->setGroup("Misc");
  timerDelay = config->readNumEntry("TimerDelay", 300000 ); // 5 minutes
  picturesFile = config->readEntry("PicturesFile", "/usr/local/etc/rndpics");
  command = config->readEntry("Command", "xv -root -quit");
}


void KRootPict::writeSettings() {

  config->setGroup("Misc");
  config->writeEntry("TimerDelay", timerDelay );
  config->writeEntry("PicturesFile", picturesFile );
  config->writeEntry("Command", command );

  config->sync();
}


void KRootPict::settings() {
  linedCommand->setText( command );
  linedTimerDelay->setValue( timerDelay / 60000 );
  linedFilename->setText( picturesFile );

  this->show();
}


void KRootPict::quit() {
  writeSettings();
  KApplication::getKApplication()->quit();
}


void KRootPict::closeEvent( QCloseEvent * ){
  this->hide();
}
