/*
 *   khexedit - Versatile hex editor
 *   Copyright (C) 1999  Espen Sand, espensa@online.no
 *   This file is based on the work by F. Zigterman, fzr@dds.nl
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _PRINTER_DIALOG_H_
#define _PRINTER_DIALOG_H_

#include <qbttngrp.h>
#include <qcombo.h>
#include <qchkbox.h>
#include <qframe.h>
#include <qlabel.h>
#include <qlayout.h> 
#include <qlined.h>
#include <qlistview.h>
#include <qpushbt.h>
#include <qradiobt.h>
#include <qspinbox.h>
#include <qprinter.h>
#include <qpaintdevicemetrics.h>

#include <ksimpleconfig.h>

#include "../pagedialog.h"
#include "advancedprinter.h"

class CPrinterDialog : public CPageDialog
{
  Q_OBJECT

  public:
    enum EPage
    {
      page_destination = 0,
      page_option,
      page_layout,
      page_max,
    };

    struct SPageSize
    {
      unsigned short width;
      unsigned short height;
    };

    CPrinterDialog( AdvancedPrinter *printer, const char *title, QWidget *parent = 0, char *name = 0, bool modal = FALSE );
    ~CPrinterDialog( void );
    void writeConfiguration( void );

  public slots:

  signals:
//    void printPostscript( CHexPrinter & );
//    void printText( CHexPrinter &, const QString & );

  protected slots:
    virtual void slotHelp( void );
    virtual void slotPrint( void );
    virtual void slotPreview( void );
 
  protected:
    void timerEvent( QTimerEvent *e );
  	/** set the print parameter */
  	bool setPrintParameter(bool preview);
  	bool stringToOffset( const char *text, uint &offset );

  private:
    struct SDestinationWidgets
    {
      QLabel       *printerLabel;
      QListView    *printerList;
      QCheckBox    *fileCheck;
      QLineEdit    *fileInput;
      QPushButton  *browseButton;
      QRadioButton *allRadio;
      QRadioButton *selectRadio;
      QRadioButton *rangeRadio;
      QLabel       *toLabel;
      QLabel       *fromLabel;
      QLineEdit    *toInput;
      QLineEdit    *fromInput;
      QRadioButton *postscriptRadio;
      QRadioButton *textRadio;
      QLabel       *helpLabel;
    };
    struct SOptionWidgets 
    {
      QLabel       *paperSizeLabel;
      QButtonGroup *oriGroup;
      QRadioButton *portraitRadio;
      QRadioButton *landscapeRadio;
      QButtonGroup *colorGroup;
      QRadioButton *colorRadio;
      QRadioButton *grayRadio;
      QRadioButton *bwRadio;
      QComboBox    *paperSelector;
      QSpinBox     *pageSpin;
      QRadioButton *firstRadio;
      QRadioButton *lastRadio;
      QCheckBox    *scaleCheck;
      QLineEdit    *previewInput;
      QPushButton  *browseButton;

    };
    struct SLayoutWidgets
    {
      QSpinBox     *marginSpin[4];
      QCheckBox    *headerCheck;
      QCheckBox    *footerCheck;
      QLabel       *headerLabel[4];
      QComboBox    *headerCombo[4];
      QLabel       *footerLabel[4];
      QComboBox    *footerCombo[4];
    };

  private slots:
    void printFileCheck( void );
    void browserClicked( void );
    void printRangeClicked( int id );
    void textFormatClicked( int id );
    void paperTypeChanged( int id );
    void appBrowserClicked( void );
    void slotDrawHeader( bool state );
    void slotDrawFooter( bool state );

  private:
    void setupDestinationPage( void );
    void setupOptionPage( void );
    void setupLayoutPage( void );

    void readConfiguration( void );
    const char *headerText( uint index );
    const char *headerLine( uint index );
    int headerTextIndex( const char *headerText );
    int headerLineIndex( const char *headerLine );

    bool parsePrintcap( void );
    void addPrinterName( const QString &printer );
    void setSelectedPrinter( const QString &name );
    void paperType( QStrList &list );
    const SPageSize paperSize( QPrinter::PageSize pageSize );

  private:
    QFrame *mFrame[ page_max ];
    SDestinationWidgets  mDestination;
    SOptionWidgets mOption;
    SLayoutWidgets mLayout;
    KSimpleConfig *mConfig;

    AdvancedPrinter *mPrinter;
};

#endif









