/***************************************************************************
                          csearchanalysis.cpp  -  description
                             -------------------
    begin                : Thu Sep 2 1999
    copyright            : (C) 1999 by Torsten Uhlmann
    email                : TUhlmann@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "csearchanalysis.h"

//kde includes
#include <kapp.h>

CSearchAnalysis::CSearchAnalysis(QWidget *parent, const char *name, QStrList *resultList ) : QScrollView(parent,name)
{
	maxCount=0;
	//if list is null quit this function -> no analyse
	if (resultList != 0)
		list = resultList ;
	else
		return;		
	
	//initialize chartWidget
	chartWidget= new CChartWidget( viewport() );
	chartWidget->setCaption(i18n("BibleTime - graphical analysis"));
	this->resize(500,350);
		
	//initialize some things of this class
	addChild( chartWidget );
	setResizePolicy( AutoOne );	
	lastListPos=0;
	
	this->analyse();
//	chartWidget->resize(AXES_SPACE+ BOOKS*(BAR_WIDTH+5)+10, maxCount+100);
}

CSearchAnalysis::~CSearchAnalysis()
{
	if (chartWidget)
		delete chartWidget;
}

/** Implementation of the resize event.
Change the size of the chartWIdget to the viewed
size of this widget. */
void CSearchAnalysis::resizeEvent(QResizeEvent *event)
{
	int w = chartWidget->width();
  int h = chartWidget->height();
  bool sizemodified = false;

  if(w < width())
  {
    w = width();
    sizemodified = true;
  }

  if(h < height())
  {
    h = height();
    sizemodified = true;
  }

  if(sizemodified)
    chartWidget->resize(w,h);

  // Call baseclass implementation of resizeEvent
  QScrollView::resizeEvent(event);
}

/** Starts analisung the list.
	* This function has to be optimized.
	*/
void CSearchAnalysis::analyse()
{
	QString bookname;
	int count=0;
	
	for (int index=0; index < BOOKS; index++)
	{
		bookname=getBookName( index );
		count=getCount( bookname );
		chartWidget->addBar( count, bookname );
		if (count > maxCount)
			maxCount=count;
	};
	
	chartWidget->setMaxCount(maxCount);
}

 /** Returns the bookname of the index number. */
QString CSearchAnalysis::getBookName( int number )
{
	switch (number)   	
	{
//old testament
		case (0):	return "Genesis";
		case (1):	return "Exodus";
		case (2):	return "Leviticus";
		case (3):	return "Number";
		case (4):	return "Deuteronomy";
		case (5):	return "Joshua";
		case (6):	return "Judges";
		case (7):	return "Ruth";		
		case (8):	return "I Samuel";
		case (9):	return "II Samuel";
		case (10):	return "I Kings";
		case (11):	return "II Kings";
		case (12):	return "I Chronicles";
		case (13):	return "II Chronicles";
		case (14):	return "Ezra";
		case (15):	return "Nehemiah";
		case (16):	return "Esther";
		case (17):	return "Job";
		case (18):	return "Psalms";
		case (19):	return "Proverbs";
		case (20):	return "Ecclesiastes";
		case (21):	return "Song of Solomon";
 		case (22):	return "Isaiah";
		case (23):	return "Jeremiah";
		case (24):	return "Lamentations";
		case (25):	return "Ezekiel";
		case (26):	return "Daniel";
		case (27):	return "Hosea";
		case (28):	return "Joel";
		case (29):	return "Amos";
		case (30):	return "Obadiah";
		case (31):	return "Jonah";
		case (32):	return "Micah";
		case (33):	return "Nahum";
		case (34):	return "Habakkuk";
		case (35):	return "Zephaniah";
		case (36):	return "Haggai";
		case (37):	return "Zechariah";
		case (38):	return "Malachi";
//new testament
		case (39):	return "Matthew";
		case (40):	return "Mark";
		case (41):	return "Luke";
		case (42):	return "John";
		case (43):	return "Acts";
		case (44):	return "Romans";
		case (45):	return "I Corinthians";
		case (46):	return "II Corinthians";
		case (47):	return "Galatians";
		case (48):	return "Ephesians";
		case (49):	return "Philippians";
		case (50):	return "Colossians";
		case (51):	return "I Thessalonians";
		case (52):	return "II Thessalonians";
		case (53):	return "I Timothy";
		case (54):	return "II Timothy";
		case (55):	return "Titus";
		case (56):	return "Philemon";
		case (57):	return "Hebrews";
		case (58):	return "James";		
		case (59):	return "I Peter";
		case (60):	return "II Peter";
		case (61):	return "I John";
		case (62):	return "II John";
		case (63):	return "III John";
		case (64):	return "Jude";
		case (65):	return "Revelation of John";
	  default:		return "unknown";
	};
}


/** Returns the count of the given bookname in the list. */
int CSearchAnalysis::getCount( QString bookname )
{
	int listCount = list->count();
	int finalCount=0;
	QString listEntry;

  //we can use this initialisation becuase lastListPos
  //is initialized with zero in the constructor

	for (int pos= lastListPos; pos < listCount; pos++)
	{
	//get the list entry
		listEntry = list->at( pos );
	//if the characters of the bookname are the same as
	//the first characters of the list entry add 1 to the found count.
		if ( listEntry.left(bookname.length()) == bookname)
			finalCount++;
	//if there was already something found
	//save the position in the list end quit the function
		else if (lastListPos < pos)
		{
			lastListPos = pos;
			break;
		}
	//there was previously nothing found
		else break;
	};
	return finalCount;
}
