/***************************************************************************
                          cresultlistbox.cpp  -  description                              
                             -------------------                                         
    begin                : Sat Jul 3 1999                                           
    copyright            : (C) 1999 by Torsten Uhlmann                         
    email                : TUhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "resource.h"
#include "cresultlistbox.h"

#include "gfx/csearchanalysis.h"

//LABEL_HEIGHT defines the height of the bottom label
#define LABEL_HEIGHT 25

CResultListBox::CResultListBox(QWidget *parent, const char *name ) : QListBox(parent,name)
{	
	popup = new QPopupMenu();

	popup->insertItem(ICON(ICON_ANALYSIS),i18n("graphical analysis"), this, SLOT(slotAnalyse()),0);
  popup->insertSeparator();
	
	QPopupMenu *savePopup = new QPopupMenu( 0 );
	savePopup->insertItem(ICON("mini-floppy.xpm"),i18n("save all to file"), this, SLOT(slotSaveAll()),0);
	savePopup->insertItem(ICON("mini-floppy.xpm"),i18n("save all with versetext"), this, SLOT(slotSaveAllWithText()));
	savePopup->insertSeparator();
	savePopup->insertItem(ICON("mini-floppy.xpm"),i18n("save current"), this, SLOT(slotSaveCurrent()));
	savePopup->insertItem(ICON("mini-floppy.xpm"),i18n("save current with versetext"), this, SLOT(slotSaveCurrentWithText()));

	QPopupMenu *copyPopup = new QPopupMenu( 0 );
	copyPopup->insertItem(ICON("mini-copy.xpm"),i18n("copy all to clipboard"), this, SLOT(slotCopyAll()));
	copyPopup->insertItem(ICON("mini-copy.xpm"),i18n("copy all to clipboard with versetext"), this, SLOT(slotCopyAllWithText()));
	copyPopup->insertSeparator();	
	copyPopup->insertItem(ICON("mini-copy.xpm"),i18n("copy current to clipboard"), this, SLOT(slotCopyCurrent()));
	copyPopup->insertItem(ICON("mini-copy.xpm"),i18n("copy current to clipboard with versetext"), this, SLOT(slotCopyCurrentWithText()));

	QPopupMenu *printPopup = new QPopupMenu( 0 );
	printPopup->insertItem(ICON("mini-print.xpm"),i18n("print current"), this, SLOT(slotPrintCurrent()));
	printPopup->insertItem(ICON("mini-print.xpm"),i18n("print current with versetext"), this, SLOT(slotPrintCurrentWithText()));
	printPopup->insertSeparator();	
	printPopup->insertItem(ICON("mini-print.xpm"),i18n("print all"), this, SLOT(slotPrintAll()));
	printPopup->insertItem(ICON("mini-print.xpm"),i18n("print all with versetext"), this, SLOT(slotPrintAllWithText()));
	
	popup->insertItem(ICON("mini-floppy.xpm"),i18n("Save ..."),savePopup);
	popup->insertItem(ICON("mini-copy.xpm"),i18n("Copy ..."),copyPopup);
	popup->insertItem(ICON("mini-print.xpm"),i18n("Print ..."),printPopup);
	
	tmpList = new QStrList;
}

CResultListBox::~CResultListBox()
{
	KDEBUG(KDEBUG_INFO, 0, "executing CResultListBox::~CResultListBox()");

	if (popup!=0)
		delete popup;
	if (tmpList!=0)
		delete tmpList;
	if (currentList!=0)
		delete currentList;
}

QPopupMenu* CResultListBox::getPopup()
{
	return popup;
}

void CResultListBox::mousePressEvent(QMouseEvent *e)
{
  if(e->button() == RightButton && this->count() > 0)
	{		
		popup->popup(mapToGlobal(e->pos()));
		
		QListBox::mousePressEvent(e);
	}
}

void CResultListBox::insertStrList(QStrList *list, int index = -1)
{
	QListBox::insertStrList(list, index);
	currentList = list;
};

void CResultListBox::slotSaveAll()
{
	emit sigSaveListToFile(currentList, false);
};

void CResultListBox::slotSaveAllWithText()
{
	emit sigSaveListToFile(currentList, true);
};

void CResultListBox::slotSaveCurrent()
{
	tmpList->clear();
	tmpList->append( text(currentItem()) );
	emit sigSaveListToFile(tmpList, false);
};

void CResultListBox::slotSaveCurrentWithText()
{
	tmpList->clear();
	tmpList->append( text(currentItem()) );
	emit sigSaveListToFile(tmpList, true);
};

void CResultListBox::slotCopyAll()
{
	emit sigCopyListToClipboard( currentList, false );
};

void CResultListBox::slotCopyAllWithText()
{
	emit sigCopyListToClipboard( currentList, true );
};

void CResultListBox::slotCopyCurrent()
{
	tmpList->clear();
	tmpList->append( text(currentItem()) );
	emit sigCopyListToClipboard( tmpList, false );
};

void CResultListBox::slotCopyCurrentWithText()
{
	tmpList->clear();
	tmpList->append( text(currentItem()) );
	emit sigCopyListToClipboard( tmpList, true );
};

void CResultListBox::slotPrintCurrent()
{
	tmpList->clear();
	tmpList->append( text(currentItem()) );
	emit sigPrintList( tmpList, false );
}

void CResultListBox::slotPrintCurrentWithText()
{
	tmpList->clear();
	tmpList->append( text(currentItem()) );
	emit sigPrintList( tmpList, true );
}

void CResultListBox::slotPrintAll()
{
	emit sigPrintList( currentList, false );
}

void CResultListBox::slotPrintAllWithText()
{
	emit sigPrintList( currentList, true );
}

/**
	*/
void CResultListBox::slotAnalyse()
{
	CSearchAnalysis *analysis=new CSearchAnalysis(0, "analysis", currentList);
	analysis->setCaption(i18n("BibleTime - graphical search analysis"));
	analysis->show();
}

/********************************************************************
*********************************************************************/

CResultWidget::CResultWidget(QWidget *parent, const char *name ) : QWidget(parent,name)
{
	this->setMinimumHeight( LABEL_HEIGHT +35);

	textLabel	= new QLabel (this,"textLabel");
	textLabel->setFrameStyle(QFrame::Box | QFrame::Raised);
	textLabel->setAlignment(AlignVCenter | AlignHCenter);
	textLabel->setMinimumHeight(LABEL_HEIGHT);

 	rList= new CResultListBox(this);

	connect(rList, SIGNAL(highlighted(int)),
					this, SLOT(slotHighlighted(int)));
	connect(rList, SIGNAL(sigSaveListToFile(QStrList *, bool)),
					this, SIGNAL(sigSaveListToFile(QStrList *, bool)));
	connect(rList, SIGNAL(sigCopyListToClipboard(QStrList*, bool)),
					this, SIGNAL(sigCopyListToClipboard(QStrList*, bool)));
	connect(rList, SIGNAL(sigPrintList(QStrList*, bool)),
					this, SIGNAL(sigPrintList(QStrList*, bool)));
}

CResultWidget::~CResultWidget()
{
	if (rList!=0)
		delete rList;
	if (textLabel!=0)
		delete textLabel;
}

void CResultWidget::setResult (QStrList *list)
{
	rList->clear();
	rList->insertStrList(list);
	
	QString dummy;	
	dummy=dummy.setNum( list->count() );
	if ( list->count()==1 )
		textLabel->setText (i18n("One entry found!"));
	else
		textLabel->setText(dummy + " " +i18n("entries found"));
};

void CResultWidget::clear()
{
	rList->clear();
	textLabel->setText("");
};

void CResultWidget::resizeEvent(QResizeEvent *evt)
{
 	rList->setGeometry(0, 0, this->width(), this->height() - LABEL_HEIGHT);
	textLabel->setGeometry(0, this->height() - LABEL_HEIGHT, this->width(), LABEL_HEIGHT);
};

void CResultWidget::slotHighlighted(int index)
{
	QString dummy;
	textLabel->setText( "Entry " +dummy.setNum(index + 1) +" of " + dummy.setNum( rList->count() ) );

//emit the signal highlighted to inform the parent widget
//a new chapter has to be displayed.
	emit highlighted( rList->text(index) );
};

