/***************************************************************************
               ceditwidget.cpp  -  a abstraction layer for an editwidget   
                             -------------------                                         

    begin                : 23 Aug 1998                                        
    copyright            : (C) 1998 by Sandy Meier                         
    email                : smeier@rz.uni-potsdam.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/
#include "ceditwidget.h"
#include <iostream.h>
#include "./kwrite/kwdoc.h"
#include "./kwrite/highlight.h"
#include <qpopupmenu.h>
#include <qclipboard.h>
#include <qregexp.h>
#include <assert.h>
#include <kapp.h>
#include <kiconloader.h>
#include <ksconfig.h>
#include <kmsgbox.h>

#include "resource.h"

HlManager hlManager; //highlight manager

CEditWidget::CEditWidget(KApplication*,QWidget* parent,char* name)
  : KWrite(new KWriteDoc(&hlManager),parent,name) {
  
  setFocusProxy (kWriteView); 
  pop = new QPopupMenu();
  pop->insertItem(Icon("undo.xpm"),i18n("Undo"),this,SLOT(undo()),0,ID_EDIT_UNDO);
  pop->insertItem(Icon("redo.xpm"),i18n("Redo"),this,SLOT(redo()),0,ID_EDIT_REDO);
  pop->insertSeparator();
  pop->insertItem(Icon("cut.xpm"),i18n("Cut"),this,SLOT(cut()),0,ID_EDIT_CUT);
  pop->insertItem(Icon("copy.xpm"),i18n("Copy"),this,SLOT(copy()),0,ID_EDIT_COPY);
  pop->insertItem(Icon("paste.xpm"),i18n("Paste"),this,SLOT(paste()),0,ID_EDIT_PASTE);
  pop->insertSeparator();
  pop->insertItem(Icon("lookup.xpm"),i18n("Check Spelling"),this,SLOT(spellcheck()),0,ID_EDIT_SPELLCHECK);
  pop->setItemEnabled(ID_EDIT_CUT,false);
  pop->setItemEnabled(ID_EDIT_COPY,false);
  pop->setItemEnabled(ID_EDIT_PASTE,false);
  bookmarks.setAutoDelete(true);

  kspell = 0;
}

CEditWidget::~CEditWidget() {
  delete doc();
}

void CEditWidget::setName(QString filename){
  KWrite::setFileName(filename);
}

QString CEditWidget::getName(){
  QString s(KWrite::fileName());
  if (s.isNull()) s = "";
  return s;
}
QString CEditWidget::text(){
  return KWrite::text();
}
void CEditWidget::setText(QString &text){
  KWrite::setText((text.isNull()) ? "" : (const char *) text);
}
QString CEditWidget::markedText(){
  return KWrite::markedText();
}
int CEditWidget::loadFile(QString filename, int mode) {
  KWrite::loadFile(filename);
  return 0;
}
void CEditWidget::doSave() {
  KWrite::save();
}
void CEditWidget::doSave(QString filename){
  KWrite::writeFile(filename);
}
void CEditWidget::copyText() {
  KWrite::copy();
}
void CEditWidget::setFocus(){
  KWrite::setFocus();
  kWriteView->setFocus();
}
void CEditWidget::gotoPos(int pos,QString text_str){
  
  // calculate the line
  QString last_textpart = text_str.right(text_str.size()-pos); // the second part of the next,after the pos
  int line = text_str.contains("\n") - last_textpart.contains("\n");
  //  cerr << endl << "LINE:" << line;
  setCursorPosition(line,0);
  setFocus();
}
void CEditWidget::toggleModified(bool mod){
  KWrite::setModified(mod);
}
void CEditWidget::search(){
  KWrite::search();
}
void CEditWidget::searchAgain(){
  KWrite::searchAgain();
}
void CEditWidget::replace(){
  KWrite::replace();
}
void CEditWidget::gotoLine(){
  KWrite::gotoLine();
}
void CEditWidget::indent(){
  KWrite::indent();
}
void CEditWidget::unIndent(){
  KWrite::unIndent();
}
void CEditWidget::invertSelection(){
  KWrite::invertSelection();
}
void CEditWidget::deselectAll(){
  KWrite::deselectAll();
}


void CEditWidget::spellcheck()
{
	KSpellConfig ksc; // = new KSpellConfig;
	kspell= new KSpell (this, "BibleTime: Spellcheck", this,
					SLOT (spellcheck2 (KSpell *)),&ksc);
		
}

void CEditWidget::spellcheck2(KSpell *)
{
	if (kspell->isOk())
	{

		//setReadOnly (true);
		connect (kspell, SIGNAL (misspelling (char *, QStrList *, unsigned)),
		 	this, SLOT (slotSpellWordMisspelled (char *, QStrList *, unsigned)));
		connect (kspell, SIGNAL (corrected (char *, char *, unsigned)),
			this, SLOT (slotSpellWordCorrected (char *, char *, unsigned)));
		connect (kspell, SIGNAL (progress (unsigned int)),
			this, SLOT (slotSpellProgress(unsigned int)) );
		connect (kspell, SIGNAL (done(char *)),
			this, SLOT (slotSpellDone (char *)));
	
		kspell->setProgressResolution (2);

		spellStr = text().copy();
		kspell->check (spellStr.data());
	
		//setReadOnly(false);
		
	} else {
		KMsgBox::message(this,"BibleTime: Error","Error starting KSpell.\n"\
			"Please make sure you have ISpell properly configured and in your PATH.", KMsgBox::STOP);
	}
}

void CEditWidget::slotSpellDone(char *)
{
  QString s = "Spellcheck:  Complete";
	emit sigStatusbarMsg(s.data());
}

void CEditWidget::slotSpellProgress(unsigned int percent)
{
  QString s;
  s.sprintf ("Spellcheck:  %d%% complete",percent);
	emit sigStatusbarMsg(s.data());
}

void CEditWidget::slotSpellWordCorrected (char *origword, char *newword, unsigned pos)
{
	spellStr.replace(pos,strlen(origword),newword);
	setText(spellStr);
}


void CEditWidget::slotSpellWordMisspelled (char *word, QStrList*, unsigned pos)
{
/*  int l;
  unsigned int cnt=0;

  for (l=0;l<numLines() && cnt<=pos;l++)
    cnt+=strlen (textLine(l))+1;
  l--;

  cnt=pos-cnt+strlen (textLine (l))+1;

*/
  //setCursorPosition (l, cnt);
	//setCursorPosition(0,0)

	//SConfig s;
	//searchAgain(s);
  //initSearch(s, searchFlags);
  //searchAgain(s);
  //exposeFound(cursor,slen,(s.flags & sfAgain) ? 0 : ufUpdateOnScroll,false);
	//QString t = text();
	//gotoPos(pos, t);
}

/** Insert the string at the supplied line. */
void CEditWidget::insertAtLine( const char *toInsert, uint atLine )
{
  assert( toInsert != NULL );
  assert( atLine >= 0 );
  
  uint line=0;
  int pos=0;
  QString txt;
  
  txt = text();
  while( line < atLine )
    {
    pos++;
    if( txt[ pos ] == '\n' )
      line++;
    }
  
  // Insert the text after the last return.
  txt.insert( pos + 1, toInsert );
  setText( txt );
}

/** Append a text at the end of the file. */
void CEditWidget::append( const char *toAdd )
{
  QString txt;
  
  txt = text();
  txt.append( toAdd );
  setText( txt );
}

/** Returns the number of lines in the text. */
uint CEditWidget::lines()
{
  return (uint)(text().contains('\n', false));
}


void CEditWidget::enterEvent ( QEvent * e){
  setFocus();
}

void CEditWidget::mousePressEvent(QMouseEvent* event){
  if(event->button() == RightButton){
    
    if(event->state() & ControlButton) {
      emit bufferMenu(this->mapToGlobal(event->pos()));
      return;
    }
    
    int state;
    int pos;
    state = undoState();
    //undo
    if(state & 1){
      pop->setItemEnabled(ID_EDIT_UNDO,true);
    }
    else{
      pop->setItemEnabled(ID_EDIT_UNDO,false);
    }
    //redo
    if(state & 2){
      pop->setItemEnabled(ID_EDIT_REDO,true);
    }
    else{
      pop->setItemEnabled(ID_EDIT_REDO,false);
    }
    
    QString str = markedText();
    if(!str.isEmpty()){
      pop->setItemEnabled(ID_EDIT_CUT,true);
      pop->setItemEnabled(ID_EDIT_COPY,true);
    }
    else{
      pop->setItemEnabled(ID_EDIT_CUT,false);
      pop->setItemEnabled(ID_EDIT_COPY,false);
    }		


    QClipboard *cb = kapp->clipboard();
    QString text=cb->text();
    if(text.isEmpty())
      pop->setItemEnabled(ID_EDIT_PASTE,false);
    else
      pop->setItemEnabled(ID_EDIT_PASTE,true);
    
    if(str == ""){
      str = word(event->x(),event->y());
    }

    searchtext = str;
    str.replace(QRegExp("^\n"), "");
    pos=str.find("\n");
    if (pos>-1)
     str=str.left(pos);

    if(str.length() > 20 ){
      str = str.left(20) + "...";
    }

    pop->setItemEnabled(ID_HELP_SEARCH_TEXT, !str.isEmpty());
    pop->setItemEnabled(ID_EDIT_SEARCH_IN_FILES, !str.isEmpty());

    pop->changeItem(Icon("grep.xpm"),i18n("grep: ") + str,ID_EDIT_SEARCH_IN_FILES); // the grep entry
    pop->changeItem(Icon("lookup.xpm"),i18n("look up: ") + str,ID_HELP_SEARCH_TEXT); // the lookup entry

    pop->popup(this->mapToGlobal(event->pos()));
  }
}

void CEditWidget::slotLookUp(){
    emit lookUp(searchtext);
}

