/***************************************************************************
           cdocbrowser.cpp - 
                             -------------------                                         

    begin                : 20 Jul 1998                                        
    copyright            : (C) 1998 by Sandy Meier                         
    email                : smeier@rz.uni-potsdam.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "cdocbrowser.h"
#include <iostream.h>
#include <X11/Xlib.h>

#include <qregexp.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qclipboard.h>

#include <kapp.h>
#include <kconfig.h>
#include <kmsgbox.h>
#include <kfm.h>
#include <kcolorbtn.h>
#include <kcursor.h>

#include "finddlg.h"
#include "resource.h"

int  CDocBrowser::fSize = 3;
QString CDocBrowser::standardFont;
QString CDocBrowser::fixedFont;
QColor 	CDocBrowser::bgColor;
QColor 	CDocBrowser::textColor;
QColor 	CDocBrowser::linkColor;
QColor 	CDocBrowser::vLinkColor;
bool CDocBrowser::underlineLinks;
bool CDocBrowser::forceDefaults;

CDocBrowser::CDocBrowser(QWidget*parent,const char* name) : KHTMLView(parent,name)
{
	searchDialog = new KFindTextDialog();
	connect (searchDialog, SIGNAL(find( const QRegExp& )), this, SLOT( slotSearchText( const QRegExp& )));
	connect (searchDialog, SIGNAL(sigCloseDialog()), this, SLOT( slotSearchTextEnd()));
					
	extensionList = new QStrList;
	commandList = new QStrList;
	currentText="";

	KConfig *config=kapp->getConfig();
	config->setGroup("Linkmanagement");
	config->readListEntry("Extensions",*extensionList);
	config->readListEntry("Commands", *commandList);


  doc_pop = new QPopupMenu();
 	lookup_pop=new QPopupMenu();
 	
  doc_pop->insertItem(Icon("mini-copy.xpm"),i18n("Copy marked text to clipboard"),this, SLOT(slotCopyText()),0,ID_EDIT_COPY);
  doc_pop->insertItem(Icon("mini-floppy.xpm"),i18n("Save displayed text as HTML"),this, SLOT(slotSaveAsHTMLFile()),0,ID_BROWSER_SAVE_AS_HTML);
  doc_pop->insertSeparator();
  doc_pop->insertItem(Icon("mini-print.xpm"),i18n("Print marked text without key"),this, SLOT(slotPrintTextWithoutKey()),0,ID_EDIT_PRINT_WITHOUT_KEY);
  doc_pop->insertItem(Icon("mini-print.xpm"),i18n("Print marked text with key"),this, SLOT(slotPrintTextWithKey()),0,ID_EDIT_PRINT_WITH_KEY);
  doc_pop->insertItem(Icon("find.xpm"),i18n("Search in text"),this, SLOT(slotSearchTextBegin()),0,ID_EDIT_SEARCH_TEXT);
  doc_pop->insertSeparator();
	doc_pop->insertItem(Icon("lookup.xpm"), "Lookup in", lookup_pop, ID_EDIT_LOOKUP);	
	
	connect(lookup_pop, SIGNAL(activated(int)), this, SLOT(slotPopupItemChosen(int)));
  connect( this, SIGNAL( popupMenu( KHTMLView *, const char *, const QPoint & ) ),
    this, SLOT( slotPopupMenu( KHTMLView *, const char *, const QPoint & ) ) );
	connect(this, SIGNAL( setTitle ( const char *) ), this, SLOT( slotSetFileTitle( const char*) ) );

		
	setDocBrowserOptions();
}

CDocBrowser::~CDocBrowser()
{
	if (doc_pop!=0) 			delete doc_pop;
	if (lookup_pop!=0)		delete lookup_pop;
	if (searchDialog!=0) 	delete searchDialog;
}

void CDocBrowser::buildSearchMenu( ModuleDefinitionList	*moList )
{
	QString mText = 0;
	_moduleList = moList;
	
	for (moList->first(); moList->current(); moList->next())
	{
		// check if Lexicon / Dictionary
		if ( moList->current()->type.contains("Lexicons / Dictionaries"))
		{
			mText = moList->current()->description;
  		lookup_pop->insertItem(mText);
  	}
	}
}

void CDocBrowser::slotPopupItemChosen(int idx)
{
	QString text		= lookup_pop->text(idx);
	QString search  = 0;
	QString moName	= 0;
	
	_moduleList->first();
	while ( _moduleList->current() )
	{
		// check if Lexicon / Dictionary
		if ( _moduleList->current()->type.contains("Lexicons / Dictionaries"))
		{
			if (text.contains(_moduleList->current()->description,false))
			{
 				getSelectedText(search);
 				if (!search.isEmpty())
 				{
 					debug("selected text is %s",search.data());
					moName = _moduleList->current()->name.copy();
  				emit sigSearchInModule(moName, search);
  				emit sigActivateModule(moName);
  			}
  			break;
  		}
  	}
 		_moduleList->next();
	}
}


void CDocBrowser::slotViewInKFM(){

    KProcess showHTML;
    showHTML << "kfmclient" << "openURL" << currentURL();
    showHTML.start(KProcess::DontCare);
}

void CDocBrowser::showURL(QString url,bool reload)
{
	QString url_wo_ref=url; // without ref
  QString ref;
  complete_url=url;
  int pos = url.findRev('#');
  int len = url.length();

  ref = (pos!=-1) ? (const char*) url.right(len - pos - 1) : "";
  m_refTitle = ref;

  if (pos!=-1)
   url_wo_ref = url.left(pos);

  KConfig *config= kapp->getConfig();
  config->setGroup("General Options");
	bool useKFM=config->readBoolEntry("useKFM", true);

	//file is an HTML file
	if ( url_wo_ref.right(4).find("htm", FALSE)!=-1 )
	{
		//open file in KFM. Don't ask it it's local or remote
  	if (useKFM)
		{
				KProcess showHTML;
				showHTML << "kfmclient" << "openURL" << url;
				showHTML.start(KProcess::DontCare);
				return;
		}
		else
		{
		  KHTMLWidget* htmlview;
		  htmlview=getKHTMLWidget();
			htmlview->setCursor( KCursor::waitCursor() );
		  QString str="";

			if ( complete_url.left(7) == "http://")
			{
			  if( (url_wo_ref != old_url) || reload)
			  {
			  	if (!old_file.isEmpty())
						KFM::removeTempFile(old_file);
			    KFM::download(url,str);
				}
				else
				{
					str = old_file;
				}	
			}
//			else if ( complete_url.left(7) == "file://")
//				str=complete_url.right (complete_url.length()-7);
				
			char buffer[256+1];
			QFile file(str) ;
			if(file.exists() && file.size()!=0)
			{
				file.open(IO_ReadOnly);
				QDataStream dstream ( &file );
				QString content;
		
				KURL u( url );	//we use KURL as described in the reference of KHTMLiew
				htmlview->begin( u.directoryURL() );
				while ( !dstream.eof() )
				{
					buffer[256]='\0';
					dstream.readRawBytes(buffer, 256);
					htmlview->write(buffer);
				}
				htmlview->end();
				htmlview->parse();
				htmlview->show();
				file.close();
			}
			else if (file.size() == 0)
			{
				debug("the file is empty");
			}
			else
			{
				KMsgBox::message(0,i18n("Not found!"),"file: \"" + str + i18n("\" not found!"),KMsgBox::INFORMATION);
				return;
			}
			htmlview->setCursor( KCursor::arrowCursor() );
		
		  if (pos != -1)
			{
		    gotoAnchor(ref);
		  }
		  else
		  {
		    if (url_wo_ref == old_url)
		     gotoXY(0,0);
		  }
		
		  if (url_wo_ref == old_url)
		  {
		     emit documentDone(this);  // simulate documentDone to put it in history...
		  }
		  old_url = url_wo_ref;
		  old_file = str;
	  }
	}
	//file is not an HTML file. Look for command to pass to
	else	
	{
		QString file_extension="";
		for (uint n=url_wo_ref.length(); n > 0; n--)
		{
			if ( url_wo_ref[n] == '.' )
			{
				file_extension=url_wo_ref.right( url_wo_ref.length()-n-1 );
				break;
			};
		};

		extensionList->first();
		commandList->first();
		while (extensionList->current() && commandList->current() )
		{
			if (extensionList->current() == file_extension)	
			{	
				process.clearArguments();
				process << commandList->current();
				process << url_wo_ref;
				debug("start external process");
				process.start(KProcess::DontCare);
				break;
			}
			else
			{
				extensionList->next();
				commandList->next();
			};
		};
		
	};
}




QString CDocBrowser::currentURL(){
  return complete_url;
}

void CDocBrowser::setDocBrowserOptions(){

  KConfig *config = KApplication::getKApplication()->getConfig();
  config->setGroup( "DocBrowserAppearance" );

  QString fs = config->readEntry( "BaseFontSize" );
  if ( !fs.isEmpty() )
	fSize = fs.toInt();
  fs = "times";
  standardFont = config->readEntry( "StandardFont", fs );

  fs = "courier";
  fixedFont = config->readEntry( "FixedFont", fs );

  bgColor = config->readColorEntry( "BgColor", &white );
  textColor = config->readColorEntry( "TextColor", &black );
  linkColor = config->readColorEntry( "LinkColor", &blue );
  vLinkColor = config->readColorEntry( "VLinkColor", &darkMagenta );
  underlineLinks = config->readBoolEntry( "UnderlineLinks", true );
  forceDefaults = config->readBoolEntry( "ForceDefaultColors", false );

  KHTMLWidget* htmlview;
  htmlview=getKHTMLWidget();
  htmlview->setDefaultFontBase( fSize );
  htmlview->setFixedFont( fixedFont);
  htmlview->setStandardFont( standardFont );
  htmlview->setURLCursor( KCursor::handCursor() );
  htmlview->setUnderlineLinks(underlineLinks);
  htmlview->setForceDefault( forceDefaults );
  htmlview->setDefaultBGColor( bgColor );
}

void CDocBrowser::slotDocFontSize(int size){
  KHTMLWidget* htmlview;
  htmlview=getKHTMLWidget();
  fSize = size;
  htmlview->setDefaultFontBase( size );
  htmlview->parse();
}

void CDocBrowser::slotDocStandardFont(const char* n){
  KHTMLWidget* htmlview;
  htmlview=getKHTMLWidget();
  standardFont = n;
  htmlview->setStandardFont( n );
  htmlview->parse();
}

void CDocBrowser::slotDocFixedFont(const char* n){
  KHTMLWidget* htmlview;
  htmlview=getKHTMLWidget();
  fixedFont = n;
  htmlview->setFixedFont( n );
  htmlview->parse();
}

void CDocBrowser::slotDocColorsChanged( const QColor &bg, const QColor &text,
	const QColor &link, const QColor &vlink, const bool uline)
{
  KHTMLWidget* htmlview;

  htmlview=getKHTMLWidget();
  htmlview->setDefaultBGColor( bg );
  htmlview->setDefaultTextColors( text, link, vlink );
  htmlview->setUnderlineLinks(uline);
  htmlview->parse();
}

void CDocBrowser::slotPopupMenu( KHTMLView *view, const char *url, const QPoint & pnt){
  if ( this->isTextSelected() ){
    doc_pop->setItemEnabled(ID_EDIT_COPY,true);
    doc_pop->setItemEnabled(ID_EDIT_PRINT_WITH_KEY,true);
    doc_pop->setItemEnabled(ID_EDIT_PRINT_WITHOUT_KEY,true);
    doc_pop->setItemEnabled(ID_EDIT_LOOKUP,true);
  }
  else{
    doc_pop->setItemEnabled(ID_EDIT_COPY,false);
    doc_pop->setItemEnabled(ID_EDIT_PRINT_WITH_KEY,false);
    doc_pop->setItemEnabled(ID_EDIT_PRINT_WITHOUT_KEY,false);
    doc_pop->setItemEnabled(ID_EDIT_LOOKUP,false);
  }
  doc_pop->popup(pnt);
}

void CDocBrowser::slotCopyText()
{
  QString text;
  getSelectedText( text );
  QClipboard *cb = kapp->clipboard();
  cb->setText( text );
}

void CDocBrowser::slotPrintTextWithKey()
{
  QString text;
  QString tmp = 0;
  getSelectedText( text );
	emit sigPrintText( tmp, true, text, true );
}

void CDocBrowser::slotPrintTextWithoutKey()
{
  QString text;
  QString tmp = 0;
  getSelectedText( text );
	emit sigPrintText( tmp, false, text, true );
}

void CDocBrowser::slotSearchTextBegin()
{
	findTextBegin();
	searchDialog->show();
}

void CDocBrowser::slotSearchTextEnd()
{
	findTextEnd();
}

void CDocBrowser::slotSearchText(const QRegExp &re)
{
	if (!findTextNext(re))
	{
		// We've reached the end of the document.
		// Can either stop searching and close the find dialog,
		// or start again from the top.
		if ( KMsgBox::yesNo( this, i18n( "Find Complete" ),
				i18n( "Continue search from the top of the page?" ),
				KMsgBox::DB_SECOND | KMsgBox::QUESTION ) == 1 )
		{
			findTextBegin();
			findTextNext( re );
		}	else {
			findTextEnd();
			searchDialog->hide();
		}
	}
}

void CDocBrowser::slotSetFileTitle( const char* title ){
	m_title= title;
}

QString CDocBrowser::currentTitle(){
	return (m_refTitle.isEmpty()) ? m_title : m_refTitle+" - "+m_title;	
}


void CDocBrowser::resizeEvent(QResizeEvent *event)
{
	KHTMLView::resizeEvent(event);
	this->calcScrollBars();
};



#if KDE_VERSION_RELEASE < 5
#warning Using own CDocBrowser::calcScrollBars() because KDE earlier than 1.1.2 is broken
/** This function is from kdecore, but with a removed scrollbar resizing bug */
void CDocBrowser::calcScrollBars()
{
  if ( view->docWidth() > view->width() && !isFrameSet() && scrolling )
		displayHScroll = TRUE;
  else
    displayHScroll = FALSE;

  if ( view->docHeight() > view->height() && !isFrameSet() && scrolling )
		displayVScroll = TRUE;
  else
    displayVScroll = FALSE;

  if ( displayVScroll && displayHScroll )
  {
		horz->setRange( 0, view->docWidth() + 16 - view->width() );
		if(horz->value() != view->xOffset())
	    horz->setValue( view->xOffset() );
		vert->setRange( 0, view->docHeight() - height() + 16 );
		if(vert->value() != view->yOffset())
	    vert->setValue( view->yOffset() );
  }
  else if ( displayHScroll )
  {
		horz->setRange( 0, view->docWidth() - view->width() );
		if(horz->value() != view->xOffset())
	    horz->setValue( view->xOffset() );
  }
  else if ( displayVScroll )
  {
		vert->setRange( 0, view->docHeight() - height() );
		if(vert->value() != view->yOffset())
	    vert->setValue( view->yOffset() );
  }

  int right = 0;
  if ( displayVScroll )
		right = 16;

  int bottom = 0;
  if ( !displayHScroll )
  {
		horz->hide();
		view->slotScrollHorz( 0 );
  }	
  else
  {
		bottom = 16;
		horz->setGeometry( 0, height() - 16, width() - right, 16 );
		horz->show();
		horz->raise();
  }

  if ( !displayVScroll )
  {
		vert->hide();
		view->slotScrollVert( 0 );
  }
  else
  {
		vert->setGeometry( width() - 16, 0, 16, height() - bottom );
		vert->show();
		vert->raise();
  }
}
#endif //KDE veraion checking

void CDocBrowser::slotRefreshLinkLists()
{
	KConfig *config=kapp->getConfig();
	config->setGroup("Linkmanagement");
	config->readListEntry("Extensions",*extensionList);
	config->readListEntry("Commands", *commandList);
}

void CDocBrowser::slotSaveAsTextFile()
{
	//at this moment this doesn't work properly. We have to convert first to plain text
	saveToFile( currentText );
}

/**  */
void CDocBrowser::slotSaveAsHTMLFile()
{
	saveToFile( currentText );
};

void CDocBrowser::write( const char* _text)
{
	currentText=_text;
	KHTMLView::write(_text);
}

QString CDocBrowser::getDisplayedText()
{
	return currentText;
}

/**  */
void CDocBrowser::saveToFile( QString text)
{
 	QString filename=	KFileDialog::getSaveFileName("","",this,"saveDialog");
 	if (filename.isEmpty())
 	{
 		KMsgBox::message(this, "BibleTime - save list", i18n("Sorry, but without a filename I can't save the list."), KMsgBox::INFORMATION, i18n("OK"));
 		return;
 	};
 	 	
	QFile file(filename);
	if (file.exists())
	{
		if (KMsgBox::yesNo(this, i18n("BibleTime - save list"), i18n("The file \"" +filename + "\" does already exist.\nDo you want to overwrite the file?"),\
			 KMsgBox::QUESTION, i18n("Yes"), i18n("No")) == 1) file.remove();
		else return;
	};
	
	if ( file.open(IO_ReadWrite) )
	{
		file.writeBlock( text, text.length());
		file.flush();
		file.close();
	}
	else KMsgBox::message(this,"BibleTime",i18n("Can't open the file. Perhaps you have to write access!\nPlease check this!"), 3, i18n("OK"));
}

//-----------------------------------------------------------------------------

CDocBrowserFont::CDocBrowserFont( QWidget *parent, const char *name )
	: QWidget( parent, name )
{
	readOptions();

	QRadioButton *rb;
	QLabel *label;

	QButtonGroup *bg = new QButtonGroup( i18n("Font Size"), this );
	bg->setExclusive( TRUE );
	bg->setGeometry( 15, 15, 300, 50 );

	rb = new QRadioButton( i18n("Small"), bg );
	rb->setGeometry( 10, 20, 80, 20 );
	rb->setChecked( fSize == 3 );

	rb = new QRadioButton( i18n("Medium"), bg );
	rb->setGeometry( 100, 20, 80, 20 );
	rb->setChecked( fSize == 4 );

	rb = new QRadioButton( i18n("Large"), bg );
	rb->setGeometry( 200, 20, 80, 20 );
	rb->setChecked( fSize == 5 );

	label = new QLabel( i18n("Standard Font"), this );
	label->setGeometry( 15, 90, 100, 20 );

	QComboBox *cb = new QComboBox( false, this );
	cb->setGeometry( 120, 90, 180, 25 );
	getFontList( standardFonts, "-*-*-*-*-*-*-*-*-*-*-p-*-*-*" );
	cb->insertStrList( &standardFonts );
	QStrListIterator sit( standardFonts );
	int i;
	for ( i = 0; sit.current(); ++sit, i++ )
	{
		if ( !strcmp( stdName, sit.current() ) )
			cb->setCurrentItem( i );
	}
	connect( cb, SIGNAL( activated( const char * ) ),
		SLOT( slotStandardFont( const char * ) ) );

	label = new QLabel( i18n( "Fixed Font"), this );
	label->setGeometry( 15, 130, 100, 20 );

	cb = new QComboBox( false, this );
	cb->setGeometry( 120, 130, 180, 25 );
	getFontList( fixedFonts, "-*-*-*-*-*-*-*-*-*-*-m-*-*-*" );
	getFontList( fixedFonts, "-*-*-*-*-*-*-*-*-*-*-c-*-*-*" );
	cb->insertStrList( &fixedFonts );
	QStrListIterator fit( fixedFonts );
	for ( i = 0; fit.current(); ++fit, i++ )
	{
		if ( !strcmp( fixedName, fit.current() ) )
			cb->setCurrentItem( i );
	}
	connect( cb, SIGNAL( activated( const char * ) ),
		SLOT( slotFixedFont( const char * ) ) );

	connect( bg, SIGNAL( clicked( int ) ), SLOT( slotFontSize( int ) ) );
}

void CDocBrowserFont::readOptions()
{
	KConfig *config = KApplication::getKApplication()->getConfig();
	config->setGroup( "DocBrowserAppearance" );
	
	QString fs = config->readEntry( "BaseFontSize" );
	if ( !fs.isEmpty() )
	{
		fSize = fs.toInt();
		if ( fSize < 3 )
			fSize = 3;
		else if ( fSize > 5 )
			fSize = 5;
	}
	else
		fSize = 3;

	stdName = config->readEntry( "StandardFont" );
	if ( stdName.isEmpty() )
		stdName = "times";

	fixedName = config->readEntry( "FixedFont" );
	if ( fixedName.isEmpty() )
		fixedName = "courier";
}

void CDocBrowserFont::writeOptions()
{
	this->slotApplyPressed();
};

void CDocBrowserFont::getFontList( QStrList &list, const char *pattern )
{
	int num;

	char **xFonts = XListFonts( qt_xdisplay(), pattern, 2000, &num );

	for ( int i = 0; i < num; i++ )
	{
		addFont( list, xFonts[i] );
	}

	XFreeFontNames( xFonts );
}

void CDocBrowserFont::addFont( QStrList &list, const char *xfont )
{
	const char *ptr = strchr( xfont, '-' );
	if ( !ptr )
		return;
	
	ptr = strchr( ptr + 1, '-' );
	if ( !ptr )
		return;

	QString font = ptr + 1;

	int pos;
	if ( ( pos = font.find( '-' ) ) > 0 )
	{
		font.truncate( pos );

		if ( font.find( "open look", 0, false ) >= 0 )
			return;

		QStrListIterator it( list );

		for ( ; it.current(); ++it )
			if ( it.current() == font )
				return;

		list.append( font );
	}
}

void CDocBrowserFont::slotApplyPressed()
{
	QString o;

	KConfig *config = KApplication::getKApplication()->getConfig();
	config->setGroup( "DocBrowserAppearance" );

	QString fs;
	fs.setNum( fSize );
	o = config->writeEntry( "BaseFontSize", fs );
	if ( o.isNull() || o.toInt() != fSize )
		emit fontSize( fSize );

	o = config->writeEntry( "StandardFont", stdName );
	if ( o.isNull() || o != stdName )
		emit standardFont( stdName );

	o = config->writeEntry( "FixedFont", fixedName );
	if ( o.isNull() || o != fixedName )
		emit fixedFont( fixedName );

	config->sync();
}

void CDocBrowserFont::slotFontSize( int i )
{
	fSize = i+3;
}

void CDocBrowserFont::slotStandardFont( const char *n )
{
	stdName = n;
}

void CDocBrowserFont::slotFixedFont( const char *n )
{
	fixedName = n;
}

//-----------------------------------------------------------------------------

CDocBrowserColor::CDocBrowserColor( QWidget *parent, const char *name )
    : QWidget( parent, name )
{
	readOptions();

	KColorButton *colorBtn;
	QLabel *label;

	label = new QLabel( i18n("Background color:"), this );
	label->setGeometry( 10, 10, 150, 25 );
  KQuickHelp::add (label, i18n("<B>Background color</B><BR><BR>\
This color is the background<BR>\
color of the<BR>browsers.\
<BR>Use a color with a good contrast\
<BR>to the other colors."));
	
	colorBtn = new KColorButton( bgColor, this );
	colorBtn->setGeometry( 240, 10, 100, 30 );
	connect( colorBtn, SIGNAL( changed( const QColor & ) ),
		SLOT( slotBgColorChanged( const QColor & ) ) );

	label = new QLabel( i18n("Normal text color:"), this );
	label->setGeometry( 10, 45, 150, 25 );
  KQuickHelp::add (label, i18n("<B>Normal text color</B><BR><BR>\
The normal text is displayed\
<BR>in this this color."));

	
	colorBtn = new KColorButton( textColor, this );
	colorBtn->setGeometry( 240, 45, 100, 30 );
	connect( colorBtn, SIGNAL( changed( const QColor & ) ),
		SLOT( slotTextColorChanged( const QColor & ) ) );

	label = new QLabel( i18n("URL link color:"), this );
	label->setGeometry( 10, 80, 150, 25 );
  KQuickHelp::add (label, i18n("<B>URL link color</B><BR><BR>\
This color is used for displaying URLs.\
<BR>Use a color like red or dark green."));

	
	colorBtn = new KColorButton( linkColor, this );
	colorBtn->setGeometry( 240, 80, 100, 30 );
	connect( colorBtn, SIGNAL( changed( const QColor & ) ),
		SLOT( slotLinkColorChanged( const QColor & ) ) );

	label = new QLabel( i18n("Followed link color:"), this );
	label->setGeometry( 10, 115, 150, 25 );
  KQuickHelp::add (label, i18n("<B>Followed link color</B><BR><BR>\
This color is used to display visited links."));
	
	colorBtn = new KColorButton( vLinkColor, this );
	colorBtn->setGeometry( 240, 115, 100, 30 );
	connect( colorBtn, SIGNAL( changed( const QColor & ) ),
		SLOT( slotVLinkColorChanged( const QColor & ) ) );

	label = new QLabel(i18n("Versenumber color"),this);
	label->setGeometry(10,150,190,30);
  KQuickHelp::add (label, i18n("<B>Versenumber color</B><BR><BR>\
Each versenumber is displayed in this color."));

 	colorBtn = new KColorButton(versenumberColor, this);
	colorBtn->setGeometry(240,150,100,30);
 	connect( colorBtn, SIGNAL( changed( const QColor & ) ),
		SLOT( slotVersenumberColorChanged( const QColor & ) ) );

	label = new QLabel(i18n("Highlighted verse color"),this);
	label->setGeometry(10,185,190,30);
  KQuickHelp::add (label, i18n("<B>Highlighted verse color</B><BR><BR>\
The selected verse is displayed in this color."));

		
	colorBtn = new KColorButton(verseColor, this);
	colorBtn->setGeometry(240,185,100,30);
 	connect( colorBtn, SIGNAL( changed( const QColor & ) ),
		SLOT( slotVerseColorChanged( const QColor & ) ) );

				
	QCheckBox *underlineBox = new QCheckBox( i18n("Underline links"),this);
	underlineBox->setGeometry(10, 220, 250, 30 );
	underlineBox->setChecked(underlineLinks);
	connect( underlineBox, SIGNAL( toggled( bool ) ),
		SLOT( slotUnderlineLinksChanged( bool ) ) );
	 KQuickHelp::add (underlineBox, i18n("<B>Underline links</B><BR><BR>\
Activate this checkbox if you want to see\
<BR>the links underlined.\
<BR>Useful for better recognition"));


}

void CDocBrowserColor::readOptions()
{
	KConfig *config = KApplication::getKApplication()->getConfig();
	config->setGroup( "DocBrowserAppearance" );
	
	bgColor = config->readColorEntry( "BgColor", &white );
	textColor = config->readColorEntry( "TextColor", &black );
	linkColor = config->readColorEntry( "LinkColor", &blue );
	vLinkColor = config->readColorEntry( "VLinkColor", &magenta );
	versenumberColor = config->readColorEntry( "versenumberColor", &red );
	verseColor = config->readColorEntry( "verseColor", &blue );	
	underlineLinks = config->readBoolEntry( "UnderlineLinks", TRUE );

/**Check if this is the first startup.
	*Have to do this because the colors won't be updated
	*if the user close simply the optionsdilaog on first startup.
**/
	config->setGroup("General Options");
	if (!config->readBoolEntry("isConfigured", false))
	//first startup
		changed=true;
	else
	//started more than once
		changed = false;
}

void CDocBrowserColor::writeOptions()
{
	this->slotApplyPressed();
};

void CDocBrowserColor::slotApplyPressed()
{
	KConfig *config = KApplication::getKApplication()->getConfig();
	config->setGroup( "DocBrowserAppearance" );

	config->writeEntry( "BgColor", bgColor );
	config->writeEntry( "TextColor", textColor );
	config->writeEntry( "LinkColor", linkColor );
	config->writeEntry( "VLinkColor", vLinkColor );
	config->writeEntry( "versenumberColor", versenumberColor );	
	config->writeEntry( "verseColor", verseColor );		
	config->writeEntry( "UnderlineLinks", underlineLinks );

	if ( changed )
	{
	    emit colorsChanged( bgColor, textColor, linkColor, vLinkColor, underlineLinks);
			emit sigChangeColors();
	};

	config->sync();
}

void CDocBrowserColor::slotBgColorChanged( const QColor &col )
{
	if ( bgColor != col )
    	    changed = true;
	bgColor = col;
}

void CDocBrowserColor::slotTextColorChanged( const QColor &col )
{
	if ( textColor != col )
	    changed = true;
	textColor = col;
}

void CDocBrowserColor::slotLinkColorChanged( const QColor &col )
{
	if ( linkColor != col )
    	    changed = true;
	linkColor = col;
}

void CDocBrowserColor::slotVLinkColorChanged( const QColor &col )
{
	if ( vLinkColor != col )
    	    changed = true;
	vLinkColor = col;
}

void	CDocBrowserColor::slotVerseColorChanged(const QColor &col)
{
	if ( verseColor != col )
    	    changed = true;
	verseColor = col;
};

void	CDocBrowserColor::slotVersenumberColorChanged(const QColor &col)
{
	if ( versenumberColor != col )
    	    changed = true;
	versenumberColor = col;
};

void CDocBrowserColor::slotUnderlineLinksChanged( bool ulinks )
{
	if ( underlineLinks != ulinks )
    	    changed = true;
	underlineLinks = ulinks;
}

