/***************************************************************************
                          outputdialog.cpp  -  description                              
                             -------------------                                         
    begin                : Sat May 15 1999                                           
    copyright            : (C) 1999 by Andreas Heck                         
    email                : aheck@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "outputdialog.h"

OutputDialog::OutputDialog( QWidget *parent=0, const char *name=0 )
 : QDialog( parent, name, TRUE )
{
 closeButton = new QPushButton(i18n("&Close"), this);
 closeButton->setGeometry(100, 210, 100, 25);
 connect( closeButton, SIGNAL(clicked()), this, SLOT(reject()));

 outputDisplay = new QMultiLineEdit(this);
 outputDisplay->setGeometry(10, 10, 250, 180);
 outputDisplay->setReadOnly(true);

 connect(&proc, SIGNAL(processExited(KProcess *)), this, SLOT(liloExited()));
 connect(&proc, SIGNAL(receivedStdout(KProcess *, char *, int)), this, SLOT(getOutput(KProcess *, char *, int)));
 connect(&proc, SIGNAL(receivedStderr(KProcess *, char *, int)), this, SLOT(getOutput(KProcess *, char *, int)));

 setFixedSize(270, 245);
 setCaption(i18n("LILO output"));

 startLILO();
}

void OutputDialog::liloExited()
{
 if (proc.normalExit() && (proc.exitStatus()==0))
   outputDisplay->append(i18n("\n\n\nLilo exited normally"));
 else
   outputDisplay->append(i18n("ERROR: Lilo died"));
}

void OutputDialog::startLILO()
{
 proc << "lilo";
 if (!proc.start(KProcess::NotifyOnExit, KProcess::AllOutput))
    outputDisplay->append(i18n("ERROR: Couldnt execute lilo"));
}

void OutputDialog::getOutput(KProcess *, char *data, int len)
{
 char dst[len+1];
 memmove(dst,data,len);
 dst[len]=0;

 outputDisplay->append(dst);
}