/***************************************************************************
                          liloconfig.h  -  description
                             -------------------
    begin                : Sat May 15 13:31:44 MEST 1999

    copyright            : (C) 1999 by Andreas Heck
    email                : aheck@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _LILOCONFIG_H_
#define _LILOCONFIG_H_


#include <qobject.h>
#include <qstring.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qlist.h>
#include <qtextstream.h>


struct OSProperties
{
 OSProperties()
  {
   positionOnDisk = NULL;
   isLinux = true;
   label = NULL;
   kernel = NULL;
   append = NULL;
  }
 QString positionOnDisk;
 bool isLinux;
 QString label;
 QString kernel;
 QString append;
};

struct LiloConfigData
{
  LiloConfigData()
    {
     bootPartition = NULL;
     linear = false;
     bootDelay = 0;
     vga = "normal";
     osList.setAutoDelete(true);
    }
  QString bootPartition;
  bool linear;
  int bootDelay;
  QString vga;
  QList <OSProperties> osList;
};

class LiloConfig : public QObject {
   Q_OBJECT
  public:

    LiloConfig();

    LiloConfigData readConfig();
    bool writeConfig( LiloConfigData *config );

    QString getMBR();
    QString getRootPartition();
  
  private:
    LiloConfigData liloconfigdata;
};

#endif