/***************************************************************************
                          FILENAME  -  description                              
                             -------------------                                         
    begin                : DATE                                           
    copyright            : (C) YEAR by AUTHOR                         
    email                : EMAIL                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "aboutbox.h"

AboutBox::AboutBox(QWidget *parent=0, const char *name=0)
: QDialog( parent, name, TRUE )
{
 groupBox = new QGroupBox(this);
 groupBox->setGeometry(10, 110, 280, 180);

 QPixmap logoPixmap;
 KIconLoader icon;
 logoPixmap = icon.loadIcon("klilologo.gif");

 logo = new QLabel(this);
 logo->setGeometry(100,10,100,100);
 logo->setPixmap(logoPixmap);

 QString tmp = "";
 tmp.sprintf("%s %s", APP_NAME, VERSION);
 programName = new QLabel(groupBox);
 programName->setAlignment(AlignCenter);
 programName->setText(tmp);
 programName->setGeometry(5,10,270, 25);

 label1 = new QLabel(groupBox);
 label1->setAutoResize(true);
 label1->setText(i18n("(C) 1999"));
 label1->move(10,60);

 aheck = new KURLLabel(groupBox);
 aheck->setAutoResize(true);
 aheck->setText("Andreas Heck (aheck@gmx.de)");
 aheck->move(65,60);
 aheck->setURL("mailto:aheck@gmx.de");
 connect(aheck, SIGNAL(leftClickedURL(const char *)), this, SLOT(processURL(const char *)));

 label2 = new QLabel(groupBox);
 label2->setAutoResize(true);
 label2->setText("GUI by");
 label2->move(10,85);

 mflaig = new KURLLabel(groupBox);
 mflaig->setAutoResize(true);
 mflaig->setText("Michael Flaig (mflaig@pro-linux.de)");
 mflaig->move(65,85);
 mflaig->setURL("mailto:mflaig@pro-linux.de");
 connect(mflaig, SIGNAL(leftClickedURL(const char *)), this, SLOT(processURL(const char *)));

 label3 = new QLabel(groupBox);
 label3->setAutoResize(true);
 label3->setText("For new versions visit the");
 label3->move(10,110);

 homepage = new KURLLabel(groupBox);
 homepage->setAutoResize(true);
 homepage->setText("KLILO Homepage");
 homepage->move(160, 110);
 homepage->setURL("http://mitglied.tripod.de/AndreasHeck/klilo/");
 connect(homepage, SIGNAL(leftClickedURL(const char *)), this, SLOT(processURL(const char *)));

 label4 = new QLabel(groupBox);
 label4->setAutoResize(true);
 label4->move(10,135);
 label4->setText("This Software is distributed under the terms\nof the GNU General Public License");

 okButton = new QPushButton(i18n("OK"), this);
 okButton->setGeometry(100,310, 100, 25);
 connect( okButton, SIGNAL(clicked()), SLOT(accept()) );

 setFixedSize(300,345);
 setCaption(i18n("About KLILO"));
}

void AboutBox::processURL(const char *url)
{
 KFM kfm;
 kfm.allowKFMRestart(true);
 kfm.openURL(url);
}