#include "KReqSheet.h"
#include <qlined.h>

#include "KReqSheet.moc"

KReqSheet::KReqSheet(const char* title) : KSheet(title) {
  m_pEdit = new QLineEdit(this);
  m_pEdit->resize(m_pEdit->sizeHint());
  resize(m_pEdit->sizeHint());
  m_pEdit->show();
  connect(m_pEdit, SIGNAL(textChanged(const char*)), SLOT(onEdit(const char*)));
}

void KReqSheet::onEdit(const char* txt) {
  if(!txt || !*txt) {
    emit disableNext();
    emit disableFinish();
  } else {
    emit enableNext();
    
  }
}

bool KReqSheet::allowFinish() {
  return FALSE;
}

bool KReqSheet::allowNext() {
  return m_pEdit->text() && *m_pEdit->text();
}

QString KReqSheet::getAnswer() {
  return QString(m_pEdit->text());
}
