//Auto-generated by kalyptus. DO NOT EDIT.
namespace Plasma {
    using Plasma;
    using System;
    using Kimono;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  @class DataEngineManager plasma/dataenginemanager.h <Plasma/DataEngineManager>
    ///  Plasma.DataEngineManager provides facilities for listing, loading and
    ///  according to reference count unloading of DataEngines.
    /// </remarks>        <short> DataEngine loader and life time manager.</short>
    [SmokeClass("Plasma::DataEngineManager")]
    public class DataEngineManager : QObject {
        protected DataEngineManager(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(DataEngineManager), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static DataEngineManager() {
            staticInterceptor = new SmokeInvocation(typeof(DataEngineManager), null);
        }
        /// <remarks>
        ///  Returns a data engine object if one is loaded and available.
        ///  On failure, the fallback NullEngine (which does nothing and
        ///  !isValid()) is returned.
        /// <param> name="name" the name of the engine
        ///          </param></remarks>        <short>    Returns a data engine object if one is loaded and available.</short>
        public Plasma.DataEngine Engine(string name) {
            return (Plasma.DataEngine) interceptor.Invoke("engine$", "engine(const QString&) const", typeof(Plasma.DataEngine), typeof(string), name);
        }
        /// <remarks>
        ///  Loads a data engine and increases the reference count on it.
        ///  This should be called once per object (or set of objects) using the
        ///  DataEngine. Afterwards, dataEngine should be used or the return
        ///  value cached. Call unloadDataEngine when finished with the engine.
        /// <param> name="name" the name of the engine
        /// </param></remarks>        <return> the data engine that was loaded, or the NullEngine on failure.
        ///          </return>
        ///         <short>    Loads a data engine and increases the reference count on it.</short>
        public Plasma.DataEngine LoadEngine(string name) {
            return (Plasma.DataEngine) interceptor.Invoke("loadEngine$", "loadEngine(const QString&)", typeof(Plasma.DataEngine), typeof(string), name);
        }
        /// <remarks>
        ///  Decreases the reference count on the engine. If the count reaches
        ///  zero, then the engine is deleted to save resources.
        ///          </remarks>        <short>    Decreases the reference count on the engine.</short>
        public void UnloadEngine(string name) {
            interceptor.Invoke("unloadEngine$", "unloadEngine(const QString&)", typeof(void), typeof(string), name);
        }
        /// <remarks>
        ///  Singleton pattern accessor.
        ///          </remarks>        <short>    Singleton pattern accessor.</short>
        public static Plasma.DataEngineManager Self() {
            return (Plasma.DataEngineManager) staticInterceptor.Invoke("self", "self()", typeof(Plasma.DataEngineManager));
        }
        /// <remarks>
        /// <param> name="parentApp" the application to filter applets on. Uses the
        ///                   X-KDE-ParentApp entry (if any) in the plugin info.
        ///                   The default value of string() will result in a
        ///                   list containing only applets not specifically
        ///                   registered to an application.
        ///          </param></remarks>        <return> a listing of all known DataEngines by name
        /// </return>
        ///         <short>   </short>
        public static List<string> ListAllEngines(string parentApp) {
            return (List<string>) staticInterceptor.Invoke("listAllEngines$", "listAllEngines(const QString&)", typeof(List<string>), typeof(string), parentApp);
        }
        public static List<string> ListAllEngines() {
            return (List<string>) staticInterceptor.Invoke("listAllEngines", "listAllEngines()", typeof(List<string>));
        }
        /// <remarks>
        ///  Returns a list of all known DataEngines.
        /// <param> name="parentApp" the application to filter applets on. Uses the
        ///                   X-KDE-ParentApp entry (if any) in the plugin info.
        ///                   The default value of string() will result in a
        ///                   list containing only applets not specifically
        ///                   registered to an application.
        /// </param></remarks>        <return> list of DataEngines
        /// </return>
        ///         <short>    Returns a list of all known DataEngines.</short>
        public static List<KPluginInfo> ListEngineInfo(string parentApp) {
            return (List<KPluginInfo>) staticInterceptor.Invoke("listEngineInfo$", "listEngineInfo(const QString&)", typeof(List<KPluginInfo>), typeof(string), parentApp);
        }
        public static List<KPluginInfo> ListEngineInfo() {
            return (List<KPluginInfo>) staticInterceptor.Invoke("listEngineInfo", "listEngineInfo()", typeof(List<KPluginInfo>));
        }
        /// <remarks>
        ///  Returns a list of all known DataEngines filtering by category.
        /// <param> name="category" the category to filter applets on. Uses the
        ///                   X-KDE-PluginInfo-Category entry (if any) in the
        ///                   plugin info. The value of string() will
        ///                   result in a list of engines with an empty category.
        /// </param><param> name="parentApp" the application to filter applets on. Uses the
        ///                   X-KDE-ParentApp entry (if any) in the plugin info.
        ///                   The default value of string() will result in a
        ///                   list containing only applets not specifically
        ///                   registered to an application.
        /// </param></remarks>        <return> list of DataEngines
        /// </return>
        ///         <short>    Returns a list of all known DataEngines filtering by category.</short>
        public static List<KPluginInfo> ListEngineInfoByCategory(string category, string parentApp) {
            return (List<KPluginInfo>) staticInterceptor.Invoke("listEngineInfoByCategory$$", "listEngineInfoByCategory(const QString&, const QString&)", typeof(List<KPluginInfo>), typeof(string), category, typeof(string), parentApp);
        }
        public static List<KPluginInfo> ListEngineInfoByCategory(string category) {
            return (List<KPluginInfo>) staticInterceptor.Invoke("listEngineInfoByCategory$", "listEngineInfoByCategory(const QString&)", typeof(List<KPluginInfo>), typeof(string), category);
        }
        protected new IDataEngineManagerSignals Emit {
            get { return (IDataEngineManagerSignals) Q_EMIT; }
        }
    }

    public interface IDataEngineManagerSignals : IQObjectSignals {
    }
}
