<?xml version="1.0" encoding="iso-8859-1"?>
<!--
  ** Author: Marco Ladermann <marco.ladermann@gmx.de>
  ** Date:   Tue Jan 28 17:19:16 CET 2003 @721 /Internet Time/
  ** 
  ** This software is free software. It is released under the terms of the
  ** GNU Lesser General Public Licence (LGPL)
  ** see http://www.gnu.org/copyleft/lesser.html
  **
  ** These stylesheets are distributed in the hope that they will be useful,
  ** but WITHOUT ANY WARRANTY; without even the implied warranty of
  ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  -->
<xsl:stylesheet 
    version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:exsl="http://exslt.org/common"
    xmlns:func="http://exslt.org/functions"
    xmlns:date="http://exslt.org/dates-and-times"
    xmlns:kde="http://kde.org/functions"
    xmlns:java="http://kde.org/java"

 >
    <!--
      ** Put the definition of the toplevel window
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putTopLevelWindowDefinition">
        <xsl:param name="data"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:choose>
            <xsl:when test="@class = 'QMainWindow'">
                <xsl:text>setCentralWidget( new QWidget( this, "qt_central_widget" ) );</xsl:text>
            </xsl:when>
        </xsl:choose>
    </xsl:template>

    <!--
      ** Put the definition of each embedded widget.
      ** @context widget
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putWidgetDefinition">
        <xsl:param name="data"/>
        <xsl:value-of select="$newline"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:variable name="name" select="java:getNodeName(.)"/>
        <xsl:value-of select="$name"/><xsl:text> = new </xsl:text>
        <xsl:apply-templates mode="toClass" select="."/>
        <xsl:text>( </xsl:text>
        <!-- insert reference to parent widget -->
        <xsl:variable name="container" select="ancestor::widget[@class != 'QLayoutWidget'][1]"/>
        <xsl:value-of select="java:getContainerName($container)"/>
        <xsl:text>, "</xsl:text>
        <xsl:value-of select="$name"/>
        <xsl:text>" );</xsl:text>
		<xsl:if test="../@class = 'KWizard' or ../@class = 'QWizard'">
			<xsl:value-of select="$newline"/>
			<xsl:value-of select="$nlIndent8"/>
			<xsl:text>addPage( </xsl:text>
			<xsl:value-of select="$name"/>
			<xsl:text>, "</xsl:text>
			<xsl:value-of select="attribute[@name='title']/string"/>
			<xsl:text>" );</xsl:text>
		</xsl:if>
    </xsl:template>

    <!--
      ** Put the definition of a layout class
      ** @context hbox | vbox | grid
      ** @param class is the Qt class name of the layout
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putLayoutDefinition">
        <xsl:param name="class"/>
        <xsl:param name="data"/>
        <xsl:value-of select="$newline"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:variable name="name" select="java:getNodeName(.)"/>
        <xsl:variable name="isTopmost" select="count(ancestor::vbox|ancestor::hbox|ancestor::grid)=0"/>
        <xsl:value-of select="$name"/>
        <xsl:text> = new </xsl:text>
        <xsl:value-of select="$class"/>
        <xsl:text>( </xsl:text>
        <!-- insert reference to parent container -->
        <xsl:choose>
            <xsl:when test="../@class != 'QLayoutWidget' or $isTopmost">
    			<xsl:value-of select="java:getContainerName(..)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>(QWidget)null</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:text>, </xsl:text>
        <xsl:if test="name() = 'grid'">
            <xsl:text> 1, 1, </xsl:text>
        </xsl:if>
        <xsl:choose>
            <xsl:when test="property[@name='margin']">
                <xsl:value-of select="property[@name='margin']/number"/>
                <xsl:text>, </xsl:text>
            </xsl:when>
            <xsl:when test="not($isTopmost)">
                <xsl:value-of select="'0'"/>
                <xsl:text>, </xsl:text>
            </xsl:when>
            <xsl:when test="/UI/layoutdefaults">
                <xsl:value-of select="/UI/layoutdefaults/@margin"/>
                <xsl:text>, </xsl:text>
            </xsl:when>
        </xsl:choose>
        <xsl:choose>
            <xsl:when test="property[@name='spacing']">
                <xsl:value-of select="property[@name='spacing']/number"/>
            </xsl:when>
            <xsl:when test="/UI/layoutdefaults">
                <xsl:value-of select="/UI/layoutdefaults/@spacing"/>
            </xsl:when>
        </xsl:choose>
        <xsl:value-of select="concat(', &quot;', $name, '&quot;')"/>
        <xsl:text> );</xsl:text>
    </xsl:template>

    <!--
      ** Put the content (widgets) of a layout.
      ** @context widget
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putLayoutContentDefinition">
        <xsl:param name="data"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="java:getNodeName(..)"/>
        <xsl:choose>
            <xsl:when test="@class = 'QLayoutWidget'">
                <xsl:text>.addLayout( </xsl:text>
                <xsl:value-of select="java:getNodeName(hbox|vbox|grid)"/>
            </xsl:when>
            <xsl:when test="name() = 'spacer'">
                <xsl:text>.addItem( </xsl:text>
                <xsl:value-of select="java:getNodeName(.)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>.addWidget( </xsl:text>
                <xsl:value-of select="java:getNodeName(.)"/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:if test="@row">
            <xsl:value-of select="concat(', ',@row,', ', @column)"/>
        </xsl:if>
        <xsl:text> );</xsl:text>
    </xsl:template>

    <!--
      ** Put column definitions.
      ** @context column
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putColumnDefinition">
        <xsl:param name="data"/>
        <xsl:variable name="container" select="../@class"/>
        <xsl:variable name="colno" select="count(preceding-sibling::column)"/>
        <xsl:variable name="colname" select="java:getNodeName(..)"/>
        <xsl:variable name="text" select="property[@name='text']/string"/>
        <xsl:variable name="isUtf8" select="kde:isUtf8($text)"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:text>// Column number </xsl:text>
        <xsl:value-of select="$colno"/>
        <xsl:choose>
            <xsl:when test="$container = 'QTable'">
                <xsl:value-of select="$nlIndent8"/>
                <xsl:value-of select="$colname"/>
                <xsl:text>.setNumCols( </xsl:text>
                <xsl:value-of select="$colname"/>
                <xsl:text>.numCols() + 1 );</xsl:text>
                <xsl:value-of select="$nlIndent8"/>
                <xsl:value-of select="$colname"/>
                <xsl:text>.horizontalHeader().setLabel( </xsl:text>
                <xsl:value-of select="$colname"/>
                <xsl:text>.numCols() - 1, </xsl:text>
                <xsl:value-of select="java:tr($isUtf8)"/>
                <xsl:text>( "</xsl:text>
                <xsl:value-of select="java:toJavaString($text)"/>
                <xsl:text>" ));</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$nlIndent8"/>
                <xsl:value-of select="$colname"/>
                <xsl:text>.addColumn( "</xsl:text>
                <xsl:value-of select="java:toJavaString($text)"/>
                <xsl:text>" );</xsl:text>
                <xsl:for-each select="property[@name != 'text']/bool">
                    <xsl:variable name="attr" select="../@name"/>
                    <xsl:variable name="bool" select="string(. = 1 or . = 'true')"/>
                    <xsl:variable name="method">
                        <xsl:choose>
                            <xsl:when test="$attr = 'clickable'">
                                <xsl:text>setClickEnabled</xsl:text>
                            </xsl:when>
                            <xsl:when test="$attr = 'resizable'">
                                <xsl:text>setResizeEnabled</xsl:text>
                            </xsl:when>
                            <xsl:when test="$attr = 'movable'">
                                <xsl:text>setMovingEnabled</xsl:text>
                            </xsl:when>
                            <xsl:when test="$attr = 'strechable'">
                                <xsl:text>setStrechEnabled</xsl:text>
                            </xsl:when>
                        </xsl:choose>
                    </xsl:variable>
                    <xsl:value-of select="$nlIndent8"/>
                    <xsl:value-of select="$colname"/>
                    <xsl:text>.header().</xsl:text>
                    <xsl:value-of select="$method"/>
                    <xsl:text>( </xsl:text>
                    <xsl:value-of select="$bool"/>
                    <xsl:text>, </xsl:text>
                    <xsl:value-of select="$colname"/>
                    <xsl:text>.header().count() - 1 );</xsl:text>
                </xsl:for-each>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!--
      ** Put row definitions.
      ** @context row
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putRowDefinition">
        <xsl:param name="data"/>
        <xsl:variable name="container" select="../@class"/>
        <xsl:variable name="rowno" select="count(preceding-sibling::row)"/>
        <xsl:variable name="rowname" select="java:getNodeName(..)"/>
        <xsl:variable name="text" select="property[@name='text']/string"/>
        <xsl:variable name="isUtf8" select="kde:isUtf8($text)"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:text>// Row number </xsl:text>
        <xsl:value-of select="$rowno"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="$rowname"/>
        <xsl:text>.setNumRows( </xsl:text>
        <xsl:value-of select="$rowname"/>
        <xsl:text>.numRows() + 1 );</xsl:text>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="$rowname"/>
        <xsl:text>.verticalHeader().setLabel( </xsl:text>
        <xsl:value-of select="$rowname"/>
        <xsl:text>.numRows() - 1, </xsl:text>
        <xsl:value-of select="java:tr($isUtf8)"/>
        <xsl:text>( "</xsl:text>
        <xsl:value-of select="java:toJavaString($text)"/>
        <xsl:text>" ));</xsl:text>
    </xsl:template>


    <!--
      ** Put item definitions.
      ** @context item
      ** @param class is the class of the item, ie: concat(../@class, 'Item')
      ** @param index is the number of the item in the sequence
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putItemDefinition">
        <xsl:param name="class"/> <!-- class of the item -->
        <xsl:param name="number"/>    <!-- number of item in sequence -->
        <xsl:param name="data"/>
        <xsl:variable name="name" select="concat($class, 'Item')"/>
        <xsl:variable name="classInfo" select="document($qtJavaClassesXml)/Qt/class[name = $name]"/>
        <xsl:choose>
            <xsl:when test="$classInfo">
                <xsl:call-template name="putItemObjectDefinition">
                    <xsl:with-param name="class" select="$name"/>
                    <xsl:with-param name="number" select="$number"/>
                    <xsl:with-param name="data" select="$data"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="putItemInsertDefinition">
                    <xsl:with-param name="class" select="$class"/>
                    <xsl:with-param name="number" select="$number"/>
                    <xsl:with-param name="data" select="$data"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!--
      ** Put item inserts.
      ** @context item
      ** @param index is the number of the item in the sequence
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putItemInsertDefinition">
        <xsl:param name="class"/> <!-- class of the item -->
        <xsl:param name="number"/>    <!-- number of item in sequence -->
        <xsl:param name="data"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="concat(java:getNodeName(..)
                                    ,'.insertItem( &quot;'
                                    , property/string
                                    , '&quot; ); ')"/>
        
    </xsl:template>
    
    <!--
      ** Put item Object definitions.
      ** @context item
      ** @param class is the class of the item, ie: concat(../@class, 'Item')
      ** @param index is the number of the item in the sequence
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putItemObjectDefinition">
        <xsl:param name="class"/> <!-- class of the item -->
        <xsl:param name="number"/>    <!-- number of item in sequence -->
        <xsl:param name="data"/>
        <xsl:variable name="name" select="java:getNodeName(..)"/>
        <xsl:variable name="varname" select="concat($name, 'Item', $number)"/>
        <xsl:variable name="previous">
            <xsl:choose>
                <xsl:when test="$number = 0">
                    <xsl:value-of select="concat('(', $class, ') null')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat($name, 'Item', $number - 1)"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:value-of select="concat($nlIndent8, '// Item number ', $number, $nlIndent8)"/>
        <xsl:value-of select="concat($class, ' ', $varname, ' = new ', $class, '( ', $name, ', ', $previous, ' );')"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="concat($varname, '.setOpen(true);')"/>
        <!-- items need special handling of the property subtags -->
        <xsl:for-each select="property[@name = 'text']">
            <xsl:value-of select="$nlIndent8"/>
            <xsl:value-of select="concat($varname, 
                                        '.setText( ', position() - 1 
                                                    , ', '
                                                    , java:tr(kde:isUtf8(string))
                                                    , '(&quot;'
                                                    , java:toJavaString(string)
                                                    , '&quot;) );')"/>
        </xsl:for-each>
        <xsl:for-each select="property[@name = 'pixmap']">
            <xsl:if test="pixmap != ''">
                <xsl:value-of select="$nlIndent8"/>
                <xsl:value-of select="concat($varname,
                                            '.setPixmap( ', position() - 1
                                                          , ', ', pixmap, ' );')"/>
            </xsl:if>
        </xsl:for-each>
        <xsl:for-each select="item">
            <xsl:call-template name="putSubItemDefinition">
                <xsl:with-param name="class" select="$class"/>
                <xsl:with-param name="parent" select="$varname"/>
                <xsl:with-param name="number" select="position() - 1"/>
                <xsl:with-param name="name" select="concat($name, 'ItemItem')"/>
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="putSubItemDefinition">
        <xsl:param name="class"/>
        <xsl:param name="parent"/>
        <xsl:param name="number"/>
        <xsl:param name="name"/>
        <xsl:variable name="varname" select="concat($name, $number)"/>
        <xsl:variable name="previous">
            <xsl:choose>
                <xsl:when test="$number = 0">
                    <xsl:value-of select="concat('(', $class, ') null')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat($name, $number - 1)"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="concat($class, ' ', $varname, ' = new ', $class, '( ', $parent, ', ', $previous, ' );')"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="concat($varname, '.setOpen(true);')"/>
        <!-- items need special handling of the property subtags -->
        <xsl:for-each select="property[@name = 'text']">
            <xsl:value-of select="$nlIndent8"/>
            <xsl:value-of select="concat($varname, 
                                        '.setText( ', position() - 1 
                                                    , ', '
                                                    , java:tr(kde:isUtf8(string))
                                                    , '(&quot;'
                                                    , java:toJavaString(string)
                                                    , '&quot;) );')"/>
        </xsl:for-each>
        <xsl:for-each select="property[@name = 'pixmap']">
            <xsl:if test="pixmap != ''">
                <xsl:value-of select="$nlIndent8"/>
                <xsl:value-of select="concat($varname,
                                            '.setPixmap( ', position() - 1
                                                          , ', ', pixmap, ' );')"/>
            </xsl:if>
        </xsl:for-each>
        <xsl:for-each select="item">
            <xsl:call-template name="putSubItemDefinition">
                <xsl:with-param name="class" select="$class"/>
                <xsl:with-param name="parent" select="$varname"/>
                <xsl:with-param name="number" select="position() - 1"/>
                <xsl:with-param name="name" select="concat($name, 'Item')"/>
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>
    
    <!--
      ** Put spacer definitions.
      ** @context spacer
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putSpacerDefinition">
        <xsl:param name="data"/>
        <xsl:variable name="orientation" select="property[@name='orientation']/enum"/>
        <xsl:variable name="sizeType" select="property[@name='sizeType']/enum"/>
        <xsl:variable name="hexp">
            <xsl:choose>
                <xsl:when test="$orientation = 'Horizontal'">
                    <xsl:value-of select="concat('QSizePolicy.', $sizeType)"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="'QSizePolicy.Minimum'"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="vexp">
            <xsl:choose>
                <xsl:when test="$orientation = 'Vertical'">
                    <xsl:value-of select="concat('QSizePolicy.', $sizeType)"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="'QSizePolicy.Minimum'"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="concat(java:getNodeName(.), 
                                    ' = new QSpacerItem( ',   property[@name = 'sizeHint']/size/width,
                                                        ', ', property[@name = 'sizeHint']/size/height,
                                                        ', ', $hexp,
                                                        ', ', $vexp, ' );')"/>
        <xsl:value-of select="$nlIndent8"/>
    </xsl:template>


    <!-- 
      ** Puts the definition of an actiongroup
      ** @context actiongroup
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putActionGroupDefinition">
        <xsl:param name="data"/>
        <xsl:variable name="nodeName" select="java:getNodeName(.)"/>
        <xsl:variable name="parent" select="java:getNodeName(..)"/>
        <xsl:variable name="parentName">
            <xsl:choose>
                <xsl:when test="$parent = ''">this</xsl:when>
                <xsl:otherwise><xsl:value-of select="$parent"/></xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="concat($nodeName, 
                                     ' = new QActionGroup( ',
                                     $parentName,
                                     ', &quot;', $nodeName, '&quot; );')"/>
    </xsl:template>
    
    <!-- 
      ** Puts the definition of the actions
      ** @context action
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putActionDefinition">
        <xsl:param name="data"/>
        <xsl:variable name="nodeName" select="java:getNodeName(.)"/>
        <xsl:variable name="parent" select="java:getNodeName(..)"/>
        <xsl:variable name="parentName">
            <xsl:choose>
                <xsl:when test="$parent = ''">this</xsl:when>
                <xsl:otherwise><xsl:value-of select="$parent"/></xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="concat($nodeName,
                                     ' = new QAction( ',
                                     $parentName,
                                     ', &quot;', $nodeName, '&quot; );')"/>
    </xsl:template>
    
    <!-- 
      ** Puts the definition of the menubar
      ** @context menubar
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putMenubarDefinition">
        <xsl:param name="data"/>
        <xsl:variable name="name" select="java:getNodeName(.)"/>
        <xsl:value-of select="$newline"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="concat($name,
                                     ' = new QMenuBar( this, &quot;', $name, '&quot; );')"/>
    </xsl:template>
    
    <!-- 
      ** Puts the definition of the menubar items
      ** @context item
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putMenubarItemDefinition">
        <xsl:param name="data"/>
        <xsl:variable name="menu" select="java:getNodeName(..)"/>
        <xsl:variable name="pos" select="count(preceding-sibling::item)"/>
        <xsl:value-of select="$newline"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="concat('QPopupMenu ', @name, ' = new QPopupMenu( this );')"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="concat($menu,
                                     '.insertItem( &quot;&quot;, ',
                                     @name,
                                     ', ',
                                     $pos,
                                     ' , -1 );')"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="concat($menu,
                                     '.findItem( ',
                                     $pos,
                                     ' ).setText( &quot;',
                                     @text,
                                     '&quot; );')"/>
    </xsl:template>
    
    <!-- 
      ** Puts the definition of the menubar actions
      ** @context action
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putMenubarActionDefinition">
        <xsl:param name="data"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="concat(@name, '.addTo( ', ../@name, ' );')"/>
    </xsl:template>
    
    <!-- 
      ** Puts the definition of a seperator in a popup menu
      ** @context seperator
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putMenubarSeperatorDefinition">
        <xsl:param name="data"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:choose>
            <xsl:when test="../@name">
                <xsl:value-of select="../@name"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="kde:getNodeName(..)"/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:text>.insertSeparator();</xsl:text>
    </xsl:template>
    
    <!-- 
      ** Puts the definition of the toolbar
      ** @context toolbar
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putToolbarDefinition">
        <xsl:param name="data"/>
        <xsl:variable name="name" select="java:getNodeName(.)"/>
        <xsl:value-of select="$newline"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="concat($name,
                                     ' = new QToolBar( &quot;', 
                                                       property[@name='label']/string, 
                                                       '&quot;, this );')"/>
    </xsl:template>
    
    <!-- 
      ** Puts the definition of the toolbar actions
      ** @context action
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putToolbarActionDefinition">
        <xsl:param name="data"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="concat(@name, '.addTo( ', java:getNodeName(..), ' );')"/>
    </xsl:template>
    
    <!-- 
      ** Puts the definition of a seperator in a toolbar
      ** @context seperator
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putToolbarSeperatorDefinition">
        <xsl:param name="data"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="concat(java:getNodeName(..), '.addSeparator( );')"/>
    </xsl:template>
    
    <!-- 
      ** Puts the definition of signal-slot connections
      ** @context connection
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putConnectionDefinition">
        <xsl:param name="data"/>
        <xsl:variable name="signal" select="java:cpp-to-java-signature(signal)"/>
        <xsl:variable name="slot" select="java:cpp-to-java-signature(slot)"/>
        <xsl:variable name="sender">
            <xsl:choose>
                <xsl:when test="sender = /UI/widget/property[@name = 'name']/cstring">
                    <xsl:value-of select="'this'"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="sender"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="receiver">
            <xsl:choose>
                <xsl:when test="receiver = /UI/widget/property[@name = 'name']/cstring">
                    <xsl:value-of select="'this'"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="receiver"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="concat('connect( ', $sender,
                                               ', SIGNAL( &quot;', $signal, '&quot; ), ',
                                                  $receiver,
                                               ', SLOT( &quot;', $slot, '&quot; ));')"/>
    </xsl:template>
    
</xsl:stylesheet>

