/***************************************************************************
                            KRecentDocument.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Manage the "Recent Document Menu" entries displayed by
 applications such as Kicker and Konqueror.

 These entries are automatically generated .desktop files pointing
 to the current application and document.  You should call the
 static {@link #add} method whenever the user opens or saves a new
 document if you want it to show up in the menu.

 You don't have to worry about this if you are using any {@link KFileBaseDialog} derived class to open and save documents, as it
 already calls this class.  User defined limits on the maximum
 number of documents to save, etc... are all automatically handled.

 @author Daniel M. Duley <mosfet@kde.org> 
 
 @short 
 Manage the "Recent Document Menu" entries displayed by
 applications such as Kicker and Konqueror.
*/
public class  KRecentDocument implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KRecentDocument(Class dummy){}


/** 

 Return a list of absolute paths to recent document .desktop files,
 sorted by date.

     
*/
	public static native ArrayList recentDocuments();

/** 
 Add a new item to the Recent Document menu.

*/
	public static native void add( KURL url);

/** 

 Add a new item to the Recent Document menu. Calls add( url ).

*/
	public static native void add( String documentStr, boolean isURL);
	public static native void add( String documentStr);

/** 
 Clear the recent document menu of all entries.
     
*/
	public static native void clear();

/** 
 Retrieve the maximum amount of recent document entries allowed.
     
*/
	public static native int maximumItems();

/** 
 Returns the path to the directory where recent document .desktop files
 are stored.
     
*/
	public static native String recentDocumentDirectory();
}
