/***************************************************************************
                            KMessageBox.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**
 
 Easy message dialog box. 

 Provides convenience functions for some i18n'ed standard dialogs.

 @author Waldo Bastian (bastian@kde.org)

 @version $Id: KMessageBox.java,v 1.3.2.1 2001/08/29 23:14:10 rdale Exp $
  
 @short  
 Easy message dialog box.
*/
public class  KMessageBox implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KMessageBox(Class dummy){}


/** 
 Display a simple "question" dialog. 

 To be used for questions like "Do you have a printer?"

 The default button is "Yes". Pressing "Esc" selects "No".
  
*/
	public static native int questionYesNo( QWidget parent, String text, String caption, String buttonYes, String buttonNo, boolean notify);
	public static int questionYesNo( QWidget parent, String text, String caption)
	{
		return questionYesNo(parent, text, caption, null, null, true);
	}
	public static native int questionYesNo( QWidget parent, String text);

/** 
 Display a "question" dialog with a listbox to show information to the user 

 To be used for questions like "Do you really want to delete these files?"
 And show the user exactly which files are going to be deleted in case
 he presses "Yes"

 The default button is "Yes". Pressing "Esc" selects "No".
  
*/
	public static native int questionYesNoList( QWidget parent, String text, String[] strlist, String caption, String buttonYes, String buttonNo, boolean notify);
	public static int questionYesNoList( QWidget parent, String text, String[] strlist, String caption)
	{
		return questionYesNoList(parent, text, strlist, caption, null, null, true);
	}
	public static native int questionYesNoList( QWidget parent, String text, String[] strlist);

/** 
 Display a "warning" dialog. 

 To be used for questions "Shall I update your configuration?"
 The text should explain the implication of both options.

 The default button is "No". Pressing "Esc" selects "No".
  
*/
	public static native int warningYesNo( QWidget parent, String text, String caption, String buttonYes, String buttonNo, boolean notify);
	public static int warningYesNo( QWidget parent, String text, String caption)
	{
		return warningYesNo(parent, text, caption, null, null, true);
	}
	public static native int warningYesNo( QWidget parent, String text);

/** 
 Display a "warning" dialog. 

 The second button always has the text "Cancel".

 To be used for questions like "You are about to Print. Are you sure?"
 the continueButton should then be labeled "Print".

 The default button is buttonContinue. Pressing "Esc" selects "Cancel".
  
*/
	public static native int warningContinueCancel( QWidget parent, String text, String caption, String buttonContinue, String dontAskAgainName, boolean notify);

/** 
 Provided for binary compatibility
  
*/
	public static native int warningContinueCancel( QWidget parent, String text, String caption, String buttonContinue, boolean notify);
	public static native int warningContinueCancel( QWidget parent, String text, String caption, String buttonContinue);

/** 
 Display a "warning" dialog with a listbox to show information to the user. 

 The second button always has the text "Cancel".

 To be used for questions like "You are about to Print. Are you sure?"
 the continueButton should then be labeled "Print".

 The default button is buttonContinue. Pressing "Esc" selects "Cancel".
  
*/
	public static native int warningContinueCancelList( QWidget parent, String text, String[] strlist, String caption, String buttonContinue, String dontAskAgainName, boolean notify);
	public static native int warningContinueCancelList( QWidget parent, String text, String[] strlist, String caption, String buttonContinue);

/** 
 Display a Yes/No/Cancel "warning" dialog. 

 To be used for questions "Do you want to save your changes?"
 The text should explain the implication of choosing 'No'.

 The default button is "Yes". Pressing "Esc" selects "Cancel"

 NOTE: The cancel button will always have the i18n'ed text '&Cancel'.
  
*/
	public static native int warningYesNoCancel( QWidget parent, String text, String caption, String buttonYes, String buttonNo, boolean notify);
	public static int warningYesNoCancel( QWidget parent, String text, String caption)
	{
		return warningYesNoCancel(parent, text, caption, null, null, true);
	}
	public static native int warningYesNoCancel( QWidget parent, String text);
	public static native int warningYesNoCancel( QWidget parent, String text, String caption, String buttonYes, String buttonNo, String dontAskAgainName, boolean notify);
	public static native int warningYesNoCancel( QWidget parent, String text, String caption, String buttonYes, String buttonNo, String dontAskAgainName);

/** 
 Display an "Error" dialog. 

 Your program messed up and now it's time to inform the user.
 To be used for important things like "Sorry, I deleted your hard disk."

 If your program detects the action specified by the user is somehow
 not allowed, this should never be reported with error(). Use sorry()
 instead to explain to the user that this action is not allowed. 

 The default button is "&OK". Pressing "Esc" selects the OK-button.

 NOTE: The OK button will always have the i18n'ed text '&OK'.
  
*/
	public static native void error( QWidget parent, String text, String caption, boolean notify);
	public static native void error( QWidget parent, String text);

/** 
 Displays an "Error" dialog with a "Details >>" button.

 Your program messed up and now it's time to inform the user.
 To be used for important things like "Sorry, I deleted your hard disk."

 The <code>details</code> message can conatin additional information about
 the problem and can be shown on request to advanced/interested users.

 If your program detects the action specified by the user is somehow
 not allowed, this should never be reported with error(). Use sorry()
 instead to explain to the user that this action is not allowed. 

 The default button is "&OK". Pressing "Esc" selects the OK-button.

 NOTE: The OK button will always have the i18n'ed text '&OK'.
  
*/
	public static native void detailedError( QWidget parent, String text, String details, String caption, boolean notify);
	public static native void detailedError( QWidget parent, String text, String details);

/** 
 Display an "Sorry" dialog. 

 Either your program messed up and asks for understanding
 or your user did something stupid.

 To be used for small problems like 
 "Sorry, I can't find the file you specified."

 The default button is "&OK". Pressing "Esc" selects the OK-button.

 NOTE: The ok button will always have the i18n'ed text '&OK'.
  
*/
	public static native void sorry( QWidget parent, String text, String caption, boolean notify);
	public static native void sorry( QWidget parent, String text);

/** 
 Displays a "Sorry" dialog with a "Details >>" button.

 Either your program messed up and asks for understanding
 or your user did something stupid.

 To be used for small problems like 
 "Sorry, I can't find the file you specified."

 And then <code>details</code> can contain something like
 "foobar.txt was not found in any of 
  the following directories:
  /usr/bin,/usr/local/bin,/usr/sbin"

 The default button is "&OK". Pressing "Esc" selects the OK-button.

 NOTE: The ok button will always have the i18n'ed text '&OK'.
  
*/
	public static native void detailedSorry( QWidget parent, String text, String details, String caption, boolean notify);
	public static native void detailedSorry( QWidget parent, String text, String details);

/** 
 Display an "Information" dialog. 

 Your program wants to tell the user something.
 To be used for things like:
 "Your bookmarks have been rearranged."

 The default button is "&OK". Pressing "Esc" selects the OK-button.

  NOTE: The OK button will always have the i18n'ed text '&OK'.
  
*/
	public static native void information( QWidget parent, String text, String caption, String dontShowAgainName, boolean notify);
	public static native void information( QWidget parent, String text);

/** 
 Enable all messages which have been turned off with the
 <code>dontShowAgainName</code> feature of the information dialog.
   
*/
	public static native void enableAllMessages();

/** 
 Display an "About" dialog. 

 Your program wants to show some general information about the application
 like the authors's names and email addresses.

 The default button is "&OK". 

  NOTE: The ok button will always have the i18n'ed text '&OK'.
   
*/
	public static native void about( QWidget parent, String text, String caption, boolean notify);
	public static native void about( QWidget parent, String text);

/** 
 Alternate method to show a messagebox:

*/
	public static native int messageBox( QWidget parent, int type, String text, String caption, String buttonYes, String buttonNo);
	public static native int messageBox( QWidget parent, int type, String text);
	public static native void queuedMessageBox( QWidget parent, int type, String text, String caption);
	public static native void queuedMessageBox( QWidget parent, int type, String text);
	public static final int Ok = 1;
	public static final int Cancel = 2;
	public static final int Yes = 3;
	public static final int No = 4;
	public static final int Continue = 5;
	public static final int QuestionYesNo = 1;
	public static final int WarningYesNo = 2;
	public static final int WarningContinueCancel = 3;
	public static final int WarningYesNoCancel = 4;
	public static final int Information = 5;
	public static final int Sorry = 7;
	public static final int Error = 8;
}
