/***************************************************************************
                            HTMLDocument.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 An <code> HTMLDocument </code> is the root of the HTML hierarchy
 and holds the entire content. Beside providing access to the
 hierarchy, it also provides some convenience methods for accessing
 certain sets of information from the document.

  The following properties have been deprecated in favor of the
 corresponding ones for the BODY element:

  <ulist> <item> alinkColor

  </item> <item> background

  </item> <item> bgColor

  </item> <item> fgColor

  </item> <item> linkColor

  </item> <item> vlinkColor

  </item> </ulist>

 
 @short 
 An <code> HTMLDocument </code> is the root of the HTML hierarchy
 and holds the entire content.
*/
public class HTMLDocument extends Document  {
	protected HTMLDocument(Class dummy){super((Class) null);}

	private native void newHTMLDocument();
	public HTMLDocument() {
		super((Class) null);
		newHTMLDocument();
	}

/** 
 The parent is the widget the document should render itself in.
 Rendering information (like sizes, etc...) is only created if
 parent != 0
     
*/
	private native void newHTMLDocument( KHTMLView parent);
	public HTMLDocument( KHTMLView parent) {
		super((Class) null);
		newHTMLDocument( parent);
	}
	private native void newHTMLDocument( HTMLDocument other);
	public HTMLDocument( HTMLDocument other) {
		super((Class) null);
		newHTMLDocument( other);
	}
	private native void newHTMLDocument( DOMNode other);
	public HTMLDocument( DOMNode other) {
		super((Class) null);
		newHTMLDocument( other);
	}
	protected native void finalize() throws InternalError;

/** 
 The title of a document as specified by the <code> TITLE
 </code> element in the head of the document.

     
*/
	public native String title();

/** 
 see {@link title}
     
*/
	public native void setTitle( String arg1);

/** 
 Returns the URI of the page that linked to this page. The value
 is an empty string if the user navigated to the page directly
 (not through a link, but, for example, via a bookmark).

     
*/
	public native String referrer();

/** 
 The domain name of the server that served the document, or a
 null string if the server cannot be identified by a domain
 name.

     
*/
	public native String domain();

/** 
 The complete URI of the document.

     
*/
	public native String URL();

/** 
 The element that contains the content for the document. In
 documents with <code> BODY </code> contents, returns the <code>
 BODY </code> element, and in frameset documents, this returns
 the outermost <code> FRAMESET </code> element.

     
*/
	public native HTMLElement body();

/** 
 see {@link body}
     
*/
	public native void setBody( HTMLElement arg1);

/** 
 A collection of all the <code> IMG </code> elements in a
 document. The behavior is limited to <code> IMG </code>
 elements for backwards compatibility.

     
*/
	public native HTMLCollection images();

/** 
 A collection of all the <code> OBJECT </code> elements that
 include applets and <code> APPLET </code> ( deprecated )
 elements in a document.

     
*/
	public native HTMLCollection applets();

/** 
 A collection of all <code> AREA </code> elements and anchor (
 <code> A </code> ) elements in a document with a value for the
 <code> href </code> attribute.

     
*/
	public native HTMLCollection links();

/** 
 A collection of all the forms of a document.

     
*/
	public native HTMLCollection forms();

/** 
 A collection of all the anchor ( <code> A </code> ) elements in
 a document with a value for the <code> name </code> attribute.
 Note. For reasons of backwards compatibility, the returned set
 of anchors only contains those anchors created with the <code>
 name </code> attribute, not those created with the <code> id
 </code> attribute.

     
*/
	public native HTMLCollection anchors();

/** 
 A collection of all the <code>IMG</code>, <code>OBJECT</code>,
 <code>AREA</code>, <code>A</code>, forms and anchor elements of
 a document.
     
*/
	public native HTMLCollection all();

/** 
 The cookies associated with this document. If there are none,
 the value is an empty string. Otherwise, the value is a string:
 a semicolon-delimited list of "name, value" pairs for all the
 cookies associated with the page. For example, <code>
 name=value;expires=date </code> .

     
*/
	public native String cookie();

/** 
 see {@link cookie}
     
*/
	public native void setCookie( String arg1);

/** 
 Note. This method and the ones following allow a user to add to
 or replace the structure model of a document using strings of
 unparsed HTML. At the time of writing alternate methods for
 providing similar functionality for both HTML and XML documents
 were being considered. The following methods may be deprecated
 at some point in the future in favor of a more general-purpose
 mechanism.

  Open a document stream for writing. If a document exists in
 the target, this method clears it.

     
*/
	public native void open();

/** 
 Closes a document stream opened by <code> open() </code> and
 forces rendering.

     
*/
	public native void close();

/** 
 Write a string of text to a document stream opened by <code>
 open() </code> . The text is parsed into the document's
 structure model.

     
*/
	public native void write( String text);
//	public native void write( String text);

/** 
 Write a string of text followed by a newline character to a
 document stream opened by <code> open() </code> . The text is
 parsed into the document's structure model.

     
*/
	public native void writeln( String text);

/** 
 Returns the Element whose <code> id </code> is given by
 elementId. If no such element exists, returns <code> null
 </code> . Behavior is not defined if more than one element has
 this <code> id </code> .

     
*/
	public native Element getElementById( String elementId);

/** 
 Returns the (possibly empty) collection of elements whose
 <code> name </code> value is given by <code> elementName
 </code> .

     
*/
	public native ArrayList getElementsByName( String elementName);
//	private native void newHTMLDocument( HTMLDocumentImpl impl);
//	public HTMLDocument( HTMLDocumentImpl impl) {
//		super((Class) null);
//		newHTMLDocument( impl);
//	}
}
