#ifndef INPUTCTL_H
#define INPUTCTL_H
#include <qlineedit.h>
#include <qlabel.h>
#include <qvalidator.h>

class InputCtl : public QWidget {
	Q_OBJECT
public:
	InputCtl(QString const prompt=QString::null, QString const initial=QString::null, QWidget *parent=0, const char *name=0);
	~InputCtl();
	void setText(QString const txt);
	QString const text();
	void resize(int w, int h);
	void setGeometry(int x, int y, int w, int h);
	void setEnabled(bool enable) { inptext->setEnabled(enable); };
	void setValidator(QValidator *v) { inptext->setValidator(v); };
	virtual QSize sizeHint() const;
private:
	QLabel *	lbl1;
	QLineEdit *	inptext;
};
#endif

