/* 
   Copyright (C) 2001 Malte Starostik <malte@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

// $Id: webarchivecreator.h,v 1.1 2001/06/24 21:51:06 schlpbch Exp $
// 
#ifndef __webarchivecreator_h__
#define __webarchivecreator_h__

#include "thumbcreator.h"

class KHTMLPart;

class WebArchiveCreator : public QObject, public ThumbCreator
{
	Q_OBJECT
public:
	WebArchiveCreator();
	virtual ~WebArchiveCreator();
	virtual bool create(const QString &path, int width, int height, QImage &img);
	virtual Flags flags() const;

protected:
	virtual void timerEvent(QTimerEvent *);

private slots:
	void slotCompleted();

private:
	KHTMLPart *m_html;
	bool m_completed;
};

#endif

// vim: ts=4 sw=4 et
