% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.set.rkh.prompter.R
\name{rk.set.rkh.prompter}
\alias{rk.set.rkh.prompter}
\title{Set up an environment to store .rkh related information}
\usage{
rk.set.rkh.prompter(component = NULL, id = NULL, help = NULL, rm = FALSE)
}
\arguments{
\item{component}{Character string,
      should be a unique name to identify the current plugin/component.
If \code{NULL}, this function quits silently without any action.}

\item{id}{Either a character string (the \code{id} of the node to store the help information for),
or an object of class \code{XiMpLe.node} (whose \code{id} will be extracted and used).}

\item{help}{Character string or list of character values and XiMpLe nodes,
      will be used as the \code{text} value for a setting node in the .rkh file.}

\item{rm}{Logical,
      If \code{TRUE} will remove all information stored by the name of \code{component} (if
\code{id=NULL}) or of the given \code{id=NULL}, respectively.}
}
\description{
By using an environment like this, you are able to write information for RKWard help files
directly into your script code of certrain functions,
      like for radio buttons or checkboxes.
}
\details{
The information is temporarily stored in an internal environment,
      using the plugin/component name
you specify. Each entry is named after the ID of its respective node. If you later call
\code{\link[rkwarddev:rk.plugin.component]{rk.plugin.component}} (or it is called by other
functions) and you activate the \code{scan} option for rkh files, the scanning process
will try to find a match for each relevant XML node. That is,
      the info which is stored in the
environment will magically be written into the help file.
}
\examples{
rk.set.rkh.prompter("rk.myPlugin", "someID", "CLick this to feel funny.")
}
