% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.XML.values.R
\name{rk.XML.values}
\alias{rk.XML.values}
\title{Create a value selector for RKWard plugins}
\usage{
rk.XML.values(
  label,
  slot.text,
  options = list(label = c(val = NULL, chk = FALSE, i18n = NULL)),
  required = FALSE,
  multi = FALSE,
  duplicates = FALSE,
  min = 1,
  any = 1,
  max = 0,
  horiz = TRUE,
  add.nodes = NULL,
  frame.label = NULL,
  id.name = "auto",
  help = NULL,
  component = rk.get.comp()
)
}
\arguments{
\item{label}{Character string, a text label for the value browser.}

\item{slot.text}{Character string, a text label for the value selection slot.}

\item{options}{A named list with string values to choose from. The names of the list elements will become
labels of the options, \code{val} defines the value to submit if the value is selected,
      and
\code{chk=TRUE} should be set in the one option which is checked by default. You might also provide an \code{i18n}
for this particular option (see \code{i18n}). Objects generated with \code{\link[rkwarddev:rk.XML.option]{rk.XML.option}}
are accepted as well.}

\item{required}{Logical, whether the selection of values is mandatory or not.}

\item{multi}{Logical, whether the valueslot holds only one or several objects.}

\item{duplicates}{Logical,
      if \code{multi=TRUE} defines whether the same entry may be added multiple times. Sets \code{multi=TRUE}.}

\item{min}{If \code{multi=TRUE} defines how many objects must be selected.}

\item{any}{If \code{multi=TRUE} defines how many objects must be selected at least if any
are selected at all.}

\item{max}{If \code{multi=TRUE} defines how many objects can be selected in total
(0 means any number).}

\item{horiz}{Logical. If \code{TRUE}, the valueslot will be placed next to the selector,
if \code{FALSE} below it.}

\item{add.nodes}{A list of objects of class \code{XiMpLe.node} to be placed after the valueslot.}

\item{frame.label}{Character string, a text label for the whole frame.}

\item{id.name}{Character vector, unique IDs for the frame (first entry),
      the valueselector (second entry)
and valueslot (third entry). If \code{formula.dependent} is not \code{NULL},
      a fourth and fifth entry is needed as well,
for the dependent valueslot and the formula node, respectively.
If \code{"auto"},
      IDs will be generated automatically from \code{label} and \code{slot.text}.}

\item{help}{Character string or list of character values and XiMpLe nodes,
      will be used as the \code{text} value for a setting node in the .rkh file.
If set to \code{FALSE},
      \code{\link[rkwarddev:rk.rkh.scan]{rk.rkh.scan}} will ignore this node.
Also needs \code{component} to be set accordingly!}

\item{component}{Character string,
      name of the component this node belongs to. Only needed if you
want to use the scan features for automatic help file generation; needs \code{help} to be set
accordingly, too!}
}
\value{
An object of class \code{XiMpLe.node}.
}
\description{
This function will create a <frame> node including a <valueselector> and a <valueslot> node. It is
actually a wrapper for \code{\link[rkwarddev:rk.XML.valueslot]{rk.XML.valueslot}} and
\code{\link[rkwarddev:rk.XML.valueselector]{rk.XML.valueselector}},
      since you usually won't define one
without the other.
}
\examples{
test.values <- rk.XML.values("Select some values", "Vars go here")
cat(pasteXML(test.values))
}
\seealso{
\code{\link[rkwarddev:rk.XML.valueslot]{rk.XML.valueslot}},
   \code{\link[rkwarddev:rk.XML.valueselector]{rk.XML.valueselector}},
   and the \href{help:/rkwardplugins/index.html}{Introduction to Writing Plugins for RKWard}
}
