% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.XML.option.R
\name{rk.XML.option}
\alias{rk.XML.option}
\title{Create XML node "option" for RKWard plugins}
\usage{
rk.XML.option(label, val = NULL, chk = FALSE, id.name = NULL, i18n = NULL)
}
\arguments{
\item{label}{Character string, a text label for this plugin element.}

\item{val}{Character string, defines the value to submit if the option is checked.}

\item{chk}{Logical,
      should be set \code{TRUE} in the one option which is checked by default.}

\item{id.name}{Character string, a unique ID for this plugin element.
If \code{"auto"} and a label was provided,
      an ID will be generated automatically from the label.}

\item{i18n}{Either a character string or a named list with the optional elements \code{context}
or \code{comment},
      to give some \code{i18n_context} information for this node. If set to \code{FALSE},
the attribute \code{label} will be renamed into \code{noi18n_label}.}
}
\value{
An object of class \code{XiMpLe.node}.
}
\description{
Create XML node "option" for RKWard plugins
}
\note{
You will rarely need this function, as options can be defined directly as a list
in applicable functions like \code{\link[rkwarddev:rk.XML.radio]{rk.XML.radio}}. The main
purpose for having this function is to set an ID for a particular option, e.g. to be able
to hide it by logic rules.

To address such an option in your logic section, the \code{id}
you need is a combination of \code{<parent id>.<option id>}. That is,
you must always prefix it with the parent's \code{id}. If you use the object
an object generated by this function inside a parent node, both IDs will
automatically be stored internally, so that the correct prefix will be added
if needed whenever you apply logic rules to the option object.
}
\examples{
test.radio <- rk.XML.radio("Chose one",
  options=list(
    "First Option"=c(val="val1", chk=TRUE),
    test.radio.opt2 <- rk.XML.option("Second Option", val="val2", id.name="auto"),
    "third Option"=c(val="val3"))
)
cat(pasteXML(test.radio))
}
\seealso{
\href{help:/rkwardplugins/index.html}{Introduction to Writing Plugins for RKWard}
}
