% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.XML.hierarchy.R
\name{rk.XML.hierarchy}
\alias{rk.XML.hierarchy}
\title{Create XML hierarchy section for RKWard plugins}
\usage{
rk.XML.hierarchy(...)
}
\arguments{
\item{...}{Objects of class \code{XiMpLe.node}, must all be "menu".}
}
\value{
An object of class \code{XiMpLe.node}.
}
\description{
This function will create a hierarchy section for .pluginmap files,
with mandatory child nodes "menu".
}
\examples{
test.component <- rk.XML.component("My GUI dialog", "plugins/MyGUIdialog.xml")
test.entry <- rk.XML.entry(test.component)
test.menu <- rk.XML.menu("Analysis", nodes=test.entry, id.name="analysis")
test.hierarchy <- rk.XML.hierarchy(test.menu)
cat(pasteXML(test.hierarchy))
}
\seealso{
\code{\link[rkwarddev:rk.XML.menu]{rk.XML.menu}},
   \code{\link[rkwarddev:rk.XML.entry]{rk.XML.entry}},
   \code{\link[rkwarddev:rk.XML.component]{rk.XML.component}},
   \code{\link[rkwarddev:rk.XML.components]{rk.XML.components}},
   and the \href{help:/rkwardplugins/index.html}{Introduction to Writing Plugins for RKWard}
}
