% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.JS.scan.R
\name{rk.JS.scan}
\alias{rk.JS.scan}
\title{Create JavaScript variables and functions from plugin XML}
\usage{
rk.JS.scan(
  pXML,
  js = TRUE,
  add.abbrev = FALSE,
  guess.getter = FALSE,
  indent.by = rk.get.indent(),
  mode = "vars",
  script = NULL
)
}
\arguments{
\item{pXML}{Either an object of class \code{XiMpLe.doc} or \code{XiMpLe.node},
      or path to a plugin XML file.}

\item{js}{Logical, if \code{TRUE} usable JavaScript code will be returned,
      otherwise a character
vector with only the relevant ID names.}

\item{add.abbrev}{Logical,
      if \code{TRUE} the JavaScript variables will all have a prefix with an
three letter abbreviation of the XML tag type to improve the readability of the code. But it's
probably better to add this in the XML code in the first place.}

\item{guess.getter}{Logical,
      if \code{TRUE} try to get a good default getter function for JavaScript
variable values. This will use some functions which were added with RKWard 0.6.1,
      and therefore
raise the dependencies for your plugin/component accordingly. Nonetheless,
      it's recommended.}

\item{indent.by}{Character string used to indent each entry if \code{js=TRUE}.}

\item{mode}{Character string to set the operation mode. Currently,
      only \code{"vars"} and \code{"preview"}
are supported. If \code{mode="vars"},
      scans for relevant tags and returns variable definitions or IDs.
If \code{mode="preview"},
      scans only for occurring \code{<preview />} nodes and returns proper function
definitions for the JavaScript file.}

\item{script}{Character string (or list of),
      the actual body of the JavaScript section we're scanning for. If not NULL,
\code{rk.JS.scan} will try return only varaible definitions that are actually being used in the script code.}
}
\value{
A character vector.
}
\description{
Create JavaScript variables and functions from plugin XML
}
\seealso{
\href{help:/rkwardplugins/index.html}{Introduction to Writing Plugins for RKWard}
}
