# The Updated Golden Rules (Immutable Instructions)

### 1. The R Script is the Single Source of Truth
Your sole output will be a single R script that defines all plugin components as R objects and uses `rk.plugin.skeleton()` to write the final files. This script **must** be wrapped in `local({})` to avoid polluting the global environment.

### 2. The Sacred Structure of the Help File (`.rkh`)
This is a critical and error-prone section.
*   The help text elements (`title`, `summary`, `usage`, `sections`) **must** be passed to `rk.rkh.doc()` as **named arguments**.
*   The `sections` argument **must** be a `list` of `rk.rkh.section()` objects.
*   The `rk.rkh.doc()` function in this version does **not** accept an `authors` argument. Author information belongs only in `rk.XML.about()`.

### 3. The Inflexible UI for Variable Selection
To select an R object in a legacy-compatible way, you **must** adhere to this strict structure:
*   **One-to-One Mapping:** Every `rk.XML.varslot` **must** have its own, unique `rk.XML.varselector`. Sharing a single `varselector` among multiple `varslots` will cause a "subscript out of bounds" error.
*   **Sibling Layout:** The `rk.XML.varselector` and its corresponding `rk.XML.varslot` **must** be siblings in the same layout container (e.g., both as direct children of an `rk.XML.row` or `rk.XML.col`). Do not nest the `varslot` in an extra `rk.XML.frame` away from its `varselector`.
*   **The Link:** The `source` argument of the `rk.XML.varslot` must be the ID name of its unique `varselector` (e.g., `source = "my_selector_id"`).

### 4. The `calculate`/`printout` Pattern and `saveobj` Specification
To generate clean R code, you will follow this pattern:
*   **The `calculate` Block:** This block's only responsibility is to generate the R code that performs the computation. The name of the R object being assigned to **must** exactly match the hardcoded string from the `initial` argument of your `rk.XML.saveobj` component (e.g., `echo('my.hardcoded.name <- ...')`).
*   **The `printout` Block:** This block generates user-facing messages. It can use `getValue("...objectname")` for the text of an `rk.header()`, but if it prints a preview of the object, it **must** refer to the same hardcoded object name (e.g., `echo('rk.print(head(my.hardcoded.name))')`).
*   **The `rk.XML.saveobj` Component:** Its `initial` argument **must** be a hardcoded string literal.

### 5. Strict Adherence to Legacy `rkwarddev` Syntax
The target version `0.08-1` has specific function signatures that must be followed.
*   **`rk.XML.dropdown`:** The key for an option's value **must** be `val` (e.g., `list(val = "str_detect")`). Using `value` will result in empty values being returned.
*   **`attr()`:** Use `attr()` after object creation for optional arguments like `required` and `classes`.
*   **About Node:** Plugin metadata **must** be created with `rk.XML.about(name = ..., author = person(...), about = list(...))`.

### 6. Robust JavaScript and R Code Generation
The JavaScript code you define has one purpose: to `echo` valid R code.
*   **`echo()` is King:** Every line of R code you want to execute **must** be wrapped in an `echo("...");` statement.
*   **Line Breaks are Mandatory:** Every R command generated by `echo()` **must** be terminated with a newline character (`\\n`) to ensure it's on its own line in the final R script.
*   **Use `getValue()`:** The `var.map` argument in `rk.plugin.skeleton` is not supported. You **must** retrieve UI state using `getValue("component_id_name")`.

### 7. The Multi-Component Plugin Menu Structure
To create a clean menu structure and avoid invalid pluginmap files, this pattern is mandatory:
*   **Main Plugin and Components:** One functionality must be defined as the "main plugin" (with `xml`, `js`, `rkh` arguments passed directly to `rk.plugin.skeleton`). All other functionalities are defined as `rk.plugin.component` objects and passed as a `list` to the `components` argument.
*   **The Menu Creation Principle:** RKWard builds the menu path by appending the `name` to the `hierarchy` list. The `hierarchy` list must therefore **only** contain the parent menus.
*   **`pluginmap` (for the Main Plugin):** This defines the main plugin's clickable menu entry.
    *   `pluginmap$name`: **Must be the final, user-facing label** for the main plugin's menu item (e.g., `"Detect & Locate Matches"`).
    *   `pluginmap$hierarchy`: **Must be the list of parent menus only** (e.g., `list("data", "String Manipulation (stringr)")`). Do NOT include the plugin's own name here.
*   **`rk.plugin.component` (for other plugins):** The same principle applies.
    *   `name`: **Must be the final, user-facing label** for that component's menu item (e.g., `"Mutate Strings"`).
    *   `hierarchy`: **Must be the list of parent menus only** (e.g., `list("data", "String Manipulation (stringr)")`).
