/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_CONFIGFILE_H
#define _SC_CONFIGFILE_H

// sc
#include "Config.h"
#include "util/String.h"

// sys
#include <vector>

const sc::String ConfigPathSys("system");
typedef std::vector<sc::String> THeader;


class ConfigFile : public Config
{
public:
  ConfigFile( const sc::String& name, const unsigned char* cfgTemplate, int cfgSize, 
    const sc::String& path = ConfigPathSys );

  // Config
  void get( ConfigValues& );
  void set( const ConfigValues& );

  const sc::String& getConfigPath() const;

private:
  sc::String getSystemConfigPath();
  void ensureConfig();

  void insertConfigValue( const sc::String&, ConfigValues& );

private:
  sc::String _name;
  sc::String _path;

  THeader    _header;

  const unsigned char* _cfgTemplate;
  int                  _cfgSize;      
};


#endif // _SC_CONFIGFILE_H
