/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _LINECONFIG_H
#define _LINECONFIG_H


class LineConfig
{
public:
  LineConfig()
  {
    _tabWidth             = 2;

    _charCariageReturn    = 'c';
    _charLineFeed         = 'l';
    _charSpace            = '.';
    _charTab              = '>';

    _visibleCariageReturn = true;
    _visibleLineFeed      = true;
    _visibleSpace         = true;
    _visibleTab           = true;
  }

  unsigned int getTabWidth() const
  {
    return _tabWidth;
  }

  char getCharCariageReturn() const
  {
    return _charCariageReturn;
  }

  char getCharLineFeed() const
  {
    return _charLineFeed;
  }

  char getCharSpace() const
  {
    return _charSpace;
  }

  char getCharTab() const
  {
    return _charTab;
  }

  bool isVisibleCariageReturn() const
  {
    return _visibleCariageReturn;
  }

  bool isVisibleLineFeed() const
  {
    return _visibleLineFeed;
  }

  bool isVisibleSpace() const
  {
    return _visibleSpace;
  }

  bool isVisibleTab() const
  {
    return _visibleTab;
  }

private:
  unsigned int  _tabWidth;

  char _charCariageReturn;
  char _charLineFeed;
  char _charSpace;
  char _charTab;

  bool _visibleCariageReturn;
  bool _visibleLineFeed;
  bool _visibleSpace;
  bool _visibleTab;
};

#endif // LINECONFIG_H
