/*
# PostgreSQL Database Modeler (pgModeler)
#
# Copyright 2006-2018 - Raphael Araújo e Silva <raphael@pgmodeler.io>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3.
#
# This program is distributed in the hope that it will be useful),
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# The complete text of GPLv3 is at LICENSE file on source code root directory.
# Also), you can get the complete GNU General Public License at <http://www.gnu.org/licenses/>
*/

/**
\ingroup libparsers
\namespace ParsersAttributes
\brief Definition of parsers attributes namespace which stores a series of static strings constants used
 to reference the attributes of objects in SQL/XML generation methods.
 Each string stores the name of the attribute used in the schema file "sch" of the respective objects.
\note <strong>Creation date:</strong> 23/09/2008
*/

#ifndef PARSERS_ATTRIBUTES_H
#define PARSERS_ATTRIBUTES_H

/* Including QByteArray due to 'QByteArray has no toStdString()'
   error on Qt 5.4 (Windows only) */
#include <QByteArray>
#include <QString>

namespace ParsersAttributes {
	extern const QString
	_FALSE_,
	_FILE_,
	_LC_COLLATE_,
	_LC_CTYPE_,
	_TRUE_,
	ADMIN_OPTION,
	ADMIN_ROLES,
	ALIAS,
	ALIGNMENT,
	ALIGN_OBJS_TO_GRID,
	ALTER_CMDS,
	ALLOW_CONNS,
	ANALYZE_FUNC,
	ANCESTOR_TABLE,
	APPEND_AT_EOD,
	APPENDED_SQL,
	APPLICATION,
	ARG_COUNT,
	ARG_DEF_COUNT,
	ARG_DEFAULTS,
	ARG_MODES,
	ARG_NAMES,
	ARG_TYPES,
	ARGUMENTS,
	ASC_ORDER,
	ASSIGNMENT,
	ATTRIBUTE,
	AUTO_BROWSE_DB,
	AUTOSAVE_INTERVAL,
	BACKGROUND_COLOR,
	BASE_TYPE,
	BEFORE,
	BEHAVIOR_TYPE,
	BOLD,
	BORDER_COLOR,
	BOTTOM,
	BUFFERING,
	BY_VALUE,
	BYPASSRLS,
	CACHE,
	CANONICAL_FUNC,
	CANVAS_CORNER_MOVE,
	CASCADE,
	CASE_SENSITIVE,
	CAST_TYPE,
	CATEGORY,
	CHANGE,
	CHANGELOG,
	CHECK_EXP,
	CHECK_UPDATE,
	CK_CONSTR,
	CLIENT_ENCODING,
	CODE_COMPLETION,
	CODE_FONT_SIZE,
	CODE_FONT,
	CODE_TAB_WIDTH,
	COL_INDEXES,
	COLLATABLE,
	COLLATION,
	COLLATIONS,
	COLOR,
	COLORS,
	COLS_COMMENT,
	COL_IS_IDENTITY,
	COLUMN_ALIAS,
	COLUMN,
	COLUMNS,
	COMMAND,
	COMMANDS,
	COMMENT,
	COMMUTATOR_OP,
	COMPARISON_TYPE,
	COMPLETION_TRIGGER,
	COMPOSITE_TYPE,
	CONCURRENT,
	CONDITION,
	CONFIGURATION,
	CONFIG_FILE,
	CONFIRM_VALIDATION,
	CONN_LIMIT,
	CONNECT_CENTER_PNTS,
	CONNECT_FK_TO_PK,
	CONNECT_TABLE_EDGES,
	CONNECT_PRIV,
	CONNECTION,
	CONNECTIONS,
	CONNECTION_TIMEOUT,
	CONSTR_DEFS,
	CONSTR_INDEXES,
	CONSTR_SQL_DISABLED,
	CONSTRAINT,
	CONSTRAINTS,
	CONTENTS,
	COPY_MODE,
	COPY_OPTIONS,
	COPY_TABLE,
	CREATE_CMDS,
	CREATE_PRIV,
	CREATE,
	CREATEDB,
	CREATEROLE,
	CROWS_FOOT,
	CTE_EXPRESSION,
	CUR_VERSION,
	CUSTOM_COLOR,
	CUSTOM_FILTER,
	CUSTOMIDXS,
	CYCLE,
	DATABASE,
	DATA_DIRECTORY,
	DATE,
	DB_MODEL,
	DDL_END_TOKEN,
	DECL_IN_TABLE,
	DECLARATION,
	DEFAULT_COLLATION,
	DEFAULT_FOR_OPS,
	DEFAULT_OWNER,
	DEFAULT_SCHEMA,
	DEFAULT_TABLESPACE,
	DEFAULT_VALUE,
	DEFAULT,
	DEFER_TYPE,
	DEFERRABLE,
	DEFINITION,
	DEL_ACTION,
	DEL_EVENT,
	DELETE_PRIV,
	DELIMITER,
	DEST_TYPE,
	DST_TYPE,
	DIFF,
	DIMENSION,
	DIRECTORY,
	DISABLE_SMOOTHNESS,
	DISPLAY_LINE_NUMBERS,
	DOM_CONSTRAINT,
	DOCK_WIDGETS,
	DROP_CMDS,
	DROP,
	DST_COL_PATTERN,
	DST_COLUMNS,
	DST_ENCODING,
	DST_FK_PATTERN,
	DST_LABEL,
	DST_REQUIRED,
	DST_TABLE,
	DYNAMIC_LIBRARY_PATH,
	DYNAMIC_SHARED_MEMORY,
	ELEMENT,
	ELEMENTS,
	ENCODING,
	ENCRYPTED,
	END_EXP,
	ENUM_TYPE,
	ENUMERATIONS,
	EVENT_TYPE,
	EVENT,
	EVENTS,
	EX_CONSTR,
	EXACT_MATCH,
	EXC_BUILTIN_ARRAYS,
	EXCLUDE_ELEMENT,
	EXEC_TYPE,
	EXECUTE_PRIV,
	EXECUTION_COST,
	EXISTING_VALUE,
	EXPLICIT,
	EXPORT,
	EXPORT_TO_FILE,
	EXPRESSION,
	EXPRESSIONS,
	EXT_OBJ_OIDS,
	FACTOR,
	FADEIN_OBJECTS,
	FADED_OUT,
	FAMILY,
	FAST_UPDATE,
	FILE_ASSOCIATED,
	FILL_COLOR,
	FILTER_OIDS,
	FILTER_TABLE_TYPES,
	FILTER,
	FINAL_FUNC,
	FIRING_TYPE,
	FK_COLUMN,
	FK_CONSTR,
	FK_DEFS,
	FONT_SIZE,
	FONT,
	FOREGROUND_COLOR,
	FOREIGN_KEYS,
	FROM_EXP,
	FUNCTION_TYPE,
	FUNCTION,
	GENERAL,
	GEN_ALTER_CMDS,
	GLOBAL,
	GRANT_OP,
	GRID_SIZE,
	GROUP,
	HANDLER_FUNC,
	HANDLES_TYPE,
	HAS_CHANGES,
	HASHES,
	HBA_FILE,
	HIDE_EXT_ATTRIBS,
	HIDE_REL_NAME,
	HIDE_TABLE_TAGS,
	HIGHLIGHT_LINES,
	HIGHLIGHT_ORDER,
	HISTORY_MAX_LENGTH,
	ICON,
	ID,
	IDENTIFIER,
	IDENTITY_TYPE,
	IGNORED_CHARS,
	IMPLICIT,
	IMPORT,
	INCREMENT,
	IDENT_FILE,
	INDEX_ELEMENT,
	INDEX_TYPE,
	INDEX,
	INDEXES,
	INFO,
	INH_COLUMN,
	INH_COLUMNS,
	INHERIT,
	INHERITED,
	INITIAL_COND,
	INITIAL_DATA,
	INITIAL_EXP,
	INLINE_FUNC,
	INPUT_FUNC,
	INS_EVENT,
	INSERT_PRIV,
	INTERNAL_LENGTH,
	INTERVAL_TYPE,
	INVERT_RANGESEL_TRIGGER,
	IO_CAST,
	IS_TEMPLATE,
	ITALIC,
	JOIN_FUNC,
	LABEL,
	LABELS_POS,
	LANDSCAPE,
	LANGUAGE,
	LAST_POSITION,
	LAST_SYS_OID,
	LAST_VALUE,
	LAST_ZOOM,
	LEAKPROOF,
	LEFT_TYPE,
	LEFT,
	LENGTH,
	LIBRARY,
	LIKE_TYPE,
	LINE,
	LINE_NUMBERS_COLOR,
	LINE_NUMBERS_BG_COLOR,
	LINE_HIGHLIGHT_COLOR,
	LISTEN_ADDRESSES,
	LOCALE,
	LOCKER_ARC,
	LOCKER_BODY,
	LOGIN,
	LOOKAHEAD_CHAR,
	MATERIALIZED,
	MAX_CONNECTIONS,
	MAX_VALUE,
	MEMBER_ROLES,
	MEMBER,
	MERGES,
	METADATA,
	MIN_OBJECT_OPACITY,
	MIN_VALUE,
	MODE,
	MODEL_AUTHOR,
	NAME_LABEL,
	NAME_PATTERNS,
	NAME,
	NAMES,
	NEGATOR_OP,
	NEW_NAME,
	NEW_IDENTITY_TYPE,
	NEW_VERSION,
	NN_COLUMN,
	NO_INHERIT,
	NONE,
	NOT_EXT_OBJECT,
	NOT_NULL,
	NULLS_FIRST,
	OBJ_SELECTION,
	OBJECT_ID,
	OBJECT_FINDER,
	OBJECT_TYPE,
	OBJECT,
	OBJECTS,
	OID_FILTER_OP,
	OID,
	OIDS,
	OLD_NAME,
	OLD_VERSION,
	OP_CLASS,
	OP_CLASSES,
	OP_FAMILY,
	OP_LIST_SIZE,
	OPERATOR_FUNC,
	OPERATOR,
	OPERATORS,
	OUTPUT_FUNC,
	OWNER_COLUMN,
	OWNER,
	PAPER_CUSTOM_SIZE,
	PAPER_MARGIN,
	PAPER_ORIENTATION,
	PAPER_TYPE,
	PARAM_IN,
	PARAM_OUT,
	PARAM_VARIADIC,
	PARAMETER,
	PARAMETERS,
	PARENT,
	PARENTS,
	PARSABLE,
	PARTIAL_MATCH,
	PASSWORD,
	PASSWORD_ENCRYPTION,
	PATH,
	PATTERNS,
	PER_ROW,
	PERMISSION,
	PERMISSIVE,
	PGMODELER_VERSION,
	PGSQL_BASE_TYPE,
	PGSQL_VERSION,
	PLACEHOLDER,
	PLACEHOLDERS,
	PK_COL_PATTERN,
	PK_COLUMN,
	PK_CONSTR,
	PK_PATTERN,
	POINTS,
	PORT,
	PORTRAIT,
	POSITION_INFO,
	POSITION,
	PRECISION,
	PREDICATE,
	PREFERRED,
	PREPEND_AT_BOD,
	PREPENDED_SQL,
	PRINT_GRID,
	PRINT_PG_NUM,
	PRIVILEGES_GOP,
	PRIVILEGES,
	PROT_COLUMN,
	PROTECTED,
	RANGE_ATTRIBS,
	RANGE_TYPE,
	RECENT_MODELS,
	RECENT,
	RECT_VISIBLE,
	RECURSIVE,
	RECV_FUNC,
	REDUCED_FORM,
	REF_COLUMN,
	REF_ROLES,
	REF_TABLE,
	REF_TYPE,
	REFER,
	REFERENCE,
	REFERENCE_FK,
	REFERENCES_PRIV,
	REFERENCES,
	REFERRERS,
	REGULAR_EXP,
	RELATION_TAB_VIEW,
	RELATIONSHIP_11,
	RELATIONSHIP_1N,
	RELATIONSHIP_DEP,
	RELATIONSHIP_FK,
	RELATIONSHIP_GEN,
	RELATIONSHIP_NN,
	RELATIONSHIP,
	RENAME,
	REPLICATION,
	RESTART_SEQ,
	RESTRICTION_FUNC,
	RETURN_TABLE,
	RETURN_TYPE,
	RETURNS_SETOF,
	REVOKE,
	RIGHT_TYPE,
	RIGHT,
	RLS_ENABLED,
	RLS_FORCED,
	ROLE_TYPE,
	ROLE,
	ROLES,
	ROW_AMOUNT,
	RULES,
	SAVE_LAST_POSITION,
	SCHEMA,
	SEARCH_PATH,
	SECURITY_TYPE,
	SELECT_EXP,
	SELECT_PRIV,
	SELECT_OBJECTS,
	SEND_FUNC,
	SEQUENCE,
	SERVER_ENCODING,
	SERVER_VERSION,
	SERVER_PID,
	SERVER_PROTOCOL,
	SET_PERMS,
	SHARED_OBJ,
	SHELL_TYPES,
	SHOW_CANVAS_GRID,
	SHOW_PAGE_DELIMITERS,
	SHOW_ATTRIBUTES_GRID,
	SHOW_SOURCE_PANE,
	SHOW_MAIN_MENU,
	SIGNATURE,
	SIMPLE_EXP,
	SIMPLIFIED_OBJ_CREATION,
	SINGLE_PK_COLUMN,
	SIZE,
	SNIPPET,
	SORT_OP,
	SOURCE_EDITOR_APP,
	SOURCE_EDITOR_ARGS,
	SOURCE_TYPE,
	SRC_TYPE,
	SPATIAL_TYPE,
	SPECIAL_PK_COLS,
	SQL_DISABLED,
	SQL_OBJECT,
	SQL_VALIDATION,
	SQL_TOOL,
	SRC_COL_PATTERN,
	SRC_COLUMNS,
	SRC_ENCODING,
	SRC_FK_PATTERN,
	SRC_LABEL,
	SRC_REQUIRED,
	SRC_TABLE,
	SRID,
	SSL,
	SSL_CA_FILE,
	SSL_CERT_FILE,
	SSL_CRL_FILE,
	SSL_KEY_FILE,
	START,
	STATE_TYPE,
	STORAGE_PARAMS,
	STORAGE,
	STRATEGY_NUM,
	STYLE,
	STYLES,
	SUBTYPE_DIFF_FUNC,
	SUBTYPE,
	SUPERUSER,
	SYMBOL,
	TABLE_BODY,
	TABLE_EXT_BODY,
	TABLE_NAME,
	TABLE_OBJECT,
	TABLE_SCHEMA_NAME,
	TABLE_TITLE,
	TABLE,
	TABLE_TYPE,
	TABLESPACE,
	TAG,
	TEMPLATE_DB,
	TEMPORARY_PRIV,
	TOP,
	TPMOD_IN_FUNC,
	TPMOD_OUT_FUNC,
	TRANSITION_FUNC,
	TRIGGER_FUNC,
	TRIGGER_PRIV,
	TRIGGERS,
	TRUNC_EVENT,
	TRUNCATE_CMDS,
	TRUNCATE_PRIV,
	TRUNCATE,
	TRUSTED,
	TYPE_ATTRIBUTE,
	TYPE_OID,
	TYPE,
	TYPES,
	TYPE_CLASS,
	UI_LANGUAGE,
	UNDERLINE,
	UNIQUE,
	UNLOGGED,
	UNSET_PERMS,
	UNSET,
	UPD_ACTION,
	UPD_EVENT,
	UPDATE_PRIV,
	UQ_COLUMN,
	UQ_CONSTR,
	UQ_PATTERN,
	USAGE_PRIV,
	USE_CURVED_LINES,
	USE_PLACEHOLDERS,
	USE_SORTING,
	USE_UNIQUE_NAMES,
	USING_EXP,
	VALIDATOR_FUNC,
	VALIDATOR,
	VALIDITY,
	VALIDATION,
	VALUE,
	VALUES,
	VARIABLE,
	VARIATION,
	VIEW_BODY,
	VIEW_EXT_BODY,
	VIEW_NAME,
	VIEW_SCHEMA_NAME,
	VIEW_TITLE,
	VISIBLE,
	WIDGET,
	WILDCARD,
	WINDOW_FUNC,
	WITH_NO_DATA,
	WITH_TIMEZONE,
	WITHOUT_OIDS,
	WORD_DELIMITERS,
	WORD_SEPARATORS,
	WORKING_DIR,
	X_POS,
	Y_POS;
}

#endif
