/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;

@Immutable
public class NewValue {
    private final double magnitude;
    private final String unit;

    public static NewValue create(double value, String unit) {
        return new NewValue(value, (String)Preconditions.checkNotNull((Object)unit));
    }

    private NewValue(double value, String unit) {
        this.magnitude = value;
        this.unit = unit;
    }

    public String unit() {
        return this.unit;
    }

    public double magnitude() {
        return this.magnitude;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NewValue) {
            NewValue that = (NewValue)obj;
            return this.magnitude == that.magnitude && this.unit.equals(that.unit);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.magnitude, this.unit});
    }

    public String toString() {
        return this.magnitude + this.unit;
    }
}

