--  DO NOT EDIT THIS FILE.
--  It is generated automatically, by program c-posix.c
------------------------------------------------------------------------------
--                                                                          --
--   POSIX Ada95 Bindings for Protocol Independent Interfaces (P1003.5c)    --
--                                                                          --
--                          P O S I X . L I M I T S                         --
--                                                                          --
--                                   S p e c                                --
--                                                                          --
--                                                                          --
--                                                                          --
--  This  file  is a component of  FLORIST,  an  Ada  application  program  --
--  interface for operating system services for use with the GNAT compiler  --
--  and the  Gnu  Ada  Runtime  Library (GNARL).   FLORIST  is intended to  --
--  conform to the IEEE POSIX Ada standards, 1003.5-1992 and 1003.5b-1993.  --
--  It also includes support for Draft 1 of IEEE Project 1003.5c.           --
--                                                                          --
--  This package specification contains some text extracted from  IEEE STD  --
--  1003.5: 1990, Information Technology -- POSIX Ada Language  Interfaces  --
--  Part 1: Binding  for  System Application Program Interface, as amended  --
--  by IEEE STD 1003.5b: 1996, Amendment 1: Realtime Extensions, copyright  --
--  1996 by the Institute of Electrical and Electronics Engineers, Inc.     --
--                                                                          --
--  The package specifications in the IEEE standards cited above represent  --
--  only a  portion  of  the  documents  and  are  not to be interpreteted  --
--  outside the context  of  the documents.  The standards must be used in  --
--  conjunction  with  the  package   specifications  in  order  to  claim  --
--  conformance.   The IEEE takes no responsibility for and will assume no  --
--  liability for damages resulting from the reader's misinterpretation of  --
--  said  information resulting from its out-of-context nature.   To order  --
--  copies of the IEEE standards,  please contact the  IEEE Service Center  --
--  at 445 Hoes Lane, PO Box 1331, Piscataway, NJ 08855-1331; via phone at  --
--  1-800-678-IEEE, 908-981-1393; or via fax at 908-981-9667.               --
--                                                                          --
--  These  package  specifications are  distributed in  the hope that they  --
--  will  be useful, but  WITHOUT  ANY  WARRANTY; without even the implied  --
--  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.        --
--                                                                          --
------------------------------------------------------------------------------
package POSIX.Limits is

   ------------------------------
   --  Portable System Limits  --
   ------------------------------
   --  .... Change P1003.5b?
   --  to allow these constants
   --  to be larger than the minimum values specified.

   Portable_Argument_List_Maximum : Natural
      renames POSIX.Portable_Argument_List_Maximum;
   Portable_Asynchronous_IO_Maximum :
      constant Natural := 1;
   Portable_Child_Processes_Maximum : Natural
      renames POSIX.Portable_Child_Processes_Maximum;
   Portable_Clock_Resolution_Minimum :
      constant := 20_000_000;
   Portable_Filename_Maximum : Natural
      renames POSIX.Portable_Filename_Limit_Maximum;
   Portable_Groups_Maximum : Natural
      renames POSIX.Portable_Groups_Maximum;
   Portable_Input_Line_Maximum : POSIX.IO_Count
      renames POSIX.Portable_Input_Line_Limit_Maximum;
   Portable_Input_Queue_Maximum : POSIX.IO_Count
      renames POSIX.Portable_Input_Queue_Limit_Maximum;
   Portable_Links_Maximum : Natural
      renames POSIX.Portable_Link_Limit_Maximum;
   Portable_List_IO_Maximum :
      constant Natural := 2;
   Portable_Message_Priority_Maximum :
      constant Natural := 32;
   Portable_Open_Files_Maximum : Natural
      renames POSIX.Portable_Open_Files_Maximum;
   Portable_Open_Message_Queues_Maximum :
      constant Natural := 8;
   Portable_Pathname_Maximum : Natural
      renames POSIX.Portable_Pathname_Limit_Maximum;
   Portable_Pipe_Length_Maximum : POSIX.IO_Count
      renames POSIX.Portable_Pipe_Limit_Maximum;
   Portable_Queued_Signals_Maximum :
      constant Natural := 32;
   Portable_Realtime_Signals_Maximum :
      constant Natural := 8;
   Portable_Semaphores_Maximum :
      constant Natural := 256;
   Portable_Semaphores_Value_Maximum :
      constant Natural := 32767;
   Portable_Streams_Maximum : Natural
      renames POSIX.Portable_Stream_Maximum;
   Portable_Timer_Overruns_Maximum :
      constant Natural := 32;
   Portable_Timers_Maximum :
      constant Natural := 32;
   Portable_Time_Zone_String_Maximum : Natural
      renames POSIX.Portable_Time_Zone_String_Maximum;

   --  limits from POSIX.5c [D2]

   Portable_File_Descriptor_Set_Maximum : Natural
      renames POSIX.Portable_Open_Files_Maximum;
   Portable_Socket_Buffer_Maximum : POSIX.IO_Count
      renames POSIX.Portable_Pipe_Limit_Maximum;
   Portable_Socket_IO_Vector_Maximum :
      constant Natural := 16;
   Portable_Socket_Connection_Maximum :
      constant Natural := 1;
   Portable_XTI_IO_Vector_Maximum :
      constant Natural := 16;

   ---------------------------
   --  Configurable Limits  --
   ---------------------------
   subtype Argument_List_Maxima is
      POSIX.Argument_List_Maxima;
   subtype Asynchronous_IO_Maxima is Natural range
      1 .. Natural'Last;
   subtype Asynchronous_IO_Priority_Delta_Maxima is Natural range
      20 .. 20;
   subtype Child_Processes_Maxima is
      POSIX.Child_Processes_Maxima;
   subtype Filename_Maxima is
      POSIX.Filename_Limit_Maxima;
   subtype Groups_Maxima is
      POSIX.Groups_Maxima;
   subtype Input_Line_Maxima is
      POSIX.Input_Line_Limit_Maxima;
   subtype Input_Queue_Maxima is
      POSIX.Input_Queue_Limit_Maxima;
   subtype Links_Maxima is
      POSIX.Link_Limit_Maxima;
   subtype List_IO_Maxima is Natural range
      2 .. Natural'Last;
   subtype Message_Priority_Maxima is Natural range
      32768 .. 32768;
   subtype Open_Message_Queues_Maxima is Natural range
      8 .. Natural'Last;
   subtype Open_Files_Maxima is
      POSIX.Open_Files_Maxima;
   subtype Page_Size_Range  is Natural range 4096 .. 4096;
   subtype Pathname_Maxima is
      POSIX.Pathname_Limit_Maxima;
   subtype Pipe_Length_Maxima is
      POSIX.Pipe_Limit_Maxima;
   subtype Queued_Signals_Maxima is Natural range
      32 .. Natural'Last;
   subtype Realtime_Signals_Maxima is Natural range
      32 .. 32;
   subtype Semaphores_Maxima is Natural range
      256 .. Natural'Last;
   subtype Semaphores_Value_Maxima is Natural range
      2147483647 .. 2147483647;
   subtype Streams_Maxima is
      POSIX.Stream_Maxima;
   subtype Timer_Overruns_Maxima is Natural range
      2147483647 .. 2147483647;
   subtype Timers_Maxima is Natural range
      32 .. Natural'Last;
   subtype Time_Zone_String_Maxima is
      POSIX.Time_Zone_String_Maxima;

   --  limits from POSIX.5c [D2]

   subtype File_Descriptor_Set_Maxima is Natural range
      1024 .. 1024;
   subtype Socket_Buffer_Maxima is IO_Count range
      512 .. IO_Count'Last;
   subtype Socket_IO_Vector_Maxima is Natural range
      1024 .. 1024;
   subtype Socket_Connection_Maxima is Natural range
      1 .. Natural'Last;
   subtype XTI_IO_Vector_Maxima is Natural range
      16 .. Natural'Last;
end POSIX.Limits;
