#
# PySNMP MIB module RFC1382-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/RFC1382-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:26:33 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( OctetString, ObjectIdentifier, Integer, ) = mibBuilder.importSymbols("ASN1", "OctetString", "ObjectIdentifier", "Integer")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsUnion, ValueSizeConstraint, SingleValueConstraint, ValueRangeConstraint, ConstraintsIntersection, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsUnion", "ValueSizeConstraint", "SingleValueConstraint", "ValueRangeConstraint", "ConstraintsIntersection")
( PositiveInteger, ) = mibBuilder.importSymbols("RFC1253-MIB", "PositiveInteger")
( EntryStatus, ) = mibBuilder.importSymbols("RFC1271-MIB", "EntryStatus")
( IfIndexType, ) = mibBuilder.importSymbols("RFC1381-MIB", "IfIndexType")
( ModuleCompliance, NotificationGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup")
( IpAddress, iso, ObjectIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, ModuleIdentity, Counter32, NotificationType, transmission, Bits, TimeTicks, Integer32, Gauge32, Counter64, Unsigned32, ) = mibBuilder.importSymbols("SNMPv2-SMI", "IpAddress", "iso", "ObjectIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "ModuleIdentity", "Counter32", "NotificationType", "transmission", "Bits", "TimeTicks", "Integer32", "Gauge32", "Counter64", "Unsigned32")
( TextualConvention, DisplayString, ) = mibBuilder.importSymbols("SNMPv2-TC", "TextualConvention", "DisplayString")
x25 = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 5))
class X121Address(OctetString):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(0,17)

x25AdmnTable = MibTable((1, 3, 6, 1, 2, 1, 10, 5, 1), )
if mibBuilder.loadTexts: x25AdmnTable.setDescription('This table contains the administratively\n                          set configuration parameters for an X.25\n                          Packet Level Entity (PLE).\n\n                         Most of the objects in this table have\n                          corresponding objects in the x25OperTable.\n                          This table contains the values as last set\n                          by the administrator.  The x25OperTable\n                          contains the values actually in use by an\n                          X.25 PLE.\n\n                          Changing an administrative value may or may\n                          not change a current operating value.  The\n                          operating value may not change until the\n                          interface is restarted.  Some\n                          implementations may change the values\n                          immediately upon changing the administrative\n                          table.  All implementations are required to\n                          load the values from the administrative\n                          table when initializing a PLE.')
x25AdmnEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 5, 1, 1), ).setIndexNames((0, "RFC1382-MIB", "x25AdmnIndex"))
if mibBuilder.loadTexts: x25AdmnEntry.setDescription('Entries of x25AdmnTable.')
x25AdmnIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 1), IfIndexType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25AdmnIndex.setDescription('The ifIndex value for the X.25 Interface.')
x25AdmnInterfaceMode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("dte", 1), ("dce", 2), ("dxe", 3),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnInterfaceMode.setDescription('Identifies DCE/DTE mode in which the\n                          interface operates.  A value of dxe\n                          indicates the mode will be determined by XID\n                          negotiation.')
x25AdmnMaxActiveCircuits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,4096))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnMaxActiveCircuits.setDescription('The maximum number of circuits this PLE can\n                          support; including PVCs.')
x25AdmnPacketSequencing = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("modulo8", 1), ("modulo128", 2),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnPacketSequencing.setDescription('The modulus of the packet sequence number\n                          space.')
x25AdmnRestartTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 5), PositiveInteger()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnRestartTimer.setDescription('The T20 restart timer in milliseconds.')
x25AdmnCallTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 6), PositiveInteger()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnCallTimer.setDescription('The T21 Call timer in milliseconds.')
x25AdmnResetTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 7), PositiveInteger()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnResetTimer.setDescription('The T22 Reset timer in milliseconds.')
x25AdmnClearTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 8), PositiveInteger()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnClearTimer.setDescription('The T23 Clear timer in milliseconds.')
x25AdmnWindowTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 9), PositiveInteger()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnWindowTimer.setDescription('The T24 window status transmission timer in\n                          milliseconds.  A value of 2147483647\n                          indicates no window timer in use.')
x25AdmnDataRxmtTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 10), PositiveInteger()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnDataRxmtTimer.setDescription('The T25 data retransmission timer in\n\n\n                          milliseconds.  A value of 2147483647\n                          indicates no data retransmission timer in\n                          use.')
x25AdmnInterruptTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 11), PositiveInteger()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnInterruptTimer.setDescription('The T26 interrupt timer in milliseconds.  A\n                          value of 2147483647 indicates no interrupt\n                          timer in use.')
x25AdmnRejectTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 12), PositiveInteger()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnRejectTimer.setDescription('The T27 Reject retransmission timer in\n                          milliseconds.  A value of 2147483647\n                          indicates no reject timer in use.')
x25AdmnRegistrationRequestTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 13), PositiveInteger()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnRegistrationRequestTimer.setDescription('The T28 registration timer in milliseconds.\n                          A value of 2147483647 indicates no\n                          registration timer in use.')
x25AdmnMinimumRecallTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 14), PositiveInteger()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnMinimumRecallTimer.setDescription('Minimum time interval between unsuccessful\n                          call attempts in milliseconds.')
x25AdmnRestartCount = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 15), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnRestartCount.setDescription('The R20 restart retransmission count.')
x25AdmnResetCount = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 16), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnResetCount.setDescription('The r22 Reset retransmission count.')
x25AdmnClearCount = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 17), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnClearCount.setDescription('The r23 Clear retransmission count.')
x25AdmnDataRxmtCount = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 18), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnDataRxmtCount.setDescription('The R25 Data retransmission count.  This\n                          value is irrelevant if the\n                          x25AdmnDataRxmtTimer indicates no timer in\n                          use.')
x25AdmnRejectCount = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 19), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnRejectCount.setDescription('The R27 reject retransmission count.  This\n                          value is irrelevant if the\n                          x25AdmnRejectTimer indicates no timer in\n                          use.')
x25AdmnRegistrationRequestCount = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 20), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnRegistrationRequestCount.setDescription('The R28 Registration retransmission Count.\n                          This value is irrelevant if the\n                          x25AdmnRegistrationRequestTimer indicates no\n                          timer in use.')
x25AdmnNumberPVCs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 21), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,4096))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnNumberPVCs.setDescription('The number of PVC configured for this PLE.\n                          The PVCs use channel numbers from 1 to this\n                          number.')
x25AdmnDefCallParamId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 22), ObjectIdentifier()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnDefCallParamId.setDescription('This identifies the instance of the\n                          x25CallParmIndex for the entry in the\n                          x25CallParmTable which contains the default\n                          call parameters for this PLE.')
x25AdmnLocalAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 23), X121Address()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnLocalAddress.setDescription('The local address for this PLE subnetwork.\n                          A zero length address maybe returned by PLEs\n                          that only support PVCs.')
x25AdmnProtocolVersionSupported = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 24), ObjectIdentifier()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnProtocolVersionSupported.setDescription('Identifies the version of the X.25 protocol\n                          this interface should support.  Object\n                          identifiers for common versions are defined\n                          below in the x25ProtocolVersion subtree.')
x25OperTable = MibTable((1, 3, 6, 1, 2, 1, 10, 5, 2), )
if mibBuilder.loadTexts: x25OperTable.setDescription('The operation parameters in use by the X.25\n                          PLE.')
x25OperEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 5, 2, 1), ).setIndexNames((0, "RFC1382-MIB", "x25OperIndex"))
if mibBuilder.loadTexts: x25OperEntry.setDescription('Entries of x25OperTable.')
x25OperIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 1), IfIndexType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperIndex.setDescription('The ifIndex value for the X.25 interface.')
x25OperInterfaceMode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("dte", 1), ("dce", 2), ("dxe", 3),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperInterfaceMode.setDescription('Identifies DCE/DTE mode in which the\n                          interface operates.  A value of dxe\n                          indicates the role will be determined by XID\n                          negotiation at the Link Layer and that\n                          negotiation has not yet taken place.')
x25OperMaxActiveCircuits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,4096))).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperMaxActiveCircuits.setDescription('Maximum number of circuits this PLE can\n                          support.')
x25OperPacketSequencing = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("modulo8", 1), ("modulo128", 2),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperPacketSequencing.setDescription('The modulus of the packet sequence number\n                          space.')
x25OperRestartTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 5), PositiveInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperRestartTimer.setDescription('The T20 restart timer in milliseconds.')
x25OperCallTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 6), PositiveInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperCallTimer.setDescription('The T21 Call timer in milliseconds.')
x25OperResetTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 7), PositiveInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperResetTimer.setDescription('The T22 Reset timer in milliseconds.')
x25OperClearTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 8), PositiveInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperClearTimer.setDescription('The T23 Clear timer in milliseconds.')
x25OperWindowTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 9), PositiveInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperWindowTimer.setDescription('The T24 window status transmission timer\n\n\n                          milliseconds.  A value of 2147483647\n                          indicates no window timer in use.')
x25OperDataRxmtTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 10), PositiveInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperDataRxmtTimer.setDescription('The T25 Data Retransmission timer in\n                          milliseconds.  A value of 2147483647\n                          indicates no data retransmission timer in\n                          use.')
x25OperInterruptTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 11), PositiveInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperInterruptTimer.setDescription('The T26 Interrupt timer in milliseconds.  A\n                          value of 2147483647 indicates interrupts are\n                          not being used.')
x25OperRejectTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 12), PositiveInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperRejectTimer.setDescription('The T27 Reject retransmission timer in\n                          milliseconds.  A value of 2147483647\n                          indicates no reject timer in use.')
x25OperRegistrationRequestTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 13), PositiveInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperRegistrationRequestTimer.setDescription('The T28 registration timer in milliseconds.\n                          A value of 2147483647 indicates no\n                          registration timer in use.')
x25OperMinimumRecallTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 14), PositiveInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperMinimumRecallTimer.setDescription('Minimum time interval between unsuccessful\n                          call attempts in milliseconds.')
x25OperRestartCount = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 15), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperRestartCount.setDescription('The R20 restart retransmission count.')
x25OperResetCount = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 16), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperResetCount.setDescription('The r22 Reset retransmission count.')
x25OperClearCount = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 17), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperClearCount.setDescription('The r23 Clear retransmission count.')
x25OperDataRxmtCount = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 18), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperDataRxmtCount.setDescription('The R25 Data retransmission count.  This\n                          value is undefined if the\n                          x25OperDataRxmtTimer indicates no timer in\n                          use.')
x25OperRejectCount = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 19), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperRejectCount.setDescription('The R27 reject retransmission count.  This\n                          value is undefined if the x25OperRejectTimer\n                          indicates no timer in use.')
x25OperRegistrationRequestCount = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 20), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperRegistrationRequestCount.setDescription('The R28 Registration retransmission Count.\n                          This value is undefined if the\n                          x25OperREgistrationRequestTimer indicates no\n                          timer in use.')
x25OperNumberPVCs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 21), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,4096))).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperNumberPVCs.setDescription('The number of PVC configured for this PLE.\n                          The PVCs use channel numbers from 1 to this\n                          number.')
x25OperDefCallParamId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 22), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperDefCallParamId.setDescription('This identifies the instance of the\n                          x25CallParmIndex for the entry in the\n                          x25CallParmTable that contains the default\n                          call parameters for this PLE.')
x25OperLocalAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 23), X121Address()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperLocalAddress.setDescription('The local address for this PLE subnetwork.\n                          A zero length address maybe returned by PLEs\n                          that only support PVCs.')
x25OperDataLinkId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 24), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperDataLinkId.setDescription('This identifies the instance of the index\n                          object in the first table of the most device\n                          specific MIB for the interface used by this\n                          PLE.')
x25OperProtocolVersionSupported = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 25), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperProtocolVersionSupported.setDescription('Identifies the version of the X.25 protocol\n                          this interface supports.  Object identifiers\n                          for common versions are defined below in the\n                          x25ProtocolVersion subtree.')
x25StatTable = MibTable((1, 3, 6, 1, 2, 1, 10, 5, 3), )
if mibBuilder.loadTexts: x25StatTable.setDescription('Statistics information about this X.25\n                          PLE.')
x25StatEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 5, 3, 1), ).setIndexNames((0, "RFC1382-MIB", "x25StatIndex"))
if mibBuilder.loadTexts: x25StatEntry.setDescription('Entries of the x25StatTable.')
x25StatIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 1), IfIndexType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatIndex.setDescription('The ifIndex value for the X.25 interface.')
x25StatInCalls = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatInCalls.setDescription('The number of incoming calls received.')
x25StatInCallRefusals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatInCallRefusals.setDescription('The number of incoming calls refused.  This\n                          includes calls refused by the PLE and by\n                          higher layers.  This also includes calls\n                          cleared because of restricted fast select.')
x25StatInProviderInitiatedClears = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatInProviderInitiatedClears.setDescription('The number of clear requests with a cause\n                          code other than DTE initiated.')
x25StatInRemotelyInitiatedResets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatInRemotelyInitiatedResets.setDescription('The number of reset requests received with\n\n\n                          cause code DTE initiated.')
x25StatInProviderInitiatedResets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatInProviderInitiatedResets.setDescription('The number of reset requests received with\n                          cause code other than DTE initiated.')
x25StatInRestarts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatInRestarts.setDescription('The number of remotely initiated (including\n                          provider initiated) restarts experienced by\n                          the PLE excluding the restart associated\n                          with bringing up the PLE interface.  This\n                          only counts restarts received when the PLE\n                          already has an established connection with\n                          the remove PLE.')
x25StatInDataPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatInDataPackets.setDescription('The number of data packets received.')
x25StatInAccusedOfProtocolErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatInAccusedOfProtocolErrors.setDescription('The number of packets received containing a\n                          procedure error cause code.  These include\n                          clear, reset, restart, or diagnostic\n                          packets.')
x25StatInInterrupts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatInInterrupts.setDescription('The number of interrupt packets received by\n                          the PLE or over the PVC/VC.')
x25StatOutCallAttempts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatOutCallAttempts.setDescription('The number of calls attempted.')
x25StatOutCallFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatOutCallFailures.setDescription('The number of call attempts which failed.\n                          This includes calls that were cleared\n                          because of restrictive fast select.')
x25StatOutInterrupts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatOutInterrupts.setDescription('The number of interrupt packets send by the\n                          PLE or over the PVC/VC.')
x25StatOutDataPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatOutDataPackets.setDescription('The number of data packets sent by this\n                          PLE.')
x25StatOutgoingCircuits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 15), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatOutgoingCircuits.setDescription('The number of active outgoing circuits.\n                          This includes call requests sent but not yet\n                          confirmed.  This does not count PVCs.')
x25StatIncomingCircuits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 16), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatIncomingCircuits.setDescription('The number of active Incoming Circuits.\n                          This includes call indications received but\n                          not yet acknowledged.  This does not count\n                          PVCs.')
x25StatTwowayCircuits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 17), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatTwowayCircuits.setDescription('The number of active two-way Circuits.\n                          This includes call requests sent but not yet\n                          confirmed.  This does not count PVCs.')
x25StatRestartTimeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatRestartTimeouts.setDescription('The number of times the T20 restart timer\n                          expired.')
x25StatCallTimeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatCallTimeouts.setDescription('The number of times the T21 call timer\n                          expired.')
x25StatResetTimeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatResetTimeouts.setDescription('The number of times the T22 reset timer\n                          expired.')
x25StatClearTimeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 21), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatClearTimeouts.setDescription('The number of times the T23 clear timer\n                          expired.')
x25StatDataRxmtTimeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 22), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatDataRxmtTimeouts.setDescription('The number of times the T25 data timer\n                          expired.')
x25StatInterruptTimeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 23), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatInterruptTimeouts.setDescription('The number of times the T26 interrupt timer\n                          expired.')
x25StatRetryCountExceededs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 24), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatRetryCountExceededs.setDescription('The number of times a retry counter was\n                          exhausted.')
x25StatClearCountExceededs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 25), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatClearCountExceededs.setDescription('The number of times the R23 clear count was\n                          exceeded.')
x25ChannelTable = MibTable((1, 3, 6, 1, 2, 1, 10, 5, 4), )
if mibBuilder.loadTexts: x25ChannelTable.setDescription('These objects contain information about the\n                          channel number configuration in an X.25 PLE.\n                          These values are the configured values.\n                          changes in these values after the interfaces\n                          has started may not be reflected in the\n                          operating PLE.')
x25ChannelEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 5, 4, 1), ).setIndexNames((0, "RFC1382-MIB", "x25ChannelIndex"))
if mibBuilder.loadTexts: x25ChannelEntry.setDescription('Entries of x25ChannelTable.')
x25ChannelIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 4, 1, 1), IfIndexType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25ChannelIndex.setDescription('The ifIndex value for the X.25 Interface.')
x25ChannelLIC = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 4, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,4095))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25ChannelLIC.setDescription('Lowest Incoming channel.')
x25ChannelHIC = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 4, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,4095))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25ChannelHIC.setDescription('Highest Incoming channel.  A value of zero\n                          indicates no channels in this range.')
x25ChannelLTC = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 4, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,4095))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25ChannelLTC.setDescription('Lowest Two-way channel.')
x25ChannelHTC = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 4, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,4095))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25ChannelHTC.setDescription('Highest Two-way channel.  A value of zero\n                          indicates no channels in this range.')
x25ChannelLOC = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 4, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,4095))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25ChannelLOC.setDescription('Lowest outgoing channel.')
x25ChannelHOC = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 4, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,4095))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25ChannelHOC.setDescription('Highest outgoing channel.  A value of zero\n\n\n                          indicates no channels in this range.')
x25CircuitTable = MibTable((1, 3, 6, 1, 2, 1, 10, 5, 5), )
if mibBuilder.loadTexts: x25CircuitTable.setDescription('These objects contain general information\n                          about a specific circuit of an X.25 PLE.')
x25CircuitEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 5, 5, 1), ).setIndexNames((0, "RFC1382-MIB", "x25CircuitIndex"), (0, "RFC1382-MIB", "x25CircuitChannel"))
if mibBuilder.loadTexts: x25CircuitEntry.setDescription('Entries of x25CircuitTable.')
x25CircuitIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 1), IfIndexType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CircuitIndex.setDescription('The ifIndex value for the X.25 Interface.')
x25CircuitChannel = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,4095))).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CircuitChannel.setDescription('The channel number for this circuit.')
x25CircuitStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8, 9, 10,))).clone(namedValues=NamedValues(("invalid", 1), ("closed", 2), ("calling", 3), ("open", 4), ("clearing", 5), ("pvc", 6), ("pvcResetting", 7), ("startClear", 8), ("startPvcResetting", 9), ("other", 10),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CircuitStatus.setDescription("This object reports the current status of\n                          the circuit.\n\n                          An existing instance of this object can only\n                          be set to startClear, startPvcResetting, or\n                          invalid.  An instance with the value calling\n                          or open can only be set to startClear and\n                          that action will start clearing the circuit.\n                          An instance with the value PVC can only be\n                          set to startPvcResetting or invalid and that\n                          action resets the PVC or deletes the circuit\n                          respectively.  The values startClear or\n                          startPvcResetting will never be returned by\n                          an agent.  An attempt to set the status of\n                          an existing instance to a value other than\n                          one of these values will result in an error.\n\n                          A non-existing instance can be set to PVC to\n                          create a PVC if the implementation supports\n                          dynamic creation of PVCs.  Some\n                          implementations may only allow creation and\n                          deletion of PVCs if the interface is down.\n                          Since the instance identifier will supply\n                          the PLE index and the channel number,\n                          setting this object alone supplies\n                          sufficient information to create the\n                          instance.  All the DEFVAL clauses for the\n                          other objects of this table are appropriate\n                          for creating a PVC; PLEs creating entries\n                          for placed or accepted calls will use values\n                          appropriate for the call rather than the\n                          value of the DEFVAL clause.  Two managers\n                          trying to create the same PVC can determine\n                          from the return code which manager succeeded\n                          and which failed (the failing manager fails\n                          because it can not set a value of PVC for an\n                          existing object).\n\n\n                          An entry in the closed or invalid state may\n                          be deleted or reused at the agent's\n                          convence.  If the entry is kept in the\n                          closed state, the values of the parameters\n                          associated with the entry must be correct.\n                          Closed implies the values in the circuit\n                          table are correct.\n\n                          The value of invalid indicates the other\n                          values in the table are invalid.  Many\n                          agents may never return a value of invalid\n                          because they dynamically allocate and free\n                          unused table entries.  An agent for a\n                          statically configured systems can return\n                          invalid to indicate the entry has not yet\n                          been used so the counters contain no\n                          information.")
x25CircuitEstablishTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 4), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CircuitEstablishTime.setDescription('The value of sysUpTime when the channel was\n                          associated with this circuit.  For outgoing\n                          SVCs, this is the time the first call packet\n                          was sent.  For incoming SVCs, this is the\n                          time the call indication was received.  For\n                          PVCs this is the time the PVC was able to\n                          pass data to a higher layer entity without\n                          loss of data.')
x25CircuitDirection = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("incoming", 1), ("outgoing", 2), ("pvc", 3),)).clone('pvc')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CircuitDirection.setDescription('The direction of the call that established\n                          this circuit.')
x25CircuitInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CircuitInOctets.setDescription('The number of octets of user data delivered\n                          to upper layer.')
x25CircuitInPdus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CircuitInPdus.setDescription('The number of PDUs received for this\n                          circuit.')
x25CircuitInRemotelyInitiatedResets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CircuitInRemotelyInitiatedResets.setDescription('The number of Resets received for this\n                          circuit with cause code of DTE initiated.')
x25CircuitInProviderInitiatedResets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CircuitInProviderInitiatedResets.setDescription('The number of Resets received for this\n                          circuit with cause code other than DTE\n                          initiated.')
x25CircuitInInterrupts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CircuitInInterrupts.setDescription('The number of interrupt packets received\n                          for this circuit.')
x25CircuitOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CircuitOutOctets.setDescription('The number of octets of user data sent for\n                          this circuit.')
x25CircuitOutPdus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CircuitOutPdus.setDescription('The number of PDUs sent for this circuit.')
x25CircuitOutInterrupts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CircuitOutInterrupts.setDescription('The number of interrupt packets sent on\n                          this circuit.')
x25CircuitDataRetransmissionTimeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CircuitDataRetransmissionTimeouts.setDescription('The number of times the T25 data\n                          retransmission timer expired for this\n                          circuit.')
x25CircuitResetTimeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CircuitResetTimeouts.setDescription('The number of times the T22 reset timer\n                          expired for this circuit.')
x25CircuitInterruptTimeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CircuitInterruptTimeouts.setDescription('The number of times the T26 Interrupt timer\n                          expired for this circuit.')
x25CircuitCallParamId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 17), ObjectIdentifier()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CircuitCallParamId.setDescription('This identifies the instance of the\n                          x25CallParmIndex for the entry in the\n                          x25CallParmTable which contains the call\n                          parameters in use with this circuit.  The\n                          entry referenced must contain the values\n                          that are currently in use by the circuit\n                          rather than proposed values.  A value of\n                          NULL indicates the circuit is a PVC or is\n                          using all the default parameters.')
x25CircuitCalledDteAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 18), X121Address().clone(hexValue="")).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CircuitCalledDteAddress.setDescription('For incoming calls, this is the called\n                          address from the call indication packet.\n                          For outgoing calls, this is the called\n\n\n                          address from the call confirmation packet.\n                          This will be zero length for PVCs.')
x25CircuitCallingDteAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 19), X121Address().clone(hexValue="")).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CircuitCallingDteAddress.setDescription('For incoming calls, this is the calling\n                          address from the call indication packet.\n                          For outgoing calls, this is the calling\n                          address from the call confirmation packet.\n                          This will be zero length for PVCs.')
x25CircuitOriginallyCalledAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 20), X121Address().clone(hexValue="")).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CircuitOriginallyCalledAddress.setDescription('For incoming calls, this is the address in\n                          the call Redirection or Call Deflection\n                          Notification facility if the call was\n                          deflected or redirected, otherwise it will\n                          be called address from the call indication\n                          packet.  For outgoing calls, this is the\n                          address from the call request packet.  This\n                          will be zero length for PVCs.')
x25CircuitDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 21), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0,255)).clone(hexValue="")).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CircuitDescr.setDescription("A descriptive string associated with this\n                          circuit.  This provides a place for the\n                          agent to supply any descriptive information\n                          it knows about the use or owner of the\n                          circuit.  The agent may return the process\n                          identifier and user name for the process\n\n\n                          using the circuit.  Alternative the agent\n                          may return the name of the configuration\n                          entry that caused a bridge to establish the\n                          circuit.  A zero length value indicates the\n                          agent doesn't have any additional\n                          information.")
x25ClearedCircuitEntriesRequested = MibScalar((1, 3, 6, 1, 2, 1, 10, 5, 6), PositiveInteger()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25ClearedCircuitEntriesRequested.setDescription('The requested number of entries for the\n                          agent to keep in the x25ClearedCircuit\n                          table.')
x25ClearedCircuitEntriesGranted = MibScalar((1, 3, 6, 1, 2, 1, 10, 5, 7), PositiveInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25ClearedCircuitEntriesGranted.setDescription('The actual number of entries the agent will\n                          keep in the x25ClearedCircuit Table.')
x25ClearedCircuitTable = MibTable((1, 3, 6, 1, 2, 1, 10, 5, 8), )
if mibBuilder.loadTexts: x25ClearedCircuitTable.setDescription('A table of entries about closed circuits.\n                          Entries must be made in this table whenever\n                          circuits are closed and the close request or\n                          close indication packet contains a clearing\n                          cause other than DTE Originated or a\n                          Diagnostic code field other than Higher\n                          Layer Initiated disconnection-normal.  An\n                          agent may optionally make entries for normal\n                          closes (to record closing facilities or\n\n\n                          other information).\n\n                          Agents will delete the oldest entry in the\n                          table when adding a new entry would exceed\n                          agent resources.  Agents are required to\n                          keep the last entry put in the table and may\n                          keep more entries.  The object\n                          x25OperClearEntriesGranted returns the\n                          maximum number of entries kept in the\n                          table.')
x25ClearedCircuitEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 5, 8, 1), ).setIndexNames((0, "RFC1382-MIB", "x25ClearedCircuitIndex"))
if mibBuilder.loadTexts: x25ClearedCircuitEntry.setDescription('Information about a cleared circuit.')
x25ClearedCircuitIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 8, 1, 1), PositiveInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25ClearedCircuitIndex.setDescription('An index that uniquely distinguishes one\n                          entry in the clearedCircuitTable from\n                          another.  This index will start at\n                          2147483647 and will decrease by one for each\n                          new entry added to the table.  Upon reaching\n                          one, the index will reset to 2147483647.\n                          Because the index starts at 2147483647 and\n                          decreases, a manager may do a getnext on\n                          entry zero and obtain the most recent entry.\n                          When the index has the value of 1, the next\n                          entry will delete all entries in the table\n                          and that entry will be numbered 2147483647.')
x25ClearedCircuitPleIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 8, 1, 2), IfIndexType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25ClearedCircuitPleIndex.setDescription('The value of ifIndex for the PLE which\n                          cleared the circuit that created the entry.')
x25ClearedCircuitTimeEstablished = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 8, 1, 3), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25ClearedCircuitTimeEstablished.setDescription('The value of sysUpTime when the circuit was\n                          established.  This will be the same value\n                          that was in the x25CircuitEstablishTime for\n                          the circuit.')
x25ClearedCircuitTimeCleared = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 8, 1, 4), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25ClearedCircuitTimeCleared.setDescription('The value of sysUpTime when the circuit was\n                          cleared.  For locally initiated clears, this\n\n\n                          will be the time when the clear confirmation\n                          was received.  For remotely initiated\n                          clears, this will be the time when the clear\n                          indication was received.')
x25ClearedCircuitChannel = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 8, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,4095))).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25ClearedCircuitChannel.setDescription('The channel number for the circuit that was\n                          cleared.')
x25ClearedCircuitClearingCause = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 8, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25ClearedCircuitClearingCause.setDescription('The Clearing Cause from the clear request\n                          or clear indication packet that cleared the\n                          circuit.')
x25ClearedCircuitDiagnosticCode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 8, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25ClearedCircuitDiagnosticCode.setDescription('The Diagnostic Code from the clear request\n                          or clear indication packet that cleared the\n                          circuit.')
x25ClearedCircuitInPdus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 8, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25ClearedCircuitInPdus.setDescription('The number of PDUs received on the\n                          circuit.')
x25ClearedCircuitOutPdus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 8, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25ClearedCircuitOutPdus.setDescription('The number of PDUs transmitted on the\n                          circuit.')
x25ClearedCircuitCalledAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 8, 1, 10), X121Address()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25ClearedCircuitCalledAddress.setDescription('The called address from the cleared\n                          circuit.')
x25ClearedCircuitCallingAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 8, 1, 11), X121Address()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25ClearedCircuitCallingAddress.setDescription('The calling address from the cleared\n                          circuit.')
x25ClearedCircuitClearFacilities = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 8, 1, 12), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,109))).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25ClearedCircuitClearFacilities.setDescription('The facilities field from the clear request\n                          or clear indication packet that cleared the\n                          circuit.  A size of zero indicates no\n                          facilities were present.')
x25CallParmTable = MibTable((1, 3, 6, 1, 2, 1, 10, 5, 9), )
if mibBuilder.loadTexts: x25CallParmTable.setDescription('These objects contain the parameters that\n                          can be varied between X.25 calls.  The\n                          entries in this table are independent of the\n                          PLE.  There exists only one of these tables\n                          for the entire system.  The indexes for the\n                          entries are independent of any PLE or any\n                          circuit.  Other tables reference entries in\n                          this table.  Entries in this table can be\n                          used for default PLE parameters, for\n                          parameters to use to place/answer a call,\n                          for the parameters currently in use for a\n                          circuit, or parameters that were used by a\n                          circuit.\n\n                          The number of references to a given set of\n                          parameters can be found in the\n                          x25CallParmRefCount object sharing the same\n                          instance identifier with the parameters.\n                          The value of this reference count also\n                          affects the access of the objects in this\n                          table.  An object in this table with the\n                          same instance identifier as the instance\n                          identifier of an x25CallParmRefCount must be\n                          consider associated with that reference\n                          count.  An object with an associated\n                          reference count of zero can be written (if\n                          its ACCESS clause allows it).  An object\n                          with an associated reference count greater\n                          than zero can not be written (regardless of\n                          the ACCESS clause).  This ensures that a set\n                          of call parameters being referenced from\n                          another table can not be modified or changed\n                          in a ways inappropriate for continued use by\n                          that table.')
x25CallParmEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 5, 9, 1), ).setIndexNames((0, "RFC1382-MIB", "x25CallParmIndex"))
if mibBuilder.loadTexts: x25CallParmEntry.setDescription('Entries of x25CallParmTable.')
x25CallParmIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 1), PositiveInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CallParmIndex.setDescription('A value that distinguishes this entry from\n                          another entry.  Entries in this table are\n                          referenced from other objects which identify\n                          call parameters.\n\n                          It is impossible to know which other objects\n                          in the MIB reference entries in the table by\n                          looking at this table.  Because of this,\n                          changes to parameters must be accomplished\n                          by creating a new entry in this table and\n                          then changing the referencing table to\n                          identify the new entry.\n\n                          Note that an agent will only use the values\n                          in this table when another table is changed\n                          to reference those values.  The number of\n                          other tables that reference an index object\n                          in this table can be found in\n                          x25CallParmRefCount.  The value of the\n                          reference count will affect the writability\n                          of the objects as explained above.\n\n                          Entries in this table which have a reference\n                          count of zero maybe deleted at the convence\n                          of the agent.  Care should be taken by the\n                          agent to give the NMS sufficient time to\n                          create a reference to newly created entries.\n\n                          Should a Management Station not find a free\n                          index with which to create a new entry, it\n                          may feel free to delete entries with a\n\n\n                          reference count of zero.  However in doing\n                          so the Management Station much realize it\n                          may impact other Management Stations.')
x25CallParmStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 2), EntryStatus()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmStatus.setDescription('The status of this call parameter entry.\n                          See RFC 1271 for details of usage.')
x25CallParmRefCount = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 3), PositiveInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CallParmRefCount.setDescription('The number of references know by a\n                          management station to exist to this set of\n                          call parameters.  This is the number of\n                          other objects that have returned a value of,\n                          and will return a value of, the index for\n                          this set of call parameters.  Examples of\n                          such objects are the x25AdmnDefCallParamId,\n                          x25OperDataLinkId, or x25AdmnDefCallParamId\n                          objects defined above.')
x25CallParmInPacketSize = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,4096)).clone(128)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmInPacketSize.setDescription('The maximum receive packet size in octets\n                          for a circuit.  A size of zero for a circuit\n                          means use the PLE default size.  A size of\n                          zero for the PLE means use a default size of\n                          128.')
x25CallParmOutPacketSize = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,4096)).clone(128)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmOutPacketSize.setDescription('The maximum transmit packet size in octets\n                          for a circuit.  A size of zero for a circuit\n                          means use the PLE default size.  A size of\n                          zero for the PLE default means use a default\n                          size of 128.')
x25CallParmInWindowSize = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,127)).clone(2)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmInWindowSize.setDescription('The receive window size for a circuit.  A\n                          size of zero for a circuit means use the PLE\n                          default size.  A size of zero for the PLE\n                          default means use 2.')
x25CallParmOutWindowSize = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,127)).clone(2)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmOutWindowSize.setDescription('The transmit window size for a circuit.  A\n                          size of zero for a circuit means use the PLE\n                          default size.  A size of zero for the PLE\n                          default means use 2.')
x25CallParmAcceptReverseCharging = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 8), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))).clone(namedValues=NamedValues(("default", 1), ("accept", 2), ("refuse", 3), ("neverAccept", 4),)).clone('refuse')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmAcceptReverseCharging.setDescription('An enumeration defining if the PLE will\n                          accept or refuse charges.  A value of\n                          default for a circuit means use the PLE\n                          default value.  A value of neverAccept is\n                          only used for the PLE default and indicates\n                          the PLE will never accept reverse charging.\n                          A value of default for a PLE default means\n                          refuse.')
x25CallParmProposeReverseCharging = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 9), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("default", 1), ("reverse", 2), ("local", 3),)).clone('local')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmProposeReverseCharging.setDescription('An enumeration defining if the PLE should\n                          propose reverse or local charging.  The\n                          value of default for a circuit means use the\n                          PLE default.  The value of default for the\n                          PLE default means use local.')
x25CallParmFastSelect = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 10), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6,))).clone(namedValues=NamedValues(("default", 1), ("notSpecified", 2), ("fastSelect", 3), ("restrictedFastResponse", 4), ("noFastSelect", 5), ("noRestrictedFastResponse", 6),)).clone('noFastSelect')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmFastSelect.setDescription('Expresses preference for use of fast select\n                          facility.  The value of default for a\n                          circuit is the PLE default.  A value of\n\n\n                          default for the PLE means noFastSelect.  A\n                          value of noFastSelect or\n                          noRestrictedFastResponse indicates a circuit\n                          may not use fast select or restricted fast\n                          response.')
x25CallParmInThruPutClasSize = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 11), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,))).clone(namedValues=NamedValues(("tcReserved1", 1), ("tcReserved2", 2), ("tc75", 3), ("tc150", 4), ("tc300", 5), ("tc600", 6), ("tc1200", 7), ("tc2400", 8), ("tc4800", 9), ("tc9600", 10), ("tc19200", 11), ("tc48000", 12), ("tc64000", 13), ("tcReserved14", 14), ("tcReserved15", 15), ("tcReserved0", 16), ("tcNone", 17), ("tcDefault", 18),)).clone('tcNone')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmInThruPutClasSize.setDescription('The incoming throughput class to negotiate.\n                          A value of tcDefault for a circuit means use\n                          the PLE default.  A value of tcDefault for\n                          the PLE default means tcNone.  A value of\n                          tcNone means do not negotiate throughtput\n                          class.')
x25CallParmOutThruPutClasSize = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 12), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,))).clone(namedValues=NamedValues(("tcReserved1", 1), ("tcReserved2", 2), ("tc75", 3), ("tc150", 4), ("tc300", 5), ("tc600", 6), ("tc1200", 7), ("tc2400", 8), ("tc4800", 9), ("tc9600", 10), ("tc19200", 11), ("tc48000", 12), ("tc64000", 13), ("tcReserved14", 14), ("tcReserved15", 15), ("tcReserved0", 16), ("tcNone", 17), ("tcDefault", 18),)).clone('tcNone')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmOutThruPutClasSize.setDescription('The outgoing throughput class to negotiate.\n                          A value of tcDefault for a circuit means use\n                          the PLE default.  A value of tcDefault for\n                          the PLE default means use tcNone.  A value\n                          of tcNone means do not negotiate throughtput\n                          class.')
x25CallParmCug = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 13), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0,4)).clone(hexValue="")).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmCug.setDescription('The Closed User Group to specify.  This\n                          consists of two or four octets containing\n                          the characters 0 through 9.  A zero length\n                          string indicates no facility requested.  A\n                          string length of three containing the\n                          characters DEF for a circuit means use the\n                          PLE default, (the PLE default parameter may\n                          not reference an entry of DEF.)')
x25CallParmCugoa = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 14), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0,4)).clone(hexValue="")).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmCugoa.setDescription('The Closed User Group with Outgoing Access\n                          to specify.  This consists of two or four\n                          octets containing the characters 0 through\n                          9.  A string length of three containing the\n                          characters DEF for a circuit means use the\n                          PLE default (the PLE default parameters may\n                          not reference an entry of DEF).  A zero\n                          length string indicates no facility\n                          requested.')
x25CallParmBcug = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 15), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0,3)).clone(hexValue="")).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmBcug.setDescription('The Bilateral Closed User Group to specify.\n                          This consists of two octets containing the\n                          characters 0 through 9.  A string length of\n                          three containing the characters DEF for a\n                          circuit means use the PLE default (the PLE\n                          default parameter may not reference an entry\n                          of DEF).  A zero length string indicates no\n                          facility requested.')
x25CallParmNui = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 16), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,108)).clone(hexValue="")).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmNui.setDescription('The Network User Identifier facility.  This\n                          is binary value to be included immediately\n                          after the length field.  The PLE will supply\n                          the length octet.  A zero length string\n                          indicates no facility requested.  This value\n                          is ignored for the PLE default parameters\n                          entry.')
x25CallParmChargingInfo = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 17), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))).clone(namedValues=NamedValues(("default", 1), ("noFacility", 2), ("noChargingInfo", 3), ("chargingInfo", 4),)).clone('noFacility')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmChargingInfo.setDescription('The charging Information facility.  A value\n                          of default for a circuit means use the PLE\n                          default.  The value of default for the\n                          default PLE parameters means use noFacility.\n                          The value of noFacility means do not include\n                          a facility.')
x25CallParmRpoa = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 18), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0,108)).clone(hexValue="")).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmRpoa.setDescription('The RPOA facility.  The octet string\n                          contains n * 4 sequences of the characters\n                          0-9 to specify a facility with n entries.\n                          The octet string containing the 3 characters\n                          DEF for a circuit specifies use of the PLE\n                          default (the entry for the PLE default may\n                          not contain DEF).  A zero length string\n                          indicates no facility requested.')
x25CallParmTrnstDly = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 19), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65537)).clone(65536)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmTrnstDly.setDescription('The Transit Delay Selection and Indication\n                          value.  A value of 65536 indicates no\n                          facility requested.  A value of 65537 for a\n                          circuit means use the PLE default (the PLE\n\n\n                          default parameters entry may not use the\n                          value 65537).  The value 65535 may only be\n                          used to indicate the value in use by a\n                          circuit.')
x25CallParmCallingExt = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 20), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0,40)).clone(hexValue="")).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmCallingExt.setDescription('The Calling Extension facility.  This\n                          contains one of the following:\n\n                          A sequence of hex digits with the value to\n                          be put in the facility. These digits will be\n                          converted to binary by the agent and put in\n                          the facility.  These octets do not include\n                          the length octet.\n\n                          A value containing the three character DEF\n                          for a circuit means use the PLE default,\n                          (the entry for the PLE default parameters\n                          may not use the value DEF).\n\n                          A zero length string indicates no facility\n                          requested.')
x25CallParmCalledExt = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 21), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0,40)).clone(hexValue="")).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmCalledExt.setDescription('The Called Extension facility.  This\n                          contains one of the following:\n\n                          A sequence of hex digits with the value to\n                          be put in the facility.  These digits will be\n                          converted to binary by the agent and put in\n                          the facility.  These octets do not include\n\n\n                          the length octet.\n\n                          A value containing the three character DEF\n                          for a circuit means use the PLE default,\n                          (the entry for the PLE default parameters\n                          may not use the value DEF).\n\n                          A zero length string indicates no facility\n                          requested.')
x25CallParmInMinThuPutCls = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 22), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,17)).clone(17)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmInMinThuPutCls.setDescription('The minimum input throughput Class.  A\n                          value of 16 for a circuit means use the PLE\n                          default (the PLE parameters entry may not\n                          use this value).  A value of 17 indicates no\n                          facility requested.')
x25CallParmOutMinThuPutCls = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 23), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,17)).clone(17)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmOutMinThuPutCls.setDescription('The minimum output throughput Class.  A\n                          value of 16 for a circuit means use the PLE\n                          default (the PLE parameters entry may not\n                          use this value).  A value of 17 indicates no\n                          facility requested.')
x25CallParmEndTrnsDly = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 24), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,6)).clone(hexValue="")).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmEndTrnsDly.setDescription('The End-to-End Transit Delay to negotiate.\n                          An octet string of length 2, 4, or 6\n\n\n                          contains the facility encoded as specified\n                          in ISO/IEC 8208 section 15.3.2.4.  An octet\n                          string of length 3 containing the three\n                          character DEF for a circuit means use the\n                          PLE default (the entry for the PLE default\n                          can not contain the characters DEF).  A zero\n                          length string indicates no facility\n                          requested.')
x25CallParmPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 25), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,6)).clone(hexValue="")).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmPriority.setDescription('The priority facility to negotiate.  The\n                          octet string encoded as specified in ISO/IEC\n                          8208 section 15.3.2.5.  A zero length string\n                          indicates no facility requested.  The entry\n                          for the PLE default parameters must be zero\n                          length.')
x25CallParmProtection = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 26), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0,108)).clone(hexValue="")).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmProtection.setDescription('A string contains the following:\n                          A hex string containing the value for the\n                          protection facility.  This will be converted\n                          from hex to the octets actually in the\n                          packet by the agent.  The agent will supply\n                          the length field and the length octet is not\n                          contained in this string.\n\n                          An string containing the 3 characters DEF\n                          for a circuit means use the PLE default (the\n                          entry for the PLE default parameters may not\n                          use the value DEF).\n\n                          A zero length string mean no facility\n                          requested.')
x25CallParmExptData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 27), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("default", 1), ("noExpeditedData", 2), ("expeditedData", 3),)).clone('noExpeditedData')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmExptData.setDescription('The Expedited Data facility to negotiate.\n                          A value of default for a circuit means use\n                          the PLE default value.  The entry for the\n                          PLE default parameters may not have the\n                          value default.')
x25CallParmUserData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 28), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,128)).clone(hexValue="")).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmUserData.setDescription('The call user data as placed in the packet.\n                          A zero length string indicates no call user\n                          data.  If both the circuit call parameters\n                          and the PLE default have call user data\n                          defined, the data from the circuit call\n                          parameters will be used.  If only the PLE\n                          has data defined, the PLE entry will be\n                          used.  If neither the circuit call\n                          parameters or the PLE default entry has a\n                          value, no call user data will be sent.')
x25CallParmCallingNetworkFacilities = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 29), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,108)).clone(hexValue="")).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmCallingNetworkFacilities.setDescription('The calling network facilities.  The\n                          facilities are encoded here exactly as\n                          encoded in the call packet.  These\n\n\n                          facilities do not include the marker\n                          facility code.\n\n                          A zero length string in the entry for the\n                          parameter to use when establishing a circuit\n                          means use the PLE default.  A zero length\n                          string in the entry for PLE default\n                          parameters indicates no default facilities.')
x25CallParmCalledNetworkFacilities = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 30), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,108)).clone(hexValue="")).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmCalledNetworkFacilities.setDescription('The called network facilities.  The\n                          facilities are encoded here exactly as\n                          encoded in the call packet.  These\n                          facilities do not include the marker\n                          facility code.\n\n                          A zero length string in the entry for the\n                          parameter to use when establishing a circuit\n                          means use the PLE default.  A zero length\n                          string in the entry for PLE default\n                          parameters indicates no default facilities.')
x25Restart = NotificationType((1, 3, 6, 1, 2, 1, 10, 5) + (0,1)).setObjects(*(("RFC1382-MIB", "x25OperIndex"),))
if mibBuilder.loadTexts: x25Restart.setDescription('This trap means the X.25 PLE sent or\n                          received a restart packet.  The restart that\n                          brings up the link should not send a\n                          x25Restart trap so the interface should send\n                          a linkUp trap.  Sending this trap means the\n                          agent does not send a linkDown and linkUp\n                          trap.')
x25Reset = NotificationType((1, 3, 6, 1, 2, 1, 10, 5) + (0,2)).setObjects(*(("RFC1382-MIB", "x25CircuitIndex"), ("RFC1382-MIB", "x25CircuitChannel"),))
if mibBuilder.loadTexts: x25Reset.setDescription('If the PLE sends or receives a reset, the\n                          agent should send an x25Reset trap.')
x25ProtocolVersion = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 5, 10))
x25protocolCcittV1976 = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 5, 10, 1))
x25protocolCcittV1980 = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 5, 10, 2))
x25protocolCcittV1984 = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 5, 10, 3))
x25protocolCcittV1988 = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 5, 10, 4))
x25protocolIso8208V1987 = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 5, 10, 5))
x25protocolIso8208V1989 = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 5, 10, 6))
mibBuilder.exportSymbols("RFC1382-MIB", x25CallParmAcceptReverseCharging=x25CallParmAcceptReverseCharging, x25StatRetryCountExceededs=x25StatRetryCountExceededs, x25StatEntry=x25StatEntry, x25StatOutInterrupts=x25StatOutInterrupts, x25StatInCalls=x25StatInCalls, x25StatInRestarts=x25StatInRestarts, x25ClearedCircuitIndex=x25ClearedCircuitIndex, x25CallParmFastSelect=x25CallParmFastSelect, x25CircuitOutOctets=x25CircuitOutOctets, x25AdmnRestartCount=x25AdmnRestartCount, x25OperRejectTimer=x25OperRejectTimer, x25ChannelLIC=x25ChannelLIC, x25ChannelTable=x25ChannelTable, x25AdmnPacketSequencing=x25AdmnPacketSequencing, x25StatIndex=x25StatIndex, x25OperLocalAddress=x25OperLocalAddress, x25AdmnMinimumRecallTimer=x25AdmnMinimumRecallTimer, x25ChannelHTC=x25ChannelHTC, x25StatOutCallFailures=x25StatOutCallFailures, x25Reset=x25Reset, x25StatResetTimeouts=x25StatResetTimeouts, x25CircuitEstablishTime=x25CircuitEstablishTime, x25CallParmInPacketSize=x25CallParmInPacketSize, x25protocolCcittV1976=x25protocolCcittV1976, x25=x25, x25OperDataLinkId=x25OperDataLinkId, x25StatCallTimeouts=x25StatCallTimeouts, x25OperClearCount=x25OperClearCount, x25ClearedCircuitInPdus=x25ClearedCircuitInPdus, x25OperDataRxmtTimer=x25OperDataRxmtTimer, X121Address=X121Address, x25OperResetTimer=x25OperResetTimer, x25StatDataRxmtTimeouts=x25StatDataRxmtTimeouts, x25CallParmCallingExt=x25CallParmCallingExt, x25CallParmCalledNetworkFacilities=x25CallParmCalledNetworkFacilities, x25ClearedCircuitCallingAddress=x25ClearedCircuitCallingAddress, x25AdmnLocalAddress=x25AdmnLocalAddress, x25AdmnMaxActiveCircuits=x25AdmnMaxActiveCircuits, x25CallParmOutMinThuPutCls=x25CallParmOutMinThuPutCls, x25CircuitOutPdus=x25CircuitOutPdus, x25ProtocolVersion=x25ProtocolVersion, x25CircuitOutInterrupts=x25CircuitOutInterrupts, x25CircuitCallParamId=x25CircuitCallParamId, x25OperPacketSequencing=x25OperPacketSequencing, x25AdmnDefCallParamId=x25AdmnDefCallParamId, x25CallParmRefCount=x25CallParmRefCount, x25AdmnResetTimer=x25AdmnResetTimer, x25AdmnRegistrationRequestCount=x25AdmnRegistrationRequestCount, x25CircuitInOctets=x25CircuitInOctets, x25CallParmOutPacketSize=x25CallParmOutPacketSize, x25ClearedCircuitClearingCause=x25ClearedCircuitClearingCause, x25AdmnInterfaceMode=x25AdmnInterfaceMode, x25CircuitInPdus=x25CircuitInPdus, x25CallParmOutThruPutClasSize=x25CallParmOutThruPutClasSize, x25CallParmProtection=x25CallParmProtection, x25OperCallTimer=x25OperCallTimer, x25AdmnRejectCount=x25AdmnRejectCount, x25OperNumberPVCs=x25OperNumberPVCs, x25CircuitOriginallyCalledAddress=x25CircuitOriginallyCalledAddress, x25ClearedCircuitTimeEstablished=x25ClearedCircuitTimeEstablished, x25AdmnIndex=x25AdmnIndex, x25OperTable=x25OperTable, x25CallParmStatus=x25CallParmStatus, x25AdmnClearTimer=x25AdmnClearTimer, x25CallParmCalledExt=x25CallParmCalledExt, x25CallParmEntry=x25CallParmEntry, x25CircuitChannel=x25CircuitChannel, x25StatOutDataPackets=x25StatOutDataPackets, x25OperInterfaceMode=x25OperInterfaceMode, x25AdmnResetCount=x25AdmnResetCount, x25StatOutgoingCircuits=x25StatOutgoingCircuits, x25CircuitCalledDteAddress=x25CircuitCalledDteAddress, x25AdmnCallTimer=x25AdmnCallTimer, x25ChannelHOC=x25ChannelHOC, x25CallParmExptData=x25CallParmExptData, x25CallParmProposeReverseCharging=x25CallParmProposeReverseCharging, x25CircuitDescr=x25CircuitDescr, x25CallParmInMinThuPutCls=x25CallParmInMinThuPutCls, x25ClearedCircuitClearFacilities=x25ClearedCircuitClearFacilities, x25CallParmTrnstDly=x25CallParmTrnstDly, x25CallParmNui=x25CallParmNui, x25StatInProviderInitiatedResets=x25StatInProviderInitiatedResets, x25CallParmChargingInfo=x25CallParmChargingInfo, x25StatRestartTimeouts=x25StatRestartTimeouts, x25protocolCcittV1984=x25protocolCcittV1984, x25protocolIso8208V1987=x25protocolIso8208V1987, x25CircuitIndex=x25CircuitIndex, x25OperRestartTimer=x25OperRestartTimer, x25ClearedCircuitPleIndex=x25ClearedCircuitPleIndex, x25OperInterruptTimer=x25OperInterruptTimer, x25CallParmCug=x25CallParmCug, x25StatTwowayCircuits=x25StatTwowayCircuits, x25AdmnWindowTimer=x25AdmnWindowTimer, x25ClearedCircuitCalledAddress=x25ClearedCircuitCalledAddress, x25ClearedCircuitTimeCleared=x25ClearedCircuitTimeCleared, x25CallParmPriority=x25CallParmPriority, x25OperRegistrationRequestTimer=x25OperRegistrationRequestTimer, x25AdmnClearCount=x25AdmnClearCount, x25protocolCcittV1980=x25protocolCcittV1980, x25protocolCcittV1988=x25protocolCcittV1988, x25ClearedCircuitEntriesGranted=x25ClearedCircuitEntriesGranted, x25CallParmInWindowSize=x25CallParmInWindowSize, x25ChannelLOC=x25ChannelLOC, x25CircuitDataRetransmissionTimeouts=x25CircuitDataRetransmissionTimeouts, x25OperClearTimer=x25OperClearTimer, x25StatOutCallAttempts=x25StatOutCallAttempts, x25CallParmRpoa=x25CallParmRpoa, x25CallParmInThruPutClasSize=x25CallParmInThruPutClasSize, x25ClearedCircuitEntriesRequested=x25ClearedCircuitEntriesRequested, x25StatInterruptTimeouts=x25StatInterruptTimeouts, x25OperIndex=x25OperIndex, x25CallParmUserData=x25CallParmUserData, x25AdmnRejectTimer=x25AdmnRejectTimer, x25ClearedCircuitEntry=x25ClearedCircuitEntry, x25ClearedCircuitTable=x25ClearedCircuitTable, x25protocolIso8208V1989=x25protocolIso8208V1989, x25StatClearCountExceededs=x25StatClearCountExceededs, x25OperMaxActiveCircuits=x25OperMaxActiveCircuits, x25StatInCallRefusals=x25StatInCallRefusals, x25CircuitInRemotelyInitiatedResets=x25CircuitInRemotelyInitiatedResets, x25OperRestartCount=x25OperRestartCount, x25OperProtocolVersionSupported=x25OperProtocolVersionSupported, x25CallParmOutWindowSize=x25CallParmOutWindowSize, x25OperRejectCount=x25OperRejectCount, x25StatIncomingCircuits=x25StatIncomingCircuits, x25ClearedCircuitChannel=x25ClearedCircuitChannel, x25StatInAccusedOfProtocolErrors=x25StatInAccusedOfProtocolErrors, x25CircuitInterruptTimeouts=x25CircuitInterruptTimeouts, x25AdmnNumberPVCs=x25AdmnNumberPVCs, x25OperDefCallParamId=x25OperDefCallParamId, x25AdmnInterruptTimer=x25AdmnInterruptTimer, x25CircuitInProviderInitiatedResets=x25CircuitInProviderInitiatedResets, x25StatInRemotelyInitiatedResets=x25StatInRemotelyInitiatedResets, x25OperResetCount=x25OperResetCount, x25ChannelIndex=x25ChannelIndex, x25ChannelLTC=x25ChannelLTC, x25CallParmTable=x25CallParmTable, x25CallParmCugoa=x25CallParmCugoa, x25AdmnDataRxmtTimer=x25AdmnDataRxmtTimer, x25ChannelEntry=x25ChannelEntry, x25ChannelHIC=x25ChannelHIC, x25CircuitInInterrupts=x25CircuitInInterrupts, x25StatInProviderInitiatedClears=x25StatInProviderInitiatedClears, x25AdmnTable=x25AdmnTable, x25AdmnDataRxmtCount=x25AdmnDataRxmtCount, x25AdmnEntry=x25AdmnEntry, x25ClearedCircuitDiagnosticCode=x25ClearedCircuitDiagnosticCode, x25CircuitResetTimeouts=x25CircuitResetTimeouts, x25Restart=x25Restart, x25CallParmEndTrnsDly=x25CallParmEndTrnsDly, x25CallParmIndex=x25CallParmIndex, x25OperMinimumRecallTimer=x25OperMinimumRecallTimer, x25OperWindowTimer=x25OperWindowTimer, x25AdmnRestartTimer=x25AdmnRestartTimer, x25OperEntry=x25OperEntry, x25CircuitCallingDteAddress=x25CircuitCallingDteAddress, x25CircuitDirection=x25CircuitDirection, x25ClearedCircuitOutPdus=x25ClearedCircuitOutPdus, x25CallParmBcug=x25CallParmBcug, x25StatInInterrupts=x25StatInInterrupts, x25AdmnRegistrationRequestTimer=x25AdmnRegistrationRequestTimer, x25StatTable=x25StatTable, x25AdmnProtocolVersionSupported=x25AdmnProtocolVersionSupported, x25OperRegistrationRequestCount=x25OperRegistrationRequestCount, x25CallParmCallingNetworkFacilities=x25CallParmCallingNetworkFacilities, x25OperDataRxmtCount=x25OperDataRxmtCount, x25CircuitStatus=x25CircuitStatus, x25CircuitTable=x25CircuitTable, x25CircuitEntry=x25CircuitEntry, x25StatInDataPackets=x25StatInDataPackets, x25StatClearTimeouts=x25StatClearTimeouts)
