### 0.7.0 {small}`22 January, 2020`

```{warning}
Breaking changes introduced between `0.6.22.post1` and `0.7`:

- Elements of {class}`~anndata.AnnData`s don’t have their dimensionality reduced when the main object is subset.
  This is to maintain consistency when subsetting. See discussion in {issue}`145`.
- Internal modules like `anndata.core` are private and their contents are not stable: See {issue}`174`.
- The old deprecated attributes `.smp*`. `.add` and `.data` have been removed.
```

~~~{rubric} View overhaul {pr}`164`
~~~

- Indexing into a view no longer keeps a reference to intermediate view, see {issue}`62`.
- Views are now lazy. Elements of view of AnnData are not indexed until they’re accessed.
- Indexing with scalars no longer reduces dimensionality of contained arrays, see {issue}`145`.
- All elements of AnnData should now follow the same rules about how they’re subset, see {issue}`145`.
- Can now index by observations and variables at the same time.

~~~{rubric} IO overhaul {pr}`167`
~~~

- Reading and writing has been overhauled for simplification and speed.
- Time and memory usage can be half of previous in typical use cases
- Zarr backend now supports sparse arrays, and generally is closer to having the same features as HDF5.
- Backed mode should see significant speed and memory improvements for access along compressed dimensions and IO. PR {pr}`241`.
- {class}`~pandas.Categorical`s can now be ordered (PR {pr}`230`) and written to disk with a large number of categories (PR {pr}`217`).

~~~{rubric} Mapping attributes overhaul {smaller}`(obsm, varm, layers, ...)`
~~~

- New attributes {attr}`~anndata.AnnData.obsp` and {attr}`~anndata.AnnData.varp` have been added for two dimensional arrays where each axis corresponds to a single axis of the AnnData object. PR {pr}`207`.
- These are intended to store values like cell-by-cell graphs, which are currently stored in {attr}`~anndata.AnnData.uns`.
- Sparse arrays are now allowed as values in all mapping attributes.
- DataFrames are now allowed as values in {attr}`~anndata.AnnData.obsm` and {attr}`~anndata.AnnData.varm`.
- All mapping attributes now share an implementation and will have the same behaviour. PR {pr}`164`.

```{rubric} Miscellaneous improvements
```

- Mapping attributes now have ipython tab completion (e.g. `adata.obsm["\\t` can provide suggestions) PR {pr}`183`.
- {class}`~anndata.AnnData` attributes are now delete-able (e.g. `del adata.raw`) PR {pr}`242`.
- Many many bug fixes
