## 0.9.0
 This is a feature release
* [TK-443](https://tickets.puppetlabs.com/browse/TK-443) Adds `:enable-url-metrics?` and `setEnableURLMetrics` to the clojure and java APIs respectively. This allows disabling autogenerated url based metrics.
* [PE-19979](https://tickets.puppetlabs.com/browse/PE-19979) & [SERVER-1733](https://tickets.puppetlabs.com/browse/SERVER-1733) Update dependencies via clj-parent (i18n dependency specifically).

## 0.8.0
 This is a feature release
* [PDB-2640](https://tickets.puppetlabs.com/browse/PDB-2640) Added a
  `:compress-request-body` request option which allows for the request
  body content to be gzip-compressed before forwarding it on to the server

## 0.7.0
 This is a feature release
 
* [SERVER-1556](https://tickets.puppetlabs.com/browse/SERVER-1556) Add
  puppetlabs/clj-i18n support to clj-http-client.
* Pass the global i18n locale binding in the "accept-language" header of Clojure
  client requests.

## 0.6.0
 This is a feature and maintenance release

* [TK-179](https://tickets.puppetlabs.com/browse/TK-179) Refactor to eliminate Clojure/Java duplication
* [TK-316](https://tickets.puppetlabs.com/browse/TK-316) Add support for metrics
* [TK-317](https://tickets.puppetlabs.com/browse/TK-317) Add ability to pass a metrics-id
* [TK-354](https://tickets.puppetlabs.com/browse/TK-354) Add [documentation on metrics](./doc/metrics.md)
* [TK-308](https://tickets.puppetlabs.com/browse/TK-308) Bump Apache HttpAsyncClient library to 4.1.2
* [TK-402](https://tickets.puppetlabs.com/browse/TK-402) Allow metric namespace to be configurable
* Bump Trapperkeeper and Kitchensink dependencies from 1.1.1 to 1.5.1 (TK) and
  1.2.0 to 1.3.0 (KS).

## 0.5.0
 This is a feature release.

* [TK-312](https://tickets.puppetlabs.com/browse/TK-312) Unbuffered streams in Java to match clojure support released in 0.4.5.
* Add request function to clojure client protocol.


## 0.4.6
 This is a maintenance release.

* [TK-303](https://tickets.puppetlabs.com/browse/TK-303) - update dependencies to use Apache httpasyncclient v4.1.1.

## 0.4.5
 This is a feature release, and probably should have been 0.5.0 in
 order to comply with semantic versioning.

* Add support for streaming responses in the Clojure API - (ca5ad63) Scott Walker <scott.walker@puppetlabs.com>

## 0.4.4
 This is a maintenance release.

 * [TK-196](https://tickets.puppetlabs.com/browse/TK-196) - update prismatic
   dependencies to the latest versions.

## 0.4.3
 This is a feature release.

 * [TK-134](https://tickets.puppetlabs.com/browse/TK-134) - Introduced two new
   optional client configuration settings:
   - `connect-timeout-milliseconds`: maximum number of milliseconds that the
      client will wait for a connection to be established.
   - `socket-timeout-milliseconds`: maximum number of milliseconds that the
      client will allow for no data to be available on the socket before
      closing the underlying connection, 'SO_TIMEOUT' in socket terms.

## 0.4.2
 This is a bugfix release.
 
 * [TK-145](https://tickets.puppetlabs.com/browse/TK-145) - Fixed a bug which
   caused some HTTP requests to incorrectly have `charset=UTF-8` added to their
   `Content-Type` headers.
   

## 0.4.1
 This is a maintenance release.

 * Add documentation for making requests using the Java and Clojure clients.
 * Upgrade jvm-ssl-utils (previously known as jvm-certificate-authority)
   dependency to 0.7.0.
 * Upgrade clj-kitchensink dependency to 1.0.0.
 * Upgrade trapperkeeper dependency to 1.0.1.

## 0.4.0
 This is a feature release which has some breaking changes.

 * Support for non-client bound asynchronous requests has been removed from both
   the Clojure and Java-layer APIs.  This includes all of the request functions
   that previously existed in the `client.async` Clojure namespace and the
   request methods in the `AsyncHttpClient` Java class.
 * Add a Java-layer API for getting an instance of an HttpClient on which
   multiple requests -- e.g.., GET, POST -- can be made.  Clients are created
   via the `createClient` method on the new `Async` and `Sync` classes, for
   a client that can make asynchronous or synchronous web requests, respectively.
 * Non-client bound synchronous requests can still be performed through the Java
   API but must now be done through the `Sync` classes rather than the
   `SyncHttpClient` class.  The `SyncHttpClient` class is now used as the type
   of the instance that the `Sync.createClient()` method returns.
 * The Java `RequestOptions` class was refactored into new `ClientOptions` and
   `RequestOptions` classes which can be used with the client-bound `Async`
   and `Sync` APIs.  For non-client bound requests, options are now defined
   via a `SimpleRequestOptions` class.
 * Reworked connection close behavior to more robustly handle successful and
   failed connections.

## 0.3.1
 This is a bugfix release.

 * Fix a memory leak that occurred as a result of connection failures.

## 0.3.0
 This is a feature release.

 * Add configuration settings for SSL Protocols and Cipher Suites to both the
   Java and Clojure clients.

## 0.2.8
 This is a bugfix release.

 * Fix a bug in the Java client API that caused a file descriptor leak each time
   a client was created for a new request.

## 0.2.7
 This is a bugfix release.

 * Fix a bug where the character encoding was always being set to ISO-8859-1 w/o
   a charset ever being explicitly specified in the Content-Type header.  We now
   honor the existing charset if there is one in the header, and otherwise we
   use UTF-8 and explicitly add the charset to the header.

## 0.2.6
 * Add :follow-redirects and :force-redirects options to the clojure client.
 * Add followRedirects and forceRedirects options to the Java client.

## 0.2.5
 * Add an overloaded constructor for `RequestOptions` that accepts a String uri

## 0.2.4
 * Fix a bug in the Java client API that caused an NPE if a Content-Type header
   did not specify a charset

## 0.2.3
 * No changes

## 0.2.2
 * Add back in support for query-params map in Clojure API

## 0.2.1
 * Upgrade to Apache HttpAsyncClient v4.0.2 (fixes a bug where headers don't get
   included when following redirects).

## 0.2.0
 * Port the code to use the Apache HttpAsyncClient library instead of
   http-kit.
 * The API around creating a persistent client has changed and
   persistent clients are explicitly managed
 * The available request options have changed. Some convenience options
   have been removed.

## 0.1.7
 * Explicitly target JDK6 when building release jars

## 0.1.6
 * Add support for configuring client SSL context with a CA cert without a
   client cert/key

## 0.1.5
 * Update to latest version of puppetlabs/kitchensink
 * Use puppetlabs/certificate-authority for SSL tasks

## 0.1.4
 * Fix bug in sync.clj when excluding clojure.core/get
 
## 0.1.3
 * Added a Java API for the synchronous client

