/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.io;

import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UTFDataFormatException;

public class BlockDataInputStream
extends FilterInputStream
implements DataInput {
    private byte[] byteBuff = new byte[4];
    private byte[] readBuffer = new byte[8];
    private char[] lineBuffer;

    public BlockDataInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public int read(byte[] byArray) throws IOException {
        return this.in.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.in.read(byArray, n, n2);
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < n2; i += n3) {
            n3 = this.in.read(byArray, n + i, n2 - i);
            if (n3 >= 0) continue;
            throw new EOFException();
        }
    }

    public int skipBytes(int n) throws IOException {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < n && (n3 = (int)this.in.skip(n - n2)) > 0; n2 += n3) {
        }
        return n2;
    }

    public boolean readBoolean() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public byte readByte() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public int readUnsignedByte() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public short readShort() throws IOException {
        this.readFully(this.byteBuff, 0, 2);
        byte by = this.byteBuff[0];
        int n = this.byteBuff[1] & 0xFF;
        return (short)((by << 8) + (n << 0));
    }

    public int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.in.read();
        if ((n2 | (n = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + (n << 0);
    }

    public char readChar() throws IOException {
        int n;
        int n2 = this.in.read();
        if ((n2 | (n = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + (n << 0));
    }

    public int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.in.read();
        if ((n4 | (n3 = this.in.read()) | (n2 = this.in.read()) | (n = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
    }

    public void readInts(int[] nArray, int n) throws IOException {
        int n2 = n * 4;
        if (this.byteBuff.length < n2) {
            this.byteBuff = new byte[n2];
        }
        this.readFully(this.byteBuff, 0, n2);
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            byte by = this.byteBuff[n3++];
            int n4 = this.byteBuff[n3++] & 0xFF;
            int n5 = this.byteBuff[n3++] & 0xFF;
            int n6 = this.byteBuff[n3++] & 0xFF;
            nArray[i] = (by << 24) + (n4 << 16) + (n5 << 8) + (n6 << 0);
        }
    }

    public long readLong() throws IOException {
        this.readFully(this.readBuffer, 0, 8);
        return ((long)this.readBuffer[0] << 56) + ((long)(this.readBuffer[1] & 0xFF) << 48) + ((long)(this.readBuffer[2] & 0xFF) << 40) + ((long)(this.readBuffer[3] & 0xFF) << 32) + ((long)(this.readBuffer[4] & 0xFF) << 24) + (long)((this.readBuffer[5] & 0xFF) << 16) + (long)((this.readBuffer[6] & 0xFF) << 8) + (long)((this.readBuffer[7] & 0xFF) << 0);
    }

    public float readFloat() throws IOException {
        this.readFully(this.byteBuff, 0, 4);
        byte by = this.byteBuff[0];
        int n = this.byteBuff[1] & 0xFF;
        int n2 = this.byteBuff[2] & 0xFF;
        int n3 = this.byteBuff[3] & 0xFF;
        return Float.intBitsToFloat((by << 24) + (n << 16) + (n2 << 8) + (n3 << 0));
    }

    public void readFloats(float[] fArray, int n) throws IOException {
        int n2 = n * 4;
        if (this.byteBuff.length < n2) {
            this.byteBuff = new byte[n2];
        }
        this.readFully(this.byteBuff, 0, n2);
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            byte by = this.byteBuff[n3++];
            int n4 = this.byteBuff[n3++] & 0xFF;
            int n5 = this.byteBuff[n3++] & 0xFF;
            int n6 = this.byteBuff[n3++] & 0xFF;
            fArray[i] = Float.intBitsToFloat((by << 24) + (n4 << 16) + (n5 << 8) + (n6 << 0));
        }
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readLine() throws IOException {
        int n;
        char[] cArray = this.lineBuffer;
        if (cArray == null) {
            cArray = this.lineBuffer = new char[128];
        }
        int n2 = cArray.length;
        int n3 = 0;
        block4: while (true) {
            n = this.in.read();
            switch (n) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int n4 = this.in.read();
                    if (n4 == 10 || n4 == -1) break block4;
                    if (!(this.in instanceof PushbackInputStream)) {
                        this.in = new PushbackInputStream(this.in);
                    }
                    ((PushbackInputStream)this.in).unread(n4);
                    break block4;
                }
                default: {
                    if (--n2 < 0) {
                        cArray = new char[n3 + 128];
                        n2 = cArray.length - n3 - 1;
                        System.arraycopy(this.lineBuffer, 0, cArray, 0, n3);
                        this.lineBuffer = cArray;
                    }
                    cArray[n3++] = (char)n;
                    continue block4;
                }
            }
            break;
        }
        if (n == -1 && n3 == 0) {
            return null;
        }
        return String.copyValueOf(cArray, 0, n3);
    }

    public String readUTF() throws IOException {
        return BlockDataInputStream.readUTF(this);
    }

    public static String readUTF(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedShort();
        StringBuffer stringBuffer = new StringBuffer(n);
        byte[] byArray = new byte[n];
        int n2 = 0;
        dataInput.readFully(byArray, 0, n);
        block5: while (n2 < n) {
            int n3 = byArray[n2] & 0xFF;
            switch (n3 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n2;
                    stringBuffer.append((char)n3);
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((n2 += 2) > n) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n2 - 1];
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuffer.append((char)((n3 & 0x1F) << 6 | by & 0x3F));
                    continue block5;
                }
                case 14: {
                    if ((n2 += 3) > n) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n2 - 2];
                    byte by2 = byArray[n2 - 1];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuffer.append((char)((n3 & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0));
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(stringBuffer);
    }
}

