/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.design;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTSynchronizedStatement;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.NameOccurrence;

public class UnsynchronizedStaticDateFormatter
extends AbstractRule {
    private static Set<String> targets = new HashSet<String>();

    public Object visit(ASTFieldDeclaration node, Object data) {
        if (!node.isStatic()) {
            return data;
        }
        ASTClassOrInterfaceType cit = node.getFirstChildOfType(ASTClassOrInterfaceType.class);
        if (cit == null || !targets.contains(cit.getImage())) {
            return data;
        }
        ASTVariableDeclaratorId var = node.getFirstChildOfType(ASTVariableDeclaratorId.class);
        for (NameOccurrence occ : var.getUsages()) {
            ASTMethodDeclaration method;
            SimpleNode n = occ.getLocation();
            if (n.getFirstParentOfType(ASTSynchronizedStatement.class) != null || (method = n.getFirstParentOfType(ASTMethodDeclaration.class)) == null || method.isSynchronized()) continue;
            this.addViolation(data, n);
        }
        return data;
    }

    static {
        targets.add("DateFormat");
        targets.add("SimpleDateFormat");
        targets.add("java.text.DateFormat");
        targets.add("java.text.SimpleDateFormat");
    }
}

