/*
 * <copyright>
 *
 * Copyright (c) 1997
 * Institute for Information Processing and Computer Supported New Media (IICM),
 * Graz University of Technology, Austria.
 *
 * This file is part of the VRwave Java-EAI implementation.
 *
 * </copyright>
 */
/*
 * created: kwagen, 19970801
 *
 * changed: kwagen, 19970916
 *
 * $Id: EventInSFVec2f.java,v 1.1 1997/09/17 11:52:53 kwagen Exp $
 */

package vrml.external.field;

import iicm.vrml.pw.SFVec2f;

public class EventInSFVec2f extends EventIn
{
  public void setValue (float[] value) throws IllegalArgumentException
  {
    if (!scene_.getBehavior ())
      return;

    if (value == null || value.length != 2)
      throw new IllegalArgumentException ();

    ((SFVec2f) eventin_).setValue (value[0], value[1]);

    sendEvent ();

    scene_.redraw ();
  }
}
