/*
 * DLGColourChoose - colour chooser dialog
 *
 * created: apesen, 19961101
 *
 * changed: apesen, 19961126
 * changed: mpichler, 19970117
 *
 * $Id: DLGColourChoose.java,v 1.5 1997/03/25 14:48:13 mpichler Exp $
 */


package iicm.widgets;

import java.awt.*;


/* DLGColourChoose */

public class DLGColourChoose extends Frame
{
  static final int GAP = 10;
  static final int AI_AVRed   = 0;
  static final int AI_AVGreen = 1;
  static final int AI_AVBlue  = 2;
  static final int AI_AVHue   = 3;
  static final int AI_AVSat   = 4;
  static final int AI_AVBri   = 5;

  AdjValueBlock adjvalB1;
  AdjValueBlock adjvalB2;
  AdjustableValue[] adv = new AdjustableValue[6];
  ColField visOld;
  ColField visNew;
  ColField oldSel = null;
  Panel leftpanel = new Panel();
  ColField[] FarbTabelle = new ColField[ColourMap.coltable.length];
  Color[] oldcols;
  Color[] newcols;
  int numcolors;
  int actindex;
  List target;
  private ApplyColour callback;

  /**
   * constructor.
   * current colours should be set with setColours afterwards
   */

  public DLGColourChoose (String[] colnames, ApplyColour cbk)
  {
    super (WiTranslator.L_CCh_DName);
    numcolors = colnames.length;
    oldcols = new Color[numcolors];
    newcols = new Color[numcolors];
    callback = cbk;

    Panel framepanel = new Panel();
    framepanel.setLayout(new BorderLayout(GAP,GAP));

    adjvalB1 = new AdjValueBlock();
    adjvalB2 = new AdjValueBlock();

    adv[AI_AVRed  ] = adjvalB1.add(0.0, 255.0, 0.0, 0,WiTranslator.L_CCh_AVRed);
    adv[AI_AVGreen] = adjvalB1.add(0.0, 255.0, 0.0, 0,WiTranslator.L_CCh_AVGreen);
    adv[AI_AVBlue ] = adjvalB1.add(0.0, 255.0, 0.0, 0,WiTranslator.L_CCh_AVBlue);
    adv[AI_AVHue  ] = adjvalB2.add(0.0, 360.0, 0.0, 0,WiTranslator.L_CCh_AVHue);
    adv[AI_AVSat  ] = adjvalB2.add(0.0, 100.0, 0.0, 0,WiTranslator.L_CCh_AVSat);
    adv[AI_AVBri  ] = adjvalB2.add(0.0, 100.0, 0.0, 0,WiTranslator.L_CCh_AVBri);

    Panel ButtonLine = new Panel();
    ButtonLine.setLayout(new FlowLayout(FlowLayout.CENTER,GAP,GAP));
    ButtonLine.setFont (Fontify.fntButton);

    ButtonLine.add(new Button(WiTranslator.L_CCh_BOK));
    ButtonLine.add(new Button(WiTranslator.L_CCh_BApply));
    ButtonLine.add(new Button(WiTranslator.L_CCh_BCancel));

    Panel workpanel = new Panel();
    workpanel.setLayout(new GridLayout(1,2,GAP,GAP));                 // Arbeitsflaeche

    Panel rightpanel = new Panel();
    rightpanel.setLayout(new GridLayout(2,1,GAP,GAP));                // rechte Haelfte
    leftpanel.setLayout(new GridLayout(0,8,1,1));                     // linke Haelfte
    for (int i = 0;  i < ColourMap.coltable.length;  i++)
    {
      ColField field = new ColField (
        new Color (ColourMap.coltable[i]), 10, 5
      );
      FarbTabelle[i] = field;
      leftpanel.add (field);
    }

    Panel upripanel = new Panel();
    upripanel.setLayout(new BorderLayout(GAP,GAP));                   // oberes rechtes viertel

    Panel loripanel = new Panel();
    loripanel.setLayout(new GridLayout(2,1,GAP,GAP));                 // unteres rechtes viertel

    Panel urspanel = new Panel();
    urspanel.setLayout(new FlowLayout(FlowLayout.CENTER,GAP,GAP));    // old/newcolour
    visOld = new ColField (new Color (0, 0, 0), 80, 30);
    visNew = new ColField (new Color (0, 0, 0), 80, 30);
    urspanel.add(new Label(WiTranslator.L_CCh_LOld));
    urspanel.add(new FramedArea(visOld));
    urspanel.add(new Label(WiTranslator.L_CCh_LNew));
    urspanel.add(new FramedArea(visNew));
    urspanel.setFont (Fontify.fntLabel1);

    loripanel.add(adjvalB1);      // RGB
    loripanel.add(adjvalB2);      // HLS

    target = new List(4, false);  // 4 visible rows, no multi-selection
    for (int j = 0;  j < numcolors;  j++)
    {
       target.addItem(colnames[j]);
    }
    target.setFont (Fontify.fntList1);
    upripanel.add("Center",target);
    upripanel.add("South",urspanel);

    rightpanel.add(upripanel);
    rightpanel.add(loripanel);

    workpanel.add(new FramedArea(leftpanel));
    workpanel.add(rightpanel);

    framepanel.add("Center", workpanel);
    framepanel.add("South", ButtonLine);

    add("Center",framepanel);
    pack();
  } // DLGColourChoose 

  /**
   * set current colours and active index
   */

  public void setColours (int[] col, int index)
  {
    // Color objects unchangeable, so we may share references
    for (int j = 0;  j < numcolors;  j++)
      oldcols[j] = newcols[j] = new Color (col [j]);

    actindex = index;
    visOld.setCol(oldcols[actindex]);
    visNew.setCol(oldcols[actindex]);
    target.select(actindex);
  }

  /**
   * restore old colors
   */

  private void restoreColours ()
  {
    visNew.setCol(oldcols[actindex]);
    for (int j = 0;  j < numcolors;  j++)  // just copy references here
      newcols[j] = oldcols[j];
    // colors should be set again with setColours when dialog is to be reused
  }

  /**
   * get current colors
   */

  public void getColours (int[] col)
  {
    newcols[actindex] = visNew.getCol ();
    for (int j = 0;  j < numcolors;  j++)
      col[j] = newcols[j].getRGB ();
  }

  // *** event handling ***

  public boolean action(Event ev,Object arg)
  {
    if (((String) arg).equals(WiTranslator.L_CCh_BOK))
    {
      // System.out.println("HitBut OK");
      dispose();
      if (callback != null)
        callback.applyColour (this);
    }
    if (((String) arg).equals(WiTranslator.L_CCh_BApply))
    {
      // System.out.println("HitBut Reset");
      if (callback != null)
        callback.applyColour (this);
    }
    if (((String) arg).equals(WiTranslator.L_CCh_BCancel))
    {
      // System.out.println("HitBut Cancel");
      dispose();
      restoreColours ();  // restore original colors
      if (callback != null)
        callback.applyColour (this);
      return false;
    }
    return true; 
  }

  public boolean lostFocus( Event ev, Object what )
  {
    if ((ev.target == adv[AI_AVRed  ].scrlbar) || (ev.target == adv[AI_AVHue].scrlbar) ||
        (ev.target == adv[AI_AVGreen].scrlbar) || (ev.target == adv[AI_AVSat].scrlbar) ||
        (ev.target == adv[AI_AVBlue ].scrlbar) || (ev.target == adv[AI_AVBri].scrlbar))
    {
      ColField next = visNew.minDistance(FarbTabelle);
      if (oldSel != null)
        oldSel.deselect();
      if (visNew.distance2(next) == 0)
        next.select();
      else
        next.select(ColField.NEXT_TO);
      oldSel = next;
      // System.out.println("Distance=" + (int) Math.sqrt((double) visNew.distance(next)));
    }
    return super.lostFocus (ev, what);
  }

  public boolean handleEvent (Event ev)
  {
    if ((ev.target == adv[AI_AVRed  ].textfld) || (ev.target == adv[AI_AVRed  ].scrlbar) ||
        (ev.target == adv[AI_AVGreen].textfld) || (ev.target == adv[AI_AVGreen].scrlbar) ||
        (ev.target == adv[AI_AVBlue ].textfld) || (ev.target == adv[AI_AVBlue ].scrlbar))
    {
      setHSB();
      visNew.setCol(new Color((int) adv[AI_AVRed].getValue(), (int) adv[AI_AVGreen].getValue(),
                              (int) adv[AI_AVBlue].getValue()));
    }
    else if ((ev.target == adv[AI_AVHue].textfld) || (ev.target == adv[AI_AVHue].scrlbar) ||
             (ev.target == adv[AI_AVSat].textfld) || (ev.target == adv[AI_AVSat].scrlbar) ||
             (ev.target == adv[AI_AVBri].textfld) || (ev.target == adv[AI_AVBri].scrlbar))
    {
      setRGB();
      visNew.setCol(new Color((int) adv[AI_AVRed].getValue(), (int) adv[AI_AVGreen].getValue(),
                              (int) adv[AI_AVBlue].getValue()));
    }
    else if (ev.target instanceof ColField)
    {
      if (ev.id == Event.MOUSE_DOWN)
      {
        ColField cf = (ColField) ev.target;
        if (oldSel != null)
          oldSel.deselect();
        cf.select();
        oldSel = cf;
        Color col = cf.getCol ();
        adv[AI_AVRed  ].setText(col.getRed());
        adv[AI_AVGreen].setText(col.getGreen());
        adv[AI_AVBlue ].setText(col.getBlue());
        setHSB();
        visNew.setCol(new Color((int) adv[AI_AVRed].getValue(), (int) adv[AI_AVGreen].getValue(),
                                (int) adv[AI_AVBlue].getValue()));
      }
    }
    else if (ev.target == target)
    {
      switch(ev.id)
      {
        case Event.LIST_SELECT:
          newcols[actindex] = visNew.getCol ();
          actindex = target.getSelectedIndex();
          visNew.setCol(newcols[actindex]);
          visOld.setCol(oldcols[actindex]);
          // System.out.println("List selected:");
        break;
        case Event.LIST_DESELECT:
          // System.out.println("List deselected:");
          target.select(actindex);  // inhibit deselection
        break;
      }
      // System.out.println("List:"+ev);
    }
    return super.handleEvent (ev);
  } // handleEvent

  private void setHSB()
  {
    float[] HSB = new float[3];
    Color.RGBtoHSB((int) adv[AI_AVRed].getValue(), (int) adv[AI_AVGreen].getValue(),
                   (int) adv[AI_AVBlue].getValue(), HSB);
    adv[AI_AVHue].setText(HSB[0]*360);
    adv[AI_AVSat].setText(HSB[1]*100);
    adv[AI_AVBri].setText(HSB[2]*100);
  }

  private void setRGB()
  {
    int RGB = Color.HSBtoRGB((float) adv[AI_AVHue].getValue()/360, (float) adv[AI_AVSat].getValue()/100,
                             (float) adv[AI_AVBri].getValue()/100);
    adv[AI_AVRed  ].setText ((RGB & 0xFF0000) >> 16);
    adv[AI_AVGreen].setText ((RGB & 0x00FF00) >>  8);
    adv[AI_AVBlue ].setText  (RGB & 0x0000FF);
  }
} // DLGColourChoose
