/*
 * SampleTraverser.java
 * Copyright (c) 1997 IICM
 *
 * created: mpichler, 19970114
 * changed: mpichler, 19970401
 *
 * $Id: SampleTraverser.java,v 1.5 1997/05/22 16:25:30 apesen Exp $
 */


package iicm.vrml.pwsample;

import iicm.vrml.pw.*;


/**
 * SampleTraverser - sample traversal.
 * Just prints out node names it encounters.
 * Copyright (c) 1997 IICM
 *
 * @author Michael Pichler
 * @version 0.9, latest change: 14 Jan 97
 */


class SampleTraverser extends Traverser
{
  String sep_ = "  ";  // do I hate TABs?
  private int level_ = 0;
  private String indent_ = "";

  /**
   * traverse the scene graph
   */

  public void traverse (GroupNode root)
  {
    Node.traverseNode (this, root);
    // or: tGroupNode (root);
  }

  /**
   * increase indentation on each group level
   */

  public void tGroupNode (GroupNode group)
  {
    String name = group.nodeName ();
    String oldindent = indent_;
    // you may wisth to handle the (artificial) scene root (GroupNode)
    // differently, which is in most cases not necessary
    // if (name != null && name.charAt (0) != '<')
      print (group);

    indent_ += sep_;
    super.tGroupNode (group);  // traverse children
    indent_ = oldindent;
  }

  /**
   * in this simple example handle all nodes the same way: print their
   * nodenames; in practise each node will deserve its own handling;
   * especially non-Group Nodes that have children of type SFNode/MFNode
   * will have to handle them too (see Shape for an example)
   */

  void print (Node n)
  {
    System.out.println (indent_ + n.nodeName ());
  }

  // Grouping nodes: default behaviour - traverse children
  // void tGroup (Group g)  { tGroupNode (g); }
  // void tAnchor (Anchor g)  { tGroupNode (g); }
  // void tBillboard (Billboard g)  { tGroupNode (g); }
  // void tCollision (Collision g)  { tGroupNode (g); }
  // void tTransform (Transform g)  { tGroupNode (g); }
  // void tInline (Inline g)  { tGroupNode (g); }
  // void tLOD (LOD g)  { tGroupNode (g); }
  // void tSwitch (Switch g)  { tGroupNode (g); }

  // Sound
  protected void tAudioClip (AudioClip n)  { print (n); }
  protected void tSound (Sound n)  { print (n); }

  // Lights
  protected void tDirectionalLight (DirectionalLight n)  { print (n); }
  protected void tPointLight (PointLight n) { print (n); }
  protected void tSpotLight (SpotLight n)  { print (n); }

  // Script
  protected void tScript (Script n)  { print (n); }

  protected void tWorldInfo (WorldInfo n)  { print (n); }


  // Sensors
  protected void tCylinderSensor (CylinderSensor n)  { print (n); }
  protected void tPlaneSensor (PlaneSensor n)  { print (n); }
  protected void tProximitySensor (ProximitySensor n)  { print (n); }
  protected void tSphereSensor (SphereSensor n)  { print (n); }
  protected void tTimeSensor (TimeSensor n)  { print (n); }
  protected void tTouchSensor (TouchSensor n)  { print (n); }
  protected void tVisibilitySensor (VisibilitySensor n)  { print (n); }


  // Shape
  protected void tShape (Shape shape)
  {
    // typically you will also have to traverse SFNode children
    // like this (includes check for null nodes):
    // Node.traverseNode (this, shape.appearance.getNode ());
    // Node.traverseNode (this, shape.geometry.getNode ());

    print (shape);
  }

  // Geometry
  protected void tBox (Box n)  { print (n); }
  protected void tCone (Cone n)  { print (n); }
  protected void tCylinder (Cylinder n)  { print (n); }
  protected void tElevationGrid (ElevationGrid n)  { print (n); }
  protected void tExtrusion (Extrusion n)  { print (n); }
  protected void tIndexedFaceSet (IndexedFaceSet n)  { print (n); }
  protected void tIndexedLineSet (IndexedLineSet n)  { print (n); }
  protected void tPointSet (PointSet n)  { print (n); }
  protected void tSphere (Sphere n)  { print (n); }
  protected void tText (Text n)  { print (n); }

  // Geometric Properties
  protected void tColor (Color n)  { print (n); }
  protected void tCoordinate (Coordinate n)  { print (n); }
  protected void tNormal (Normal n)  { print (n); }
  protected void tTextureCoordinate (TextureCoordinate n)  { print (n); }

  // Appearance Nodes
  protected void tAppearance (Appearance app)
  { // like for Shape you will traverse material, texture, textureTransform here
    print (app);
  }
  protected void tFontStyle (FontStyle n)  { print (n); }
  protected void tMaterial (Material n)  { print (n); }
  protected void tImageTexture (ImageTexture n)  { print (n); }
  protected void tMovieTexture (MovieTexture n)  { print (n); }
  protected void tPixelTexture (PixelTexture n)  { print (n); }
  protected void tTextureTransform (TextureTransform n)  { print (n); }

  // Interpolator Nodes
  protected void tColorInterpolator (ColorInterpolator n)  { print (n); }
  protected void tCoordinateInterpolator (CoordinateInterpolator n)  { print (n); }
  protected void tNormalInterpolator (NormalInterpolator n)  { print (n); }
  protected void tOrientationInterpolator (OrientationInterpolator n)  { print (n); }
  protected void tPositionInterpolator (PositionInterpolator n)  { print (n); }
  protected void tScalarInterpolator (ScalarInterpolator n)  { print (n); }

  // Bindable Nodes
  protected void tBackground (Background n)  { print (n); }
  protected void tFog (Fog n)  { print (n); }
  protected void tNavigationInfo (NavigationInfo n)  { print (n); }
  protected void tViewpoint (Viewpoint n)  { print (n); }

  // instance of a PROTO node
  protected void tProtoInstance (ProtoInstance n)  { print (n); }

} // SampleTraverser
