/*
 * <copyright>
 *
 * Copyright (c) 1996,97
 * Institute for Information Processing and Computer Supported New Media (IICM),
 * Graz University of Technology, Austria.
 *
 * This file is part of the `pw' VRML 2.0 parser.
 *
 * </copyright>
 */
/*
 * Decompression.java
 * stream decompression via external program call
 *
 * created: mpichler, 19970414
 *
 * changed: mpichler, 19970414
 *
 * $Id: Decompression.java,v 1.4 1997/08/01 12:46:24 mpichler Exp $
 */


package iicm.vrml.pw;

import java.io.*;


// Decompression

abstract public class Decompression
{
  // no need ever to create an instance of this class
  private Decompression ()  { }

  /** magic number of compressed files */
  public final static int COMPRESSION_MAGIC = 0x1f;


  /**
   * check whether the InputStream contains compressed data. In this
   * case execute gunzip and return a stream of decompressed data.
   * If executing gunzip fails (e.g. not allowed for applets) or the
   * input data were not compressed, the original InputStream is
   * returned unchanged. Only works for standalone applications.
   */

  public static InputStream filter (String filename/*InputStream in*/) throws IOException
  {
    if (filename.indexOf ('\'') >= 0)  // Unix: don't issue arbitrary sh commands
      return new FileInputStream (filename);

    InputStream in = new BufferedInputStream (new FileInputStream (filename));
    in.mark (64);
    int firstchar = in.read ();
    in.reset ();  // all that stuff to simulate ungetc

    if (firstchar != COMPRESSION_MAGIC)  // check for compression
    {
      // System.out.println ("ordinary file");
      return in;
    }
    // might also check for compression method
    // gunzip supports 0x8b and 0x9d (gzip and compress)
    // System.out.println ("compressed file");

    Runtime runtime = Runtime.getRuntime ();

    // with the appropriate gunzip path this should work on other platforms too
    // String command = "/usr/local/bin/gunzip -c " + filename;  // only works with full path name
    String[] command = { "/bin/sh", "-c", "gunzip -c '" + filename + "'" };  // Unix specific
    // String command = "/bin/echo hello world#VRML V2.0 utf8\nCube {}";
    // String command = "/bin/echo #VRML V2.0 utf8\nCube {}";  // not legal VRML 2.0
    // String command = "/bin/cat";

    try
    {
      Process gunzip = runtime.exec (command);

      InputStream filtered = gunzip.getInputStream ();
      // seems like it is not possible to redirect both process input and output
      // thus we need a file as input

      in.close ();  // gunzip reads from file itself
      System.out.println ("+ " + cmdToString (command));
      return filtered;
    }
    catch (Exception e)
    {
      System.err.println ("Decompression error: could not execute command: " + cmdToString (command));
      System.err.println ("got exception: " + e);  // SecurityException or WriteError
      // e.printStackTrace ();
    }

    return in;

  } // filter


  // tiny helper to print command line

  public static final String cmdToString (String[] arr)
  {
    StringBuffer buf = new StringBuffer ();
    int n = arr.length;
    for (int i = 0;  i < n;  i++)
    {
      buf.append (arr [i]);
      if (i < n-1)
        buf.append (" ");
    }
    return buf.toString ();
  }

  public static final String cmdToString (String s)
  {
    return s;
  }

} // Decompression
