/*
 * Decompiled with CFR 0.152.
 */
import Ice.Communicator;
import Ice.Properties;
import Ice.Util;
import Test.StreamListAdapter;
import java.io.InputStream;
import java.io.PrintStream;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Screen;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class TestApplication
extends MIDlet
implements CommandListener {
    protected Display _display;
    protected Screen _screen = new List("Standard Output", 1);
    protected PrintStream _out;
    protected Command CMD_EXIT = new Command("Exit", 7, 1);
    protected Communicator _communicator;

    protected void shutdown() {
        if (this._communicator != null) {
            try {
                this._communicator.shutdown();
                this._communicator.destroy();
                this._communicator = null;
            }
            catch (Exception exception) {
                this.message("Exception occurred on shutdown: " + exception.toString());
            }
        }
    }

    protected void initIce() {
        Properties properties = Util.createProperties();
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("config");
        if (inputStream != null) {
            properties.load(inputStream);
        }
        this._communicator = Util.initializeWithProperties(new String[0], properties);
    }

    protected void startApp() throws MIDletStateChangeException {
        try {
            if (this._display == null) {
                this._display = Display.getDisplay((MIDlet)this);
                this._screen.addCommand(this.CMD_EXIT);
                this._screen.setCommandListener((CommandListener)this);
            }
            this._out = new PrintStream(new StreamListAdapter((List)this._screen));
            this._display.setCurrent((Displayable)this._screen);
            this.initIce();
        }
        catch (Exception exception) {
            Alert alert = new Alert("startApp alert", exception.getMessage(), null, AlertType.ERROR);
            alert.setTimeout(-2);
            this._display.setCurrent((Displayable)alert);
            throw new MIDletStateChangeException(exception.getMessage());
        }
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean bl) throws MIDletStateChangeException {
        new Thread(new ShutdownTask()).start();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this._screen && command == this.CMD_EXIT) {
            try {
                this.destroyApp(true);
                this.notifyDestroyed();
            }
            catch (MIDletStateChangeException mIDletStateChangeException) {
                // empty catch block
            }
        }
    }

    protected void message(String string) {
        this._out.println(string);
    }

    protected void done() {
        this.message("Done!");
    }

    class ShutdownTask
    implements Runnable {
        ShutdownTask() {
        }

        public void run() {
            TestApplication.this.shutdown();
        }
    }
}

