/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI;

import IceGridGUI.Application.Editor;
import IceGridGUI.Application.Root;
import IceGridGUI.Application.TreeNode;
import IceGridGUI.CellRenderer;
import IceGridGUI.Coordinator;
import IceGridGUI.SimpleInternalFrame;
import IceGridGUI.Tab;
import IceGridGUI.TreeNodeBase;
import com.jgoodies.forms.factories.Borders;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.tree.TreePath;

public class ApplicationPane
extends JSplitPane
implements Tab {
    private Root _root;
    private SimpleInternalFrame _leftPane;
    private SimpleInternalFrame _propertiesFrame;
    private LinkedList _previousNodes = new LinkedList();
    private LinkedList _nextNodes = new LinkedList();
    private TreeNode _currentNode;
    private Editor _currentEditor;

    public void updateUI() {
        super.updateUI();
        this.setEmptyDividerBorder();
    }

    public void selected() {
        Coordinator c = this._root.getCoordinator();
        c.getCloseApplicationAction().setEnabled(true);
        boolean enableSave = this._root.needsSaving() && (this._root.isLive() || this._root.hasFile());
        c.getSaveAction().setEnabled(enableSave);
        c.getDiscardUpdatesAction().setEnabled(enableSave);
        if (this._root.isLive()) {
            c.getSaveToRegistryAction().setEnabled(this._root.needsSaving());
        } else {
            c.getSaveToRegistryAction().setEnabled(c.getSession() != null);
        }
        c.getSaveToFileAction().setEnabled(true);
        c.getBackAction().setEnabled(this._previousNodes.size() > 0);
        c.getForwardAction().setEnabled(this._nextNodes.size() > 0);
        c.showActions(this._currentNode);
    }

    public void refresh() {
        this._root.cancelEdit();
        if (this._currentNode != null) {
            this._currentEditor = this._currentNode.getEditor();
            if (this._root.getCoordinator().getCurrentTab() == this) {
                this._root.getCoordinator().showActions(this._currentNode);
            }
        }
    }

    public void showNode(TreeNodeBase node) {
        TreeNode newNode = (TreeNode)node;
        if (newNode != this._currentNode) {
            if (this._currentNode != null && this._currentNode.isEphemeral() && this._root.hasNode(this._currentNode)) {
                this._currentNode.destroy();
                this._currentNode = null;
            }
            if (newNode == null) {
                this._currentNode = null;
                this.showCurrentNode();
            } else {
                if (this._currentNode != null && this._root.hasNode(this._currentNode)) {
                    this._previousNodes.add(this._currentNode);
                    while (this._previousNodes.size() >= 20) {
                        this._previousNodes.removeFirst();
                    }
                    this._root.getCoordinator().getBackAction().setEnabled(true);
                }
                this._nextNodes.clear();
                this._root.getCoordinator().getForwardAction().setEnabled(false);
                this._currentNode = newNode;
                this.showCurrentNode();
            }
        } else {
            this.refresh();
        }
    }

    public void back() {
        TreeNode previousNode = null;
        do {
            previousNode = (TreeNode)this._previousNodes.removeLast();
        } while (this._previousNodes.size() > 0 && (previousNode == this._currentNode || !this._root.hasNode(previousNode)));
        if (this._previousNodes.size() == 0) {
            this._root.getCoordinator().getBackAction().setEnabled(false);
        }
        if (previousNode != this._currentNode) {
            if (this._currentNode != null) {
                this._nextNodes.addFirst(this._currentNode);
                this._root.getCoordinator().getForwardAction().setEnabled(true);
            }
            this._currentNode = previousNode;
            this._root.disableSelectionListener();
            this._root.setSelectedNode(this._currentNode);
            this._root.enableSelectionListener();
            this.showCurrentNode();
        }
    }

    public void forward() {
        TreeNode nextNode = null;
        do {
            nextNode = (TreeNode)this._nextNodes.removeFirst();
        } while (this._nextNodes.size() > 0 && (nextNode == this._currentNode || !this._root.hasNode(nextNode)));
        if (this._nextNodes.size() == 0) {
            this._root.getCoordinator().getForwardAction().setEnabled(false);
        }
        if (nextNode != this._currentNode) {
            if (this._currentNode != null) {
                this._previousNodes.add(this._currentNode);
                this._root.getCoordinator().getBackAction().setEnabled(true);
            }
            this._currentNode = nextNode;
            this._root.disableSelectionListener();
            this._root.setSelectedNode(this._currentNode);
            this._root.enableSelectionListener();
            this.showCurrentNode();
        }
    }

    public Root getRoot() {
        return this._root;
    }

    public void setRoot(Root newRoot) {
        boolean reset;
        boolean bl = reset = this._root != null;
        if (reset) {
            ToolTipManager.sharedInstance().unregisterComponent(this._root.getTree());
            this._currentNode = null;
            this._previousNodes.clear();
            this._nextNodes.clear();
        }
        this._root = newRoot;
        CellRenderer renderer = new CellRenderer();
        PopupListener popupListener = new PopupListener();
        JTree tree = this._root.getTree();
        tree.setBorder(new EmptyBorder(5, 5, 5, 5));
        tree.setCellRenderer(renderer);
        ToolTipManager.sharedInstance().registerComponent(tree);
        tree.addMouseListener(popupListener);
        tree.getSelectionModel().setSelectionMode(1);
        tree.addTreeSelectionListener(new SelectionListener());
        tree.setRootVisible(true);
        JScrollPane leftScroll = new JScrollPane(tree, 20, 30);
        leftScroll.setBorder(Borders.EMPTY_BORDER);
        this._leftPane.setContent(leftScroll);
        if (reset) {
            this._root.getCoordinator().getMainPane().resetIcon(this._root);
            this._leftPane.validate();
            this._leftPane.repaint();
        }
    }

    public void save() {
        if (this._currentEditor == null || this._currentEditor.save()) {
            this._root.save();
        }
    }

    public void saveToRegistry() {
        if (this._currentEditor == null || this._currentEditor.save()) {
            this._root.saveToRegistry();
        }
    }

    public void saveToFile() {
        if (this._currentEditor == null || this._currentEditor.save()) {
            this._root.saveToFile();
        }
    }

    public void discardUpdates() {
        this._root.discardUpdates();
    }

    public boolean close() {
        this._root.getCoordinator().getMainPane().remove(this);
        return true;
    }

    ApplicationPane(Root root) {
        super(1, true);
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this._leftPane = new SimpleInternalFrame("Descriptors");
        this._leftPane.setPreferredSize(new Dimension(280, 350));
        this._propertiesFrame = new SimpleInternalFrame("Properties");
        this.setLeftComponent(this._leftPane);
        this.setRightComponent(this._propertiesFrame);
        this.setRoot(root);
    }

    private void showCurrentNode() {
        this._root.cancelEdit();
        this._root.getCoordinator().showActions(this._currentNode);
        if (this._currentNode == null) {
            Component oldContent = this._propertiesFrame.getContent();
            if (oldContent != null) {
                this._propertiesFrame.remove(oldContent);
            }
            this._propertiesFrame.setTitle("Properties");
            this._propertiesFrame.setToolBar(null);
            this._currentEditor = null;
        } else {
            this._currentEditor = this._currentNode.getEditor();
            JComponent currentProperties = this._currentEditor.getProperties();
            this._propertiesFrame.setContent(currentProperties);
            this._propertiesFrame.setTitle(currentProperties.getName());
            this._propertiesFrame.setToolBar(this._currentEditor.getToolBar());
        }
        this._propertiesFrame.validate();
        this._propertiesFrame.repaint();
    }

    private void setEmptyDividerBorder() {
        SplitPaneUI splitPaneUI = this.getUI();
        if (splitPaneUI instanceof BasicSplitPaneUI) {
            BasicSplitPaneUI basicUI = (BasicSplitPaneUI)splitPaneUI;
            basicUI.getDivider().setBorder(BorderFactory.createEmptyBorder());
        }
    }

    private class SelectionListener
    implements TreeSelectionListener {
        private SelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            if (ApplicationPane.this._root.isSelectionListenerEnabled()) {
                TreePath path = null;
                if (e.isAddedPath()) {
                    path = e.getPath();
                }
                if (path == null) {
                    ApplicationPane.this.showNode(null);
                } else {
                    ApplicationPane.this.showNode((TreeNode)path.getLastPathComponent());
                }
            }
        }
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            TreeNode node;
            JPopupMenu popup;
            JTree tree;
            TreePath path;
            if (e.isPopupTrigger() && (path = (tree = (JTree)e.getComponent()).getPathForLocation(e.getX(), e.getY())) != null && (popup = (node = (TreeNode)path.getLastPathComponent()).getPopupMenu()) != null) {
                popup.show(tree, e.getX(), e.getY());
            }
        }
    }
}

