/*
 *
 *	RADIUS
 *	Remote Authentication Dial In User Service
 *
 *
 *	Livingston Enterprises, Inc.
 *	6920 Koll Center Parkway
 *	Pleasanton, CA	 94566
 *
 *	Copyright 1992 Livingston Enterprises, Inc.
 *	Copyright 1997 Cistron Internet Services B.V.
 *
 *	Permission to use, copy, modify, and distribute this software for any
 *	purpose and without fee is hereby granted, provided that this
 *	copyright and permission notice appear on all copies and supporting
 *	documentation, the name of Livingston Enterprises, Inc. not be used
 *	in advertising or publicity pertaining to distribution of the
 *	program without specific prior permission, and notice be given
 *	in supporting documentation that copying and distribution is by
 *	permission of Livingston Enterprises, Inc.   
 *
 *	Livingston Enterprises, Inc. makes no representations about
 *	the suitability of this software for any purpose.  It is
 *	provided "as is" without express or implied warranty.
 *
 */

/*
 *	@(#)radiusd.h	2.1  04-Feb-1997
 */

#include "sysdep.h"
#include "radius.h"
#include "conf.h"

/* Server data structures */

typedef struct dict_attr {
	char			name[32];
	int			value;
	int			type;
	int			vendor;
	struct dict_attr	*next;
} DICT_ATTR;

typedef struct dict_value {
	char			attrname[32];
	char			name[32];
	int			value;
	struct dict_value	*next;
} DICT_VALUE;

typedef struct dict_vendor {
	char			vendorname[32];
	int			vendorpec;
	int			vendorcode;
	struct dict_vendor	*next;
} DICT_VENDOR;

typedef struct value_pair {
	char			name[32];
	int			attribute;
	int			type;
	int			length; /* of strvalue */
	UINT4			lvalue;
	int			operator;
	char			strvalue[AUTH_STRING_LEN];
	struct value_pair	*next;
} VALUE_PAIR;

typedef struct auth_req {
	UINT4			ipaddr;
	u_short			udp_port;
	u_char			id;
	u_char			code;
	u_char			vector[16];
	u_char			secret[16];
	u_char			username[AUTH_STRING_LEN];
	VALUE_PAIR		*request;
	int			child_pid;	/* Process ID of child */
	UINT4			timestamp;
	u_char			*data;		/* Raw received data */
	int			data_len;
	VALUE_PAIR		*proxy_pairs;
	/* Proxy support fields */
	u_char			realm[32];
	int			validated;	/* Already md5 checked */
	UINT4			server_ipaddr;
	UINT4			server_id;
	VALUE_PAIR		*server_reply;	/* Reply from other server */
	int			server_code;	/* Reply code from other srv */
	struct auth_req		*next;		/* Next active request */
} AUTH_REQ;

typedef struct client {
	UINT4			ipaddr;
	char			longname[256];
	u_char			secret[16];
	char			shortname[32];
	struct client		*next;
} CLIENT;

typedef struct nas {
	UINT4			ipaddr;
	char			longname[256];
	char			shortname[32];
	char			nastype[32];
	struct nas		*next;
} NAS;

typedef struct realm {
	char			realm[64];
	char			server[64];
	UINT4			ipaddr;
	int			auth_port;
	int			acct_port;
	int			striprealm;
	int			dohints;
	int			trusted;
	struct realm		*next;
} REALM;

enum {
  PW_OPERATOR_EQUAL = 0,	/* = */
  PW_OPERATOR_NOT_EQUAL,	/* != */
  PW_OPERATOR_LESS_THAN,	/* < */
  PW_OPERATOR_GREATER_THAN,	/* > */
  PW_OPERATOR_LESS_EQUAL,	/* <= */
  PW_OPERATOR_GREATER_EQUAL,	/* >= */
};

#define DEBUG	if(debug_flag)log_debug
#define DEBUG2  if (debug_flag > 1)log_debug

#define SECONDS_PER_DAY		86400
#define MAX_REQUEST_TIME	30
#define CLEANUP_DELAY		5
#define MAX_REQUESTS		255

#define L_DBG			1
#define L_AUTH			2
#define L_INFO			3
#define L_ERR			4
#define L_PROXY			5
#define L_CONS			128

#if defined(DBM) || defined(NDBM)
#define USE_DBM 1
#endif

#define VENDOR(x) (x >> 16)

/*
 *	Global variables.
 */
extern char		*recv_buffer;
extern char		*send_buffer;
extern char		*progname;
extern int		debug_flag;
extern char		*radacct_dir;
extern char		*radius_dir;
extern UINT4		expiration_seconds;
extern UINT4		warning_seconds;
extern int		radius_pid;
extern int		use_dbm;
extern int		use_dns;
extern int		use_wtmp;
extern int		log_stripped_names;
extern int		cache_passwd;
extern UINT4		myip;
extern UINT4		warning_seconds;
extern int		log_auth_detail;
extern int		log_auth;
extern int		log_auth_pass;
extern int		auth_port;
extern int		acct_port;

/*
 *	Function prototypes.
 */

/* acct.c */
int		rad_accounting(AUTH_REQ *, int);
int		rad_accounting_orig(AUTH_REQ *, int, char *);
int		radzap(UINT4 nas, int port, char *user, time_t t, int dowtmp);
char		*uue(void *);
int		rad_check_multi(char *name, VALUE_PAIR *request, int maxsimul);

/* attrprint.c */
void		fprint_attr_list(FILE *, VALUE_PAIR *);
void		fprint_attr_val(FILE *, VALUE_PAIR *);

/* dict.c */
int		dict_init(char *);
DICT_ATTR	*dict_attrget(int);
DICT_ATTR	*dict_attrfind(char *);
DICT_VALUE	*dict_valfind(char *);
DICT_VALUE	*dict_valget(UINT4 value, char *);
int		dict_vendorcode(int);
int		dict_vendorpec(int);

/* md5.c */

void		md5_calc(u_char *, u_char *, u_int);

/* radiusd.c */
int		radius_exec_program(char *, VALUE_PAIR *, VALUE_PAIR **, int, char **user_msg);
void		debug_pair(FILE *, VALUE_PAIR *);
int		log_err (char *);
void		sig_cleanup(int);

/* util.c */
char *		ip_hostname (UINT4);
UINT4		get_ipaddr (char *);
int		good_ipaddr(char *);
void		ipaddr2str(char *, UINT4);
void		pairfree(VALUE_PAIR *);
UINT4		ipstr2long(char *);
struct passwd	*rad_getpwnam(char *);
VALUE_PAIR	*pairfind(VALUE_PAIR *, int);
void		pairdelete(VALUE_PAIR **, int);
void		pairadd(VALUE_PAIR **, VALUE_PAIR *);
void		authfree(AUTH_REQ *authreq);
#if (defined (sun) && defined(__svr4__)) || defined(__hpux__) || defined(aix)
void		(*sun_signal(int signo, void (*func)(int)))(int);
#define signal sun_signal
#endif
char		*strNcpy(char *dest, char *src, int n);

/* radius.c */
int		rad_send_reply(int, AUTH_REQ *, VALUE_PAIR *, char *, int);
AUTH_REQ	*radrecv (UINT4, u_short, u_char *, int);
int		calc_digest (u_char *, AUTH_REQ *);
int		calc_acctdigest(u_char *digest, AUTH_REQ *authreq);

/* files.c */
int		user_find(char *name, VALUE_PAIR *,
				VALUE_PAIR **, VALUE_PAIR **);
int		userparse(char *buffer, VALUE_PAIR **first_pair);
void		presuf_setup(VALUE_PAIR *request_pairs);
int		hints_setup(VALUE_PAIR *request_pairs);
int		huntgroup_access(VALUE_PAIR *request_pairs);
CLIENT		*client_find(UINT4 ipno);
char		*client_name(UINT4 ipno);
int		read_clients_file(char *);
REALM		*realm_find(char *);
NAS		*nas_find(UINT4 ipno);
char		*nas_name(UINT4 ipno);
char		*nas_name2(AUTH_REQ *r);
char		*auth_name(AUTH_REQ *authreq, int do_cid);
int		read_naslist_file(char *);
int		read_config_files(void);
int		presufcmp(VALUE_PAIR *check, char *name, char *rest, int rl);
void		pairmove(VALUE_PAIR **to, VALUE_PAIR **from);
void		pairmove2(VALUE_PAIR **to, VALUE_PAIR **from, int attr);

/* version.c */
void		version();

/* log.c */
int		log(int, char *, ...);
int		log_debug(char *, ...);

/* pam.c */
#ifdef PAM
int		pam_pass(char *name, char *passwd, const char *pamauth);
#define PAM_DEFAULT_TYPE    "radius"
#endif

/* proxy.c */
int proxy_send(AUTH_REQ *authreq, int activefd);
int proxy_receive(AUTH_REQ *authreq, int activefd);

/* auth.c */
int		rad_auth_init(AUTH_REQ *authreq, int activefd);
int		rad_authenticate (AUTH_REQ *, int);

/* exec.c */
char		*radius_xlate(char *, VALUE_PAIR *req, VALUE_PAIR *reply);

/* timestr.c */
int		timestr_match(char *, time_t);

#ifdef XTRADIUS
/*
 *	Replace char in a string with the user password.
 *
 */
char *set_user_password(char *, char *);
/*
 *	Replace %k in a string with the ID.
 *
 */
char *set_session_id(char *, int );
/*
 *	Replace %x in a string with the Detail file path.
 *
 */
char *set_detail_log(char *, char *);

int		read_execparams_file(char *);
extern char		paramchar[128];
extern int		paramcode[128];


int radius_env(VALUE_PAIR *request, VALUE_PAIR *reply, char *envp[]);

#endif
