#
#       Makefile
#
###
#
#  Copyright (c) 1994 - 2006	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "useful",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#

# To configure, build, and install in /usr/local/bin
#	make -f xpuzzles.Makefile configure
#	make -f xpuzzles.Makefile         # Motif version built by default
#	make -f xpuzzles.Makefile run     # this cycles through all programs
#	make -f xpuzzles.Makefile install # if you like them
# Any problems please consult the individual README's and let the author know.
# xdial and xthreed are more or less demos and are not built by default.

#SHELL=/bin/sh

#STUFF=abacus dial threed
STUFF=dial threed
ROTATIONAL=rubik skewb dino pyraminx oct mball
SLIDING=cubes triangles hexagons mlink barrel panex

# Swap this next line in and the next line out to build xdial and xthreed
#PUZZLES=${STUFF} ${ROTATIONAL} ${SLIDING}
PUZZLES=${ROTATIONAL} ${SLIDING}

#VER=-7.2.2

XLOCK=more
ALTRIS=tetris tertris hextris welltris
#PRE=xlock
#NAME=xlockmore.
PRE=x
NAME=xpuzzles.
#NAME=xabacus.
#PRE=al
#NAME=altris.
NAME_TRUNC=`echo ${NAME} | cut -c1-8`.

PROGRAMS=${PUZZLES}

# Used by me to zip and write and read from my floppy drive
UNIXDIR=./net
MOUNT=eject -q floppy
#MOUNT=mntflop -d
UMOUNT=eject -p floppy
#UMOUNT=mntflop -u ; if [ -x /usr/bin/eject ]; then ; /usr/bin/eject -p floppy; fi
#DOSDIR=/dosa
#DOSDIR=/floppy/floppy0
# eject is a mount floppy disk utility that I maintain for Linux which is like
# the Solaris version. If there is interest, I will make it publicly available.
# If there is something out there already, let me know.
DOSDIR=win

all :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make;\
			cd ..;\
		fi;\
	done

win :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER}/win ]; then\
			cd ${PRE}$${i}${VER}/win;\
			make;\
			cd ../..;\
		fi;\
	done

autoconf :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in distclean;\
			autoconf;\
			rm -rf autom4te.cache;\
			cd ..;\
		fi;\
	done

configure :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in distclean;\
			./configure;\
			cd ..;\
		fi;\
	done

# Use this in conjunction with the next one
configure-x :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in distclean;\
			./configure --without-motif ;\
			cd ..;\
		fi;\
	done

configure-xm :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in distclean;\
			./configure --enable-xm-prefix ;\
			cd ..;\
		fi;\
	done

configure-sound :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in distclean;\
			./configure --enable-def-play="play.sh" ;\
			cd ..;\
		fi;\
	done

xmkmf :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			xmkmf -a;\
			cd ..;\
		fi;\
	done

# add in all extra features
pre-xmkmf :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			cp -p Imakefile Imakefile.orig;\
			sed -e "s/^XCOMM #define/#define/" Imakefile.orig > Imakefile;\
			cd ..;\
		fi;\
	done

post-xmkmf :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			mv Imakefile.orig Imakefile;\
			cd ..;\
		fi;\
	done

lint :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make lint;\
			cd ..;\
		fi;\
	done

lint.w :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER}/win ]; then\
			cd ${PRE}$${i}${VER}/win;\
			make lint;\
			cd ../..;\
		fi;\
	done

indent :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make indent;\
			cd ..;\
		fi;\
	done

indentcheck :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			ls -al *.c *.c~ *.h *.h~;\
			cd ..;\
		fi;\
	done

dbx :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in gdb;\
			cd ..;\
		fi;\
	done

gdb :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in gdb;\
			cd ..;\
		fi;\
	done

run :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in run;\
			cd ..;\
		fi;\
	done

run.scores :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in run.scores;\
			cd ..;\
		fi;\
	done

run.version :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in run.version;\
			cd ..;\
		fi;\
	done

run.w :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER}/win ]; then\
			cd ${PRE}$${i}${VER}/win;\
			make -f Makefile run;\
			cd ../..;\
		fi;\
	done

dist.w :
	mkdir -p $(DOSDIR);\
	cp ${NAME}README $(DOSDIR)/${NAME}README;\
	cp ${NAME}README $(DOSDIR)/${NAME}README.old;\
	unix2dos $(DOSDIR)/${NAME}README.old $(DOSDIR)/${NAME}README;\
	rm $(DOSDIR)/${NAME}README.old;\
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER}/win ]; then\
			cd ${PRE}$${i}${VER}/win;\
			make -f Makefile dist;\
			cd ../..;\
		fi;\
	done

clean :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in clean;\
			cd ..;\
		fi;\
	done

distclean :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in distclean;\
			cd ..;\
		fi;\
	done

clean.all : distclean

pack :
	rm -rf xt xt.tar.bz2;\
	mkdir net;\
	make bzip2;\
	mv net xt ;\
	tar cvjf xt.tar.bz2 xt;\
	sftp gwyn.tux.org

tar :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in tar;\
			cd ..;\
		fi;\
	done

compress :
	cp -p ${NAME}README ${UNIXDIR}/${NAME}README;\
	cp -p ${NAME}Makefile ${UNIXDIR}/${NAME}Makefile;\
	cp -p ${NAME}lsm ${UNIXDIR}/${NAME}lsm;\
	cp -p xabacus.lsm ${UNIXDIR}/xabacus.lsm;\
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in compress;\
			cd ..;\
		fi;\
	done

gzip :
	cp -p ${NAME}README ${UNIXDIR}/${NAME}README;\
	cp -p ${NAME}Makefile ${UNIXDIR}/${NAME}Makefile;\
	cp -p ${NAME}lsm ${UNIXDIR}/${NAME}lsm;\
	cp -p xabacus.lsm ${UNIXDIR}/xabacus.lsm;\
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in gzip;\
			cd ..;\
			mv ${PRE}$${i}${VER}.tar.gz ${UNIXDIR};\
		fi;\
	done

bzip2 :
	cp -p ${NAME}README ${UNIXDIR}/${NAME}README;\
	cp -p ${NAME}Makefile ${UNIXDIR}/${NAME}Makefile;\
	cp -p ${NAME}lsm ${UNIXDIR}/${NAME}lsm;\
	cp -p xabacus.lsm ${UNIXDIR}/xabacus.lsm;\
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in bzip2;\
			cd ..;\
			mv ${PRE}$${i}${VER}.tar.bz2 ${UNIXDIR};\
		fi;\
	done

dostgz :
	${MOUNT};\
	cp -p ${NAME}README ${DOSDIR}/${NAME}rea;\
	cp -p ${NAME}Makefile ${DOSDIR}/${NAME}mak;\
	cp -p ${NAME}lsm ${DOSDIR}/${NAME}lsm;\
	cp -p xabacus.lsm ${DOSDIR}/xabacus.lsm;\
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in tgz;\
			cd ..;\
			cp `echo ${PRE}$${i}${VER} | cut -c1-8`.tgz ${DOSDIR};\
		if [ -w ${DOSDIR}/`echo ${PRE}$${i}${VER} | cut -c1-8`.tgz ]; then\
				rm -f `echo ${PRE}$${i}${VER} | cut -c1-8`.tgz;\
			fi;\
		fi;\
	done;\
	${UMOUNT}

unixtgz :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
	   		make -f Makefile.in tgz;\
			cd ..;\
		fi;\
	done;\
	DEVICE=/dev/fd0;\
	OS=`uname`;\
	if [ "$${OS}" = "SunOS7" ]; then\
		eject -q floppy 2> /tmp/dev$$;\
		DEVICE=`cat /tmp/dev$$ | cut -f1 -d' '`;\
		rm -f /tmp/dev$$;\
	fi;\
	tar cvf $${DEVICE} *.tgz ${NAME}README ${NAME}Makefile ${NAME}lsm;\
	for i in ${PROGRAMS}; do\
		rm -f `echo ${PRE}$${i}${VER} | cut -c1-8`.tgz;\
	done;\
	if [ "$${OS}" = "SunOS7" ]; then\
		trap "exit 0" 0;\
		eject -p floppy 2> /dev/null;\
	fi

utar :
	for i in ${PROGRAMS}; do\
		tar xvf ${PRE}$${i}${VER}.tar;\
		rm -f ${PRE}$${i}${VER}.tar;\
	done

uncompress :
	for i in ${PROGRAMS}; do\
		if [ -r ${PRE}$${i}${VER}.tar.Z ]; then\
			uncompress ${PRE}$${i}${VER}.tar.Z;\
			tar xvf ${PRE}$${i}${VER}.tar;\
			rm -f ${PRE}$${i}${VER}.tar;\
		else echo "no ${PRE}$${i}${VER}.tar.Z";\
		fi;\
	done

gunzip :
	for i in ${PROGRAMS}; do\
		if [ -r ${PRE}$${i}${VER}.tar.gz ]; then\
			gunzip ${PRE}$${i}${VER}.tar.gz;\
			tar xvf ${PRE}$${i}${VER}.tar;\
			rm -f ${PRE}$${i}${VER}.tar;\
		else echo "no ${PRE}$${i}${VER}.tar.gz";\
		fi;\
	done

bunzip2 :
	for i in ${PROGRAMS}; do\
		if [ -r ${PRE}$${i}${VER}.tar.bz2 ]; then\
			rm -f ${PRE}$${i}${VER}.tar;\
			bunzip2 ${PRE}$${i}${VER}.tar.bz2;\
			tar xvf ${PRE}$${i}${VER}.tar;\
			rm -f ${PRE}$${i}${VER}.tar;\
		else echo "no ${PRE}$${i}${VER}.tar.bz2";\
		fi;\
	done

utgz :
	for i in ${PROGRAMS}; do\
		if [ -r `echo ${PRE}$${i}${VER} | cut -c1-8`.tgz ]; then\
			gunzip -f `echo ${PRE}$${i}${VER} | cut -c1-8`.tgz;\
			tar xvf `echo ${PRE}$${i}${VER} | cut -c1-8`.tar;\
			rm -f `echo ${PRE}$${i}${VER} | cut -c1-8`.tar;\
		fi;\
	done

dosextract :
	${MOUNT};\
	cp ${DOSDIR}/${NAME}rea ${NAME}README;\
	cp ${DOSDIR}/${NAME}mak ${NAME}Makefile;\
	cp ${DOSDIR}/${NAME}lsm ${NAME}lsm;\
	cp ${DOSDIR}/xabacus.lsm xabacus.lsm;\
	chmod 600 ${NAME}README ${NAME}Makefile ${NAME}lsm;\
	for i in ${PROGRAMS}; do\
		if [ -r ${DOSDIR}/`echo ${PRE}$${i}${VER} | cut -c1-8`.tgz ]; then\
			cp ${DOSDIR}/`echo ${PRE}$${i}${VER} | cut -c1-8`.tgz .;\
		fi;\
	done;\
	${UMOUNT}

unixextract :
	DEVICE=/dev/fd0;\
	OS=`uname`;\
	if [ "$${OS}" = "SunOS7" ]; then\
		eject -q floppy 2> /tmp/dev$$;\
		DEVICE=`cat /tmp/dev$$ | cut -f1 -d' '`;\
		rm -f /tmp/dev$$;\
	fi;\
	tar xvf $${DEVICE};\
	if [ "$${OS}" = "SunOS7" ]; then\
		trap "exit 0" 0;\
		eject -p floppy 2> /dev/null;\
	fi

read :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			more README;\
			cd ..;\
		fi;\
	done

man :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in man;\
			cd ..;\
		fi;\
	done

dist.man :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in dist.man;\
			cd ..;\
		fi;\
	done

html :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in html;\
			cd ..;\
		fi;\
	done

hlp :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in hlp;\
			cd ..;\
		fi;\
	done

#print :

install :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make install;\
			cd ..;\
		fi;\
	done

uninstall :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make uninstall;\
			cd ..;\
		fi;\
	done

install-games :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make install-games;\
			cd ..;\
		fi;\
	done

uninstall-games :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make uninstall-games;\
			cd ..;\
		fi;\
	done

install-png :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make install-png;\
			cd ..;\
		fi;\
	done

uninstall-png :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make uninstall-png;\
			cd ..;\
		fi;\
	done

install-xpm :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make install-xpm;\
			cd ..;\
		fi;\
	done

uninstall-xpm :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make uninstall-xpm;\
			cd ..;\
		fi;\
	done

install-xpm-home :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make install-xpm-home;\
			cd ..;\
		fi;\
	done

uninstall-xpm-home :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make uninstall-xpm-home;\
			cd ..;\
		fi;\
	done

vi :
	for i in ${PROGRAMS}; do\
		vi ${PRE}$${i}${VER}/?`echo $${i} | cut -c2-`.c;\
	done

# fixes output from CDE dticon for Sun CC compiler
fix-xpm :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make fix-xpm;\
			cd ..;\
		fi;\
	done
