/*-
# X-BASED DINOSAUR CUBE
#
#  DinoP.h
#
###
#
#  Copyright (c) 1995 - 2005	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Dino */

#ifndef _DinoP_h
#define _DinoP_h

#ifdef WINVER
#define STRICT

#include <windows.h>
#include <time.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "Dino.h"

#if ((WINVER > 0x030a) && !defined(GCL_HBRBACKGROUND))
#undef WINVER
#define WINVER 0x030a
#endif
#if (WINVER <= 0x030a)		/* if WINDOWS 3.1 or less */
#define POS int
#define SETBACK(h,b) (void)SetClassWord(h,GCW_HBRBACKGROUND,(WORD)b);
#define MoveTO(h,x,y,lp) MoveTo(h,x,y);
#else
#define POS long
#define SETBACK(h,b) (void)SetClassLong(h,GCL_HBRBACKGROUND,(LONG)b);
#define MoveTO(h,x,y,lp) MoveToEx(h,x,y,lp);
#endif
#ifndef Point
#define Point POINT
#endif
#ifndef Position
#define Position POS
#endif
#ifndef Boolean
#define Boolean BOOL
#endif
#ifndef True
#define True TRUE
#endif
#ifndef False
#define False FALSE
#endif
#define GC COLORREF  /* Equate apples to oranges */
#define FULLCIRCLE NUM_DEGREES

#define RECTANGLE(w,x,y,l,h) (void)Rectangle(w->core.hDC,x,y,x+l,y+h)
#define LINE(w,x1,y1,x2,y2) (void)MoveTO(w->core.hDC,x1,y1,NULL); \
  (void)LineTo(w->core.hDC,x2,y2)
#define CIRCLE(w,r,x,y) if(r>0)(void)Ellipse(w->core.hDC,x-r+1,y-r+1,x+r,y+r)
#define DRAWRECTANGLE(w,c,x,y,l,h) w->dino.hPen = CreatePen(PS_SOLID, 1, c); \
  w->dino.hOldPen = (HPEN) SelectObject(w->core.hDC, w->dino.hPen); \
  RECTANGLE(w,x,y,l,h); \
  (void) SelectObject(w->core.hDC, w->dino.hOldPen); \
  (void) DeleteObject(w->dino.hPen)
#define FILLRECTANGLE(w,c,x,y,l,h) w->dino.hPen = CreatePen(PS_SOLID, 1, c); \
  w->dino.hOldPen = (HPEN) SelectObject(w->core.hDC, w->dino.hPen); \
  w->dino.hBrush = CreateSolidBrush(c); \
  w->dino.hOldBrush = (HBRUSH) SelectObject(w->core.hDC, w->dino.hBrush); \
  RECTANGLE(w,x,y,l,h); \
  (void) SelectObject(w->core.hDC, w->dino.hOldBrush); \
  (void) DeleteObject(w->dino.hBrush); \
  (void) SelectObject(w->core.hDC, w->dino.hOldPen); \
  (void) DeleteObject(w->dino.hPen)
#define DRAWLINE(w,c,x1,y1,x2,y2) w->dino.hPen = CreatePen(PS_SOLID, 1, c); \
  w->dino.hOldPen = (HPEN) SelectObject(w->core.hDC, w->dino.hPen); \
  LINE(w,x1,y1,((y1==y2)?1:0)+x2,((x1==x2)?1:0)+y2); \
  (void) SelectObject(w->core.hDC, w->dino.hOldPen); \
  (void) DeleteObject(w->dino.hPen)
#define DRAWCIRCLE(w,c,d,x,y) w->dino.hPen = CreatePen(PS_SOLID, 1, c); \
  w->dino.hOldPen = (HPEN) SelectObject(w->core.hDC, w->dino.hPen); \
  CIRCLE(w,((d+1)>>1),x,y); \
  (void) SelectObject(w->core.hDC, w->dino.hOldPen); \
  (void) DeleteObject(w->dino.hPen)
#define FILLCIRCLE(w,c,d,x,y) w->dino.hPen = CreatePen(PS_SOLID, 1, c); \
  w->dino.hOldPen = (HPEN) SelectObject(w->core.hDC, w->dino.hPen); \
  w->dino.hBrush = CreateSolidBrush(c); \
  w->dino.hOldBrush = (HBRUSH) SelectObject(w->core.hDC, w->dino.hBrush); \
  CIRCLE(w,((d+1)>>1),x,y); \
  (void) SelectObject(w->core.hDC, w->dino.hOldBrush); \
  (void) DeleteObject(w->dino.hBrush); \
  (void) SelectObject(w->core.hDC, w->dino.hOldPen); \
  (void) DeleteObject(w->dino.hPen)
#define DRAWTEXT(w,c,x,y,s,l) (void) SetTextColor(w->core.hDC, c); \
  (void) SetBkMode(w->core.hDC, TRANSPARENT); \
  (void) TextOut(w->core.hDC, (x)-3, (y)-11, (LPCSTR) s, l)

#if 0
#define DISPLAY_WARNING(s) (void) fprintf(stderr, s)
#else
#define DISPLAY_WARNING(s) (void) MessageBox(w->core.hWnd, (LPCSTR) s, \
  "Warning", MB_OK)
#endif
#define DISPLAY_ERROR(s) (void) fprintf(stderr, "%s\n", s); exit(1)

typedef struct _CorePart {
	HWND        hWnd;
	HDC         hDC;
	HINSTANCE   hInstance;
	POS         width, height;
} CorePart;

#else

#include <stdlib.h>
#include <stdio.h>
#ifdef VMS
#include <unixlib.h>
#else
#if HAVE_UNISTD_H
#include <unistd.h>
#endif
#endif
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/CoreP.h>
#include "Dino.h"

#ifndef Point
#define Point XPoint
#endif
#define MULT 64
#define FULLCIRCLE (NUM_DEGREES*MULT)
#define DRAWLINE(w,c,i,j,k,l) XDrawLine(XtDisplay(w),XtWindow(w),\
  c,i,j,k,l)
#define FILLRECTANGLE(w,c,i,j,l,h) XFillRectangle(XtDisplay(w),XtWindow(w),\
  c,i,j,l,h)
#define DRAWRECTANGLE(w,c,i,j,l,h) XDrawRectangle(XtDisplay(w),XtWindow(w),\
  c,i,j,l,h)
#define FILLCIRCLE(w,c,d,x,y) if(d>0) XFillArc(XtDisplay(w),XtWindow(w),\
  c,x-((d)>>1),y-((d)>>1),d,d,0,FULLCIRCLE)
#define DRAWCIRCLE(w,c,d,x,y) if(d>0) XDrawArc(XtDisplay(w),XtWindow(w),\
  c,x-((d)>>1),y-((d)>>1),d,d,0,FULLCIRCLE)
#define DRAWTEXT(w,c,x,y,s,l) (void) XDrawString(XtDisplay(w),XtWindow(w),\
  c,x,y,s,l)
#define POLYGON(w,c,lc,l,n,o) XFillPolygon(XtDisplay(w), XtWindow(w), c, \
  l, n, Convex, (o) ? CoordModeOrigin : CoordModePrevious); \
  XDrawLines(XtDisplay(w), XtWindow(w), lc, \
  l, (n)+1,(o) ? CoordModeOrigin : CoordModePrevious)
#define POLYLINE(w,c,l,n,o) XDrawLines(XtDisplay(w), XtWindow(w), c, \
  l, n,(o) ? CoordModeOrigin : CoordModePrevious)

#define DISPLAY_WARNING(s) XtWarning(s)
#define DISPLAY_ERROR(s) XtError(s)

/* This gets around C's inability to do inheritance */
typedef struct _DinoClassPart {
	int         ignore;
} DinoClassPart;

typedef struct _DinoClassRec {
	CoreClassPart core_class;
	DinoClassPart dino_class;
} DinoClassRec;

extern DinoClassRec dinoClassRec;
#endif

#define SYMBOL ':'

#define IGNORE_DIR (-1)
#define TR 0
#define BR 1
#define BL 2
#define TL 3
#define STRT 4
#define CW 5
#define HALF 6
#define CCW 7
#define TOP 8
#define RIGHT 9
#define BOTTOM 10
#define LEFT 11
#define MAXORIENT 4
#define MAXROTATE 3
#define CORNER 0
#define MIDDLE 1
#define EDGE 2
#define FACE 3

#define ABS(a) (((a)<0)?(-(a)):(a))
#define SIGN(a) (((a)<0)?(-1):1)
#define MIN(a,b) (((int)(a)<(int)(b))?(int)(a):(int)(b))
#define MAX(a,b) (((int)(a)>(int)(b))?(int)(a):(int)(b))

/*** random number generator ***/
#if HAVE_RAND48
#define SRAND srand48
#define LRAND lrand48
#else /* HAVE_RAND48 */
#if HAVE_RANDOM
#define SRAND srand48
#define LRAND lrand48
#else /* HAVE_RANDOM */
#if HAVE_RAND
#define SRAND srand48
#define LRAND lrand48
#endif /* HAVE_RAND */
#endif /* HAVE_RANDOM */
#endif /* HAVE_RAND48 */
#ifndef SRAND
extern void SetRNG(long s);
#define SRAND(X) SetRNG((long) X)
#endif
#ifndef LRAND
extern long LongRNG(void);
#define LRAND() LongRNG()
#endif
#define NRAND(X) ((int)(LRAND()%(X)))

typedef struct _DinoLoc {
	int         face, side, dir;
} DinoLoc;

typedef struct _DinoCornerLoc {
	int         face, rotation;
} DinoCornerLoc;

typedef struct _DinoPart {
	DinoCornerLoc cubeLoc[MAXFACES][MAXORIENT];
	DinoCornerLoc faceLoc[MAXORIENT];
	DinoCornerLoc rowLoc[MAXORIENT][MAXORIENT];
	DinoCornerLoc spindleLoc[MAXROTATE][2];
	int         currentFace, currentPosition, currentDirection;
	Boolean     started, cheat;
	Boolean     practice, orient, vertical, mono, reverse, focus;
	int         dim; /* This allows us to reuse code between 2d and 3d */
	int         mode, style;
	Position    delta;
	Position    orientLineLength;
	Point       puzzleSize;
	Point       puzzleOffset, letterOffset;
	GC          frameGC, borderGC, inverseGC;
	GC          faceGC[MAXFACES];
#ifdef WINVER
	char        username[81];
	char        faceChar[MAXFACES];
	HPEN        hOldPen, hPen;
	HBRUSH      hOldBrush, hBrush;
#else
	int         menu;
	char       *username, *font;
	XFontStruct *fontInfo;
	char       *faceName[MAXFACES];
	Pixel       foreground, background;
	Pixel       frameColor, borderColor;
	Pixel       faceColor[MAXFACES];
	XtCallbackList select;
#endif
} DinoPart;

typedef struct _DinoRec {
	CorePart    core;
	DinoPart    dino;
} DinoRec;

typedef struct _RowNext {
	int         face, direction, side_face;
} RowNext;

extern void HideDino(
#ifdef WINVER
const DinoWidget w
#else
DinoWidget w, XEvent * event, char **args, int nArgs
#endif
);
extern void SelectDino(DinoWidget w
#ifdef WINVER
, const int x, const int y, const int control
#else
, XEvent * event, char **args, int nArgs
#endif
);
extern void ReleaseDino(DinoWidget w
#ifdef WINVER
, const int x, const int y, const int shift, const int control, const int alt
#else
, XEvent * event, char **args, int nArgs
#endif
);
extern void PracticeDino(DinoWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
#ifndef WINVER
extern void PracticeDinoMaybe(DinoWidget w
, XEvent * event, char **args, int nArgs
);
extern void PracticeDino2(DinoWidget w
, XEvent * event, char **args, int nArgs
);
#endif
extern void RandomizeDino(DinoWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
#ifndef WINVER
extern void RandomizeDinoMaybe(DinoWidget w
, XEvent * event, char **args, int nArgs
);
extern void RandomizeDino2(DinoWidget w
, XEvent * event, char **args, int nArgs
);
#endif
extern void GetDino(DinoWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void WriteDino(DinoWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void ClearDino(DinoWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void UndoDino(DinoWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void SolveDino(DinoWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void OrientizeDino(DinoWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void EnterDino(DinoWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void LeaveDino(DinoWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
#ifndef WINVER
extern void Period2ModeDino(DinoWidget w
, XEvent * event, char **args, int nArgs
);
extern void Period3ModeDino(DinoWidget w
, XEvent * event, char **args, int nArgs
);
extern void BothModeDino(DinoWidget w
, XEvent * event, char **args, int nArgs
);
#endif

#ifdef WINVER
extern void POLYGON(DinoWidget w, GC color, GC lineColor, const POINT * poly,
	int n, Boolean origin);
extern void POLYLINE(DinoWidget w, GC color, const POINT * poly,
	int n, Boolean origin);
extern void DestroyDino(HBRUSH brush);
extern void ResizeDino(DinoWidget w);
extern void SizeDino(DinoWidget w);
extern void InitializeDino(DinoWidget w, HBRUSH brush);
extern void ExposeDino(const DinoWidget w);
extern void PeriodModeDino(DinoWidget w, const int mode);
extern void DimDino(DinoWidget w);
extern int  MoveDinoDir(DinoWidget w, const int direction);
extern void SetDino(DinoWidget w, int reason);
extern void SetDinoMove(DinoWidget w, int reason, int face, int position,
	int direction, int style);
#else
extern void QuitDino(DinoWidget w, XEvent * event, char **args, int nArgs);
#endif

extern void MoveDinoInput(DinoWidget w, int x, int y, int direction, int shift,
	int control, int alt);
extern void MoveDino(DinoWidget w, int face, int position, int direction,
	int style, int control);
extern void SetAllColors(DinoWidget w);
#if 0
/* For future auto-solver */
extern void SolvePieces(DinoWidget w);

#endif
extern void DrawAllPieces(DinoWidget w);
extern Boolean CheckSolved(DinoWidget w);
extern void InitMoves(void);
extern void PutMove(int face, int position, int direction, int style,
	int control);
extern void GetMove(int *face, int *position, int *direction, int *style,
	int *control);
extern int  MadeMoves(void);
extern void FlushMoves(DinoWidget w);
extern int  NumMoves(void);
extern void ScanMoves(FILE * fp, DinoWidget w, int moves);
extern void PrintMoves(FILE * fp);
extern void ScanStartPosition(FILE * fp, DinoWidget w);
extern void PrintStartPosition(FILE * fp, DinoWidget w);
extern void SetStartPosition(DinoWidget w);

#ifdef DEBUG
extern void PrintCube(DinoWidget w);

#endif

#endif /* _DinoP_h */
