#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "stdio.h"
#include "strings.h"
#include "string.h"

#include <gtk/gtk.h>

#ifdef USE_IMLIB
#include <gdk_imlib.h>
#else
#include <gdk-pixbuf/gdk-pixbuf.h>
#endif

#include <gdk/gdk.h>

#include "gtktopdata.h"

#include "gtk_subimagesel.h"

#include "main.h"

#include "callbacks.h"
#include "interface.h"
#include "support.h"
//#include "pixmaps.h"
#include "mesh-gtk.h"
#include "utils.h"
#include "gtk-extra.h"
#include "../libmorph/relax.h"

/* we will implement UNDO by copying this structure and its substructures */
gtkmorph_status_t  settings,
  *sp = &settings;


char * theunimplemented_text="sorry this functions is as yet unimplemented";
#define unimplemented_text  (_(theunimplemented_text))





/* some code was taken from the gtk-tutorial , the "scribble" example */


/*******************************************************************
******************************************************************

                    main window 

**********************************************************************
**********************************************************************

*/



void
on_morph_help_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  show_warning( _("\
To morph:\n\
  1) load an image in each `input image',\n\
  2) edit the meshes by dragging the points\n\
  3) set the `blending factors' and `mesh factors' as desired\n\
  3) and hit `do morph'\n\
Tips:\n\
  0) as soon as you load the images, set all factors to equal values and\n\
    do a morph: if the images do not superimpose well, you may try to select\n\
    a subimage in each image so that they superimpose better\n\
  1) try to keep the mesh lines as linear as possible:\n\
   add new lines (with right mouse button) if this helps!\n\
  2) to have a better morph, for each image, set the `morph factors' to\n\
    a maximum, hit `do warp' and try to adjust the mesh until this warp\n\
    looks ok right\n\
  3) if you are fighting with small details, then you should increase\n\
    the resulting image size until you have fixed things\n\
")  );
}


void
on_warp_help_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  show_warning( _("\
It is not difficult to use this program for warping: just\n\
  1) load an image in the `input image 1',\n\
  2) edit the meshes by dragging the points (and use the menu that you get\n\
       by the right mouse button)\n\
  3) and hit `do warp'\n\
")  );
}


void
on_generic_help_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  show_warning( _("\
Sorry, there is no real help at the moment; but here are a few clues:\n\
0) at startup the program is set for ``warping'': read the ``warp help''\n\
1) to morph, you need to have 2 or more `input images' :\n\
 use `add an image' (it is in the `file' menu); read the ``morph help''\n\
2) if you keep the mouse still on a menu voice or on a button\n\
  for a moment, you may read the help tips.\n\
3) when the mouse pointer is in on the mesh grid, by hitting\n\
  the right button, you get an useful menu.\n\
4)  if you are `preserving aspect ratio' (see `Settings'),\n\
 when you change the resulting image size, always keep it square:\n\
  the meshes do not scale well otherwise\n\
Nonetheless, it is not difficult to use this program:\n\
read the two short helps below.")  );
}


//void
//on_logtext_realize                     (GtkWidget       *widget,
//                                        gpointer         user_data)
//{
//
//}



/*
  main menus callbacks 

 */


void
on_load_image_set_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  show_warning( unimplemented_text); //show_fs(menuitem);
}


void
on_load_mesh_set_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{ 
  show_warning( unimplemented_text); //show_fs(menuitem);
}



void
on_save_image_set_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  show_warning( unimplemented_text); //show_fs(menuitem);
}


void
on_preferencesmenu_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  show_warning( unimplemented_text); //show_fs(menuitem);
}


void
on_save_meshes_set_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  show_warning( unimplemented_text); //show_fs(menuitem);  
}


void
on_save_morphed_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  show_warning( unimplemented_text); //show_fs(menuitem);
}


void
on_add_an_image_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    int lp;
    for(lp=1 ; lp <= MAX_WINS;  lp ++)
      if(sp->im_widget[lp] == NULL)
	{
	  /* we set this before, 
	     otherwise the "factor_normalize" goes berseker */
	  sp->max_wins++;

	  create_and_show_image_win(lp);	
	  setup_handlebox_factors();
	  return; 
	}
}



void 
on_quit1_activate                      (GtkMenuItem     *menuitem,
					gpointer         user_data) 
{ 
  //FIXME we should handle this more gracefully
  gtk_main_quit();
} 




void
on_view_images1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  int lp;
  for(lp=1 ; lp <= MAX_WINS+1 ; lp ++)
    {
      if(sp->im_widget[lp] != NULL)
	gtk_widget_show (sp->im_widget[lp]);
    }
}

void
redraw_spins();


double
tot_mixing_factors()
{
  double  totdiss;
  int lp;
  totdiss=0;
  for ( lp =1; lp <= MAX_WINS; lp++)
    if(sp->im_widget[lp] != NULL)
      totdiss += sp->mf.im_dissolve_factor[lp];
  // FIXME this is not shown
  sp->mf.im_dissolve_factor[MAX_WINS+1]=totdiss; 
  
  return totdiss;
}

double
tot_mixing_factors_nice()
{
  double totdiss=tot_mixing_factors();
  int lp;
  if ( ABS(totdiss) < 0.001)
    {
      show_warning( _("\
to blend the images, the sum of the all `image mixing factors' must be nonzero\
\nI have put default values for you"));
      
      for ( lp =1; lp <= MAX_WINS; lp++)
	if(sp->im_widget[lp] != NULL) {
	  sp->mf.im_dissolve_factor[lp]=1.0/(double)sp->max_wins;
	  //gtk_widget_get_data_top(sp->im_widget[lp],"imagenum")
	}
      totdiss =1;
      redraw_spins();
    }
  return totdiss;
}


/********************************
does the actual morphing 
********************************/

void
on_morph_images1_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  int lp;
  //double  totdiss=tot_mixing_factors_nice();

  /* geometry of the resulting image */
  int w=sp->resulting_width, h=sp->resulting_height;
  long size = w * h ;

  guint8 * r , *b, *g;

  if( sp->max_wins<=1)
    {
      show_warning( _("\
to morph, you must have at least two input images"));
      return;
    }
  
 if( settings_get_value("automatic mesh interpolation"))
   on_interpolate_meshes1_activate (NULL,NULL);

  //meshAlloc(dstmesh, nx , ny );

/*    totdiss=0; */
/*    for ( lp =1; lp <= MAX_WINS; lp++) */
/*      if(sp->im_widget[lp] != NULL) */
/*        totdiss += sp->mf.im_dissolve_factor[lp]; */

 
  // FIXME this is not shown
  //sp->mf.im_dissolve_factor[MAX_WINS+1]=totdiss;

  //we clear the old image
 //gdk_pixbuf_clear(sp-> im_pixbufwarped[MAX_WINS+1]);

  r = g_malloc( size );
  g = g_malloc( size );
  b = g_malloc( size );
  
  for ( lp =1; lp <= MAX_WINS; lp++)
    if(sp->im_widget[lp] != NULL)
      {
	if( ABS(sp->mf.im_dissolve_factor[lp]) < 0.001 )      
	  g_message("NOT morphing image %d to inbetween\n", lp);
	else
	  {
	    g_message("morphing image %d to inbetween\n", lp);
	    do_warp_an_image(lp, r , g, b);
	    /* dissolve in the total */
	    //g_message("writing pixels for %d\n",lp);
	    //{
	      
	      //GdkPixbuf *pb = sp-> im_pixbufwarped[MAX_WINS+1];
	      //FIXME this doesnt work if there are negative coefficents 
	      //rrrgggbbb_add_to_pixbuf(pb,    r,g,b,
	      //		      sp->mf.im_dissolve_factor[lp] / totdiss
	      //			      );	
	      //we clear the old warped image
	      //gdk_pixbuf_clear(sp-> im_pixbufwarped[lp]);	      
	      //rrrgggbbb_add_to_pixbuf(sp-> im_pixbufwarped[lp],    r,g,b,
	      //			      1.0
	      //			      );
		
	    //}
/* 	    gdk_pixbuf_render_to_drawable   */
/* 	      (sp->im_pixbufwarped[lp], */
/* 	       sp->im_pixwarped[lp], */
/* 	       sp->im_widget[lp]->style->black_gc, //GdkGC *gc, */
/* 	       0, //int src_x, */
/* 	       0, //int src_y, */
/* 	       0, //int dest_x, */
/* 	       0, //int dest_y, */
/* 	       w,h, //width, height, */
/* 	       GDK_RGB_DITHER_NORMAL,//GdkRgbDither dither, */
/* 	       0, //int x_dither, */
/* 	       0 ); //int y_dither); */
	  }
      }

  g_free(r);   g_free(g);   g_free(b); 

  on_do_mixing_clicked(NULL,NULL);
  
/*   gdk_pixbuf_render_to_drawable   */
/*     (sp->im_pixbufwarped[MAX_WINS+1], */
/*      sp->im_pixwarped[MAX_WINS+1], */
/*      sp->im_widget[MAX_WINS+1]->style->black_gc, //GdkGC *gc, */
/*      0, //int src_x, */
/*      0, //int src_y, */
/*      0, //int dest_x, */
/*      0, //int dest_y, */
/*      w,h, //width, height, */
/*      GDK_RGB_DITHER_NORMAL,//GdkRgbDither dither, */
/*      0, //int x_dither, */
/*      0 ); //int y_dither); */

  set_editshow(MAX_WINS+1, settings_get_value( "show warp after warp") );
  gtk_widget_draw (sp->im_widget[MAX_WINS+1] , NULL);
}






/***********************************************************
 *
 *************************** file selection  ************
 *
 **********************************************************

 the following hook is set 
 so that the same fileselection dialog will be used for many
 different purposes

*/

/* see utils.h */

fileselection_hook_t fileselection_hook=NULL;

void
on_ok_button1_realize                  (GtkWidget       *widget,
                                        gpointer         user_data)
{
//  GtkWidget       *widget_f=  gtk_widget_get_toplevel (widget);
// doesnt work
//  gtk_container_add (GTK_CONTAINER (widget_f), 
//		     menu_image_num_g);

//  gtk_menu_item_set_submenu(widget,create_menu_image_num_g );
}



void
on_ok_button1_clicked         (GtkButton       *button,
			       gpointer         user_data)
{  
  char *file=
    gtk_file_selection_get_filename
    (GTK_FILE_SELECTION (imageselection1_g));


  g_assert(fileselection1_for_image_num_g > 0);

  if( //fileselection_hook=load_image_from_file
     fileselection_hook  (fileselection1_for_image_num_g,
			  file))
    {

      gtk_widget_hide(GTK_WIDGET(imageselection1_g));
      gtk_widget_show( sp-> im_widget[fileselection1_for_image_num_g]);  

      // lets be nasty
      fileselection1_for_image_num_g=-2;
      fileselection_hook=NULL;
    }

}
























/********************************************************************
 *
 * input image window, drawingarea
 *

 note: many callbacks are shared with the "resulting image window"

 ******************************************************************
**/




/***************************************************************

 *		drawing area callbacks

 ***********************************************************
*/ 



void
on_drawingarea_realize                 (GtkWidget       *widget,
				     gpointer         user_data)
{
  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,"imagenum")); 
  /* the drawing area widget will be accessible tru this */
  gtk_widget_set_data_top(widget, "drawingarea widget", widget);

  sp->im_drawingarea_widget[i] = widget;

  drawingarea_configure  (i);
}



/* save also the viewport widget address, so we can resize it easily 
   
   actually "glade" does the same thing, and I didnt know it
*/

void
on_viewport3_realize                   (GtkWidget       *widget,
                                        gpointer         user_data)
{
  gtk_widget_set_data_top(widget, "viewport widget", widget);
}



gboolean
on_drawingarea_configure_event         (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
  //int i=
  // GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,"imagenum")); 
  // this loops
  //g_message(" configure drawingarea %d",i);
  //drawingarea_configure(i);
  return TRUE;
}




gboolean
on_expose_event                        (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,"imagenum")); 
  GdkPixmap *pixmap = *(which_pixmap_is_visible(i));// get_pixmap_addr(widget);

  g_assert(i > 0);
  g_assert(pixmap != NULL);

  /* the gtk+ manual (see "drawing area" section)
     says we have to:*/
  gdk_gc_set_clip_rectangle (widget->style->fg_gc[widget->state],
			     &event->area);

  // this one flashes too much
  //gdk_window_clear_area (widget->window,
  //                        event->area.x, event->area.y,
  //                        event->area.width, event->area.height);

  /* then we draw...*/ 
  gdk_draw_pixmap(widget->window,
		  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		  pixmap,
		  event->area.x, event->area.y,
		  event->area.x, event->area.y,
		  event->area.width, event->area.height);
 if( sp->im_editshow[i]==EDITSHOW_EYES)
   {
     gdk_subimagesel_draw( widget->window, &(sp->subimasel[i]), mpl_gc);
   }
 else {
   //if(sp->im_editshow[i]!=EDITSHOW_SHOW ) 
   if ( image_settings_get_value("view original mesh",i))
       gdk_draw_mesh(widget->window,
		     mpl_gc ,
		     mps_gc ,
		     &(sp->im_mesh[i]),// MeshT *mesh, 
		     NULL, //&(sp->subimage[i]),
		     sp->resulting_height,
		     sp->resulting_width
		     );
       
   //if(sp->im_editshow[i]==EDITSHOW_SHOWMESHES && i < MAX_WINS+1)
   if ( image_settings_get_value("view warped mesh",i))
   gdk_draw_mesh(widget->window,
		 widget->style->white_gc ,
		 mpr_gc,
		 &(sp->im_mesh[MAX_WINS+1]),// MeshT *mesh,
		 NULL,//&(sp->subimage[i]),
		 sp->resulting_height,
		 sp->resulting_width
		 );       
 }

  /* sfter that, we  */
  gdk_gc_set_clip_rectangle (widget->style->fg_gc[widget->state],
			     NULL);
  return TRUE;
}



/* gboolean */
/* on_configure_event                     (GtkWidget       *widget, */
/*                                         GdkEventConfigure *event, */
/*                                         gpointer         user_data) */
/* { */
/* //  GdkPixmap *pixmap = get_pixmap_addr(widget); */
/*   //g_assert(pixmap != NULL); */

/*   return FALSE; */

/* } */


























 

/********************************************************************
 *
 * input image window, top bar buttons
 *

 note: many callbacks are shared with the "resulting image window"

 ******************************************************************
**/



/***********************************************************************
  load/save interface
*/




void check_fs()
{
  /*gtk_widget_destroy(imageselection1_g);*/
  if (! GTK_IS_WIDGET (imageselection1_g))
    {
      g_warning("lost image selection widget\n");
      imageselection1_g = GTK_FILE_SELECTION(create_imageselection1() );
    }
}

/***  show file selector 
      
      if title==NULL, make up a title
      
      adds to the title the window number      

      sets the variable fileselection1_for_image_num_g
*/

void show_fs(void *widget,
	     char *title /* fileselection title */
	     ) 
{
  char s[200];
  check_fs();

  fileselection1_for_image_num_g= 
    GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,"imagenum")); 

  g_assert(fileselection1_for_image_num_g > 0);

  sprintf(s,"%s %d",
	   ((title==NULL)?
	    gtk_widget_get_name(GTK_WIDGET(widget)) :
	    title)    ,
	  fileselection1_for_image_num_g);
 
  gtk_window_set_title(GTK_WINDOW (imageselection1_g), s);  

  gtk_widget_show( GTK_WIDGET(imageselection1_g));
}




void
on_loadimage_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  
  int i = GPOINTER_TO_UINT(gtk_widget_get_data_top(GTK_WIDGET(button),"imagenum")); 

  fileselection_hook=load_image_from_file;
       
  if (sp->im_filename[i] != NULL)
    gtk_file_selection_set_filename ((imageselection1_g),
				     sp->im_filename[i] );
  else
    gtk_file_selection_set_filename ((imageselection1_g), 
				     g_strdup_printf("%s%d.png",
						     _("image"),i));    
  show_fs(button, _("load image") );  
}

/***** 
       returns TRUE if it was already known
***/
static gboolean
set_fs_mesh_filename(int i)
{
  if ( sp->im_mesh_filename[i] != NULL)
    {	
      gtk_file_selection_set_filename(imageselection1_g,
				      sp->im_mesh_filename[i]);
      return TRUE;
    }
  else
    {
      char *file= sp-> im_filename[i];
      
      if(file != NULL) { 
	char *s = g_strdup_printf("%s.mesh",file);
	gtk_file_selection_set_filename(imageselection1_g,  s);
	g_free(s);
      }
      return FALSE;
  }
}

void
on_loadmesh_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  int i =
    GPOINTER_TO_UINT(gtk_widget_get_data_top(GTK_WIDGET(button),"imagenum")); 

  fileselection_hook=load_mesh_from_file;

  set_fs_mesh_filename(i);

  show_fs(button, _( "load mesh") ); 
}


void
on_savemesh_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{

  int i = GPOINTER_TO_UINT(gtk_widget_get_data_top(GTK_WIDGET(button),"imagenum")); 

  fileselection_hook=save_mesh_to_file;
  
  set_fs_mesh_filename(i);

  //FIXME auto save doesnt work
  //if( set_fs_mesh_filename(i) == FALSE|| button->state & GDK_SHIFT_MASK)
  show_fs(button, _( "save mesh n.") ); 
  //  else
  /* directly simulate as if OK was hit */
  //on_ok_button1_clicked   (NULL,NULL); 
}



void
on_save_image_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  int i = GPOINTER_TO_UINT(gtk_widget_get_data_top(GTK_WIDGET(button),"imagenum")); 


  GdkPixbuf * pb=*(which_pixbuf_is_visible(i));

  if( pb ==NULL)
    {
      show_warning(_("\
internal error: the image doesnt exist!"));
      return ;
    }

  if( gdk_pixbuf_get_n_channels(pb) != 3)
    {
      show_warning
	(g_strdup_printf
	 (  " cant save :-( the image has %d channels", 
	    gdk_pixbuf_get_n_channels(pb)  ));
      return ;
    }
 

  fileselection_hook=save_image_to_file;

  {
    char *file= sp-> im_filename[i];

    if(file != NULL)
      { 
	char *s = g_strdup_printf("%s.ppm",file);
	      gtk_file_selection_set_filename
	      (GTK_FILE_SELECTION(imageselection1_g), 
	       s);
	    g_free(s);
      }
  }

  show_fs(button, _( "save image (only PPM format) n.") ); 
}















void
on_settings_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{  
  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(GTK_WIDGET(button),"imagenum")); 
  GtkWidget* m=sp->im_menu_settings[i];
  show_warning( unimplemented_text);
  return ;
  gtk_menu_popup (GTK_MENU(m),//GtkMenu *menu,
		  NULL,//GtkWidget *parent_menu_shell,
		  NULL,//GtkWidget *parent_menu_item,
		  NULL,//GtkMenuPositionFunc func,
		  NULL,//gpointer data,
		  1,//guint button,
		  0);//guint32 activate_time);
}






void
on_do_warp_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(GTK_WIDGET(button),"imagenum")); 
 
  /* geometry of the resulting image */
  int w=sp->resulting_width, h=sp->resulting_height;
  long size = w * h ;

  guint8 * r , *b, *g;
  
  r = g_malloc( size );
  g  = g_malloc( size );
  b = g_malloc( size ) ;  
  
  do_warp_an_image(i,r,g,b);
  g_free(r);   g_free(g);   g_free(b); 
}


/*** this routine behaves correclt even if some image factors 
     are negative; the "do_morph" routine didnt
*/
void
on_do_mixing_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  int lp;
  double  totdiss=tot_mixing_factors_nice();

  int     
    w=sp->resulting_width, h=sp->resulting_height;    
  
  if( sp->max_wins<=1)
    {
      show_warning( _("\
to mix images, you must have at least two input images"));
      return;
    }

  {
    GdkPixbuf *dpb = sp-> im_warped_pixbuf[MAX_WINS+1];
    if(dpb==NULL)
      create_pixbuf(MAX_WINS+1, PIXWARPED);
  }
  {

    GdkPixbuf *dpb = sp-> im_warped_pixbuf[MAX_WINS+1];
    guchar  *ddata = gdk_pixbuf_get_pixels(dpb);	
    
    int drowstride= gdk_pixbuf_get_rowstride (dpb) ;
    
    int i,j , dch= gdk_pixbuf_get_n_channels(dpb);

    double val;
    
    long dp=0; /* data position */
    
    /* we precompute some data */
    double fact[MAX_WINS];
    guint8 *data[MAX_WINS];
    int effective_max_wins=0;
    for ( lp =1; lp <= MAX_WINS; lp++) 
      {
	if(sp->im_widget[lp] != NULL &&	  
	   ABS(sp->mf.im_dissolve_factor[lp]) >= 0.001 )	    
	  {  	     	     	     
	    fact[lp] = sp->mf.im_dissolve_factor[lp] / totdiss;
	    data[lp] =	gdk_pixbuf_get_pixels(sp-> im_warped_pixbuf[lp]);
	    g_assert( data[lp] != NULL);

	    effective_max_wins=lp;
	  }
	else
	  data[lp]=NULL;
      }

    //we clear the old image
    gdk_pixbuf_clear(dpb);

    for( j=0; j<  h ; j++)	      
      {
	dp= drowstride * j;
	/* this interpolates also the alpha value, if any  */
	for( i=0; i< w  * dch ; i++)
	  {
	    val = 0 ;   
	    for ( lp =effective_max_wins; lp >= 1; lp--) {
	      if (data[lp] != NULL)
		{
		  val +=  fact[lp] * (double) (data[lp])[dp + i]  ;
		}}
	    /* if teh image is not 8 bit */ 
	    ddata[dp + i] = CLAMP(val, 0, 255);
	  }
      }
  }
  
  render_pixmap(MAX_WINS+1, PIXWARPED);
 
  set_editshow(MAX_WINS+1,  settings_get_value( "show warp after warp")); 
  gtk_widget_draw (sp->im_widget[MAX_WINS+1] , NULL);  
}





void
on_interpolate_meshes1_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  
  int lp,
    nx=sp-> im_mesh[1].nx ,
    ny=sp-> im_mesh[1].ny ;
  double totwarp;

 if( sp->max_wins<=1)
    {
      show_warning( _("\
to interpolate meshes, you must have at least two input images"));
      return;
    }


 //g_message("creating mesh in between...\n");

  totwarp=0;
  for ( lp =1; lp <= MAX_WINS; lp++)
    if( sp->im_widget[lp] != NULL)
      totwarp += sp->mf.im_warp_factor[lp];

  if ( ABS(totwarp)< 0.0001) {
    show_warning( _("\
to interpolate the meshes, the sum of the all `mesh factors' should be nonzero\n\
I have set some default values for you") );
    for ( lp =1; lp <= MAX_WINS; lp++)
      if( sp->im_widget[lp] != NULL)
	sp->mf.im_warp_factor[lp]=1.0/ (double)sp->max_wins;
    totwarp =1;
    redraw_spins();
  }
  // FIXME this is not shown
  sp->mf.im_warp_factor[MAX_WINS+1]=totwarp;

    {
      int xi, yi;  
      double vx,vy;
      
      for(yi=0; yi < ny; yi++) {
	for(xi=0; xi < nx; xi++) {
	  vx=vy=0;
	  for ( lp =1; lp <= MAX_WINS; lp++)
	    if( sp->im_widget[lp] != NULL)
	      {
		vx += meshGetx( &(sp->im_mesh[lp]), xi, yi)
		  * sp->mf.im_warp_factor[lp];
		vy += meshGety( &(sp->im_mesh[lp]), xi, yi)
		  * sp->mf.im_warp_factor[lp];	      
	      }
	  //printf("%d %d %f %f\n",  xi, yi, vx, vy);
	  meshSetNoundo(dstmesh,  xi, yi, vx /totwarp, vy /totwarp);
	}}
      gtk_widget_draw (sp->im_widget[MAX_WINS+1] , NULL);
    }

     
}





/*****************************************************************************

 *               edit/view option menu

 ****************************************************************************/





void
on_optionmenu_editview_released        (GtkButton       *button,
                                        gpointer         user_data)
{
  /* this signal is (almost) never emitted
  printf("the choice is %s \n",
	 gtk_widget_get_name(gtk_menu_get_active (GTK_MENU(user_data)))); 
   */
}


void
on_optionmenu_editview_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
  /* this signal is never emitted
     printf("the click choice is %s \n",
     gtk_widget_get_name(gtk_menu_get_active (GTK_MENU(user_data)))); 
  */
}


void
on_optionmenu_editview_pressed         (GtkButton       *button,
                                        gpointer         user_data)
{
  /* this signal is never emitted
  g_message("at %s %d PRESSED" ,__FILE__ , __LINE__);
  */
}



/* since the 3 above do not work... this comes from the glade FAQ */
void
on_optionmenu_editview__selected (GtkMenuShell *menu_shell,
                    gpointer data)
{
  GtkWidget *active_item;
  gint item_index;

  /* the following fails: the menu_shell has a different window
    int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(GTK_WIDGET(data),
					     "imagenum")); 
  */
  int i=
    GPOINTER_TO_UINT(data);
  g_assert(i>0);

  active_item = gtk_menu_get_active (GTK_MENU (menu_shell));
  item_index = g_list_index (menu_shell->children, active_item);

  /* thanks GOD this works!!
    g_print ("In on_option_selected active: %i\n", item_index);*/
  sp->im_editshow[i]=item_index;

  editview_callback(i);

  gtk_widget_draw (sp->im_widget[i] , NULL);
}















/*
**********************************************************************

************** resulting image,  spinbuttons      ********************

**********************************************************************
*/


void
on_resulting_apply_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{

  int lp;

  sp->resulting_width =  sp->resulting_width_sp;
  sp->resulting_height = sp->resulting_height_sp;


  for( lp =1; lp <= MAX_WINS+1; lp++)
   if ( sp->im_widget[lp] ) 
     {       
       destroy_image_win_data(lp);
       alloc_image_win_data(lp);
       
       meshScale( &(sp->im_mesh[lp]),
		  sp->resulting_width, sp->resulting_height);

       reload_and_scale_image(lp);

       drawingarea_configure(lp);
       gtk_widget_draw( sp-> im_widget[lp], NULL);  
     }
}


void
on_spinbutton_reswidth_draw            (GtkWidget       *widget,
                                        GdkRectangle    *area,
                                        gpointer         user_data)
{
  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,
					     "imagenum")); 
  g_assert(i>0);  
  gtk_spin_button_set_value (GTK_SPIN_BUTTON(widget),
			     sp->resulting_width_sp );
}


void
on_spinbutton_resheight_draw           (GtkWidget       *widget,
                                        GdkRectangle    *area,
                                        gpointer         user_data)
{
 int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,
					     "imagenum")); 
  g_assert(i>0);  
  gtk_spin_button_set_value (GTK_SPIN_BUTTON(widget),
			     sp->resulting_height_sp );
}


void
on_spinbutton_reswidth_changed         (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkSpinButton *spin = GTK_SPIN_BUTTON (editable);
  sp->resulting_width_sp =gtk_spin_button_get_value_as_float (spin);
}


void
on_spinbutton_resheight_changed        (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkSpinButton *spin = GTK_SPIN_BUTTON (editable);
  sp->resulting_height_sp =gtk_spin_button_get_value_as_float (spin);
}





/***********************************************************************
**********************************************************************

image windows callbacks


 note: many callbacks are shared with the "resulting image window"

**********************************************************************
*/


gboolean
on_image_win_1_delete_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{  
  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,"imagenum")); 

  gtk_widget_hide(widget);

  sp->mf.im_warp_factor[i]=0;
  sp->mf.im_dissolve_factor[i]=0;
  
  return TRUE;
}

/***************************************************************

 *		drawing area mesh editing

 ***********************************************************
*/ 





/******************************* sometimes when we change the labels..*/
int all_images_need_redraw=0;

gboolean
on_button_press_event                  (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{

  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,"imagenum")); 
  //GdkPixmap *pixmap = sp->im_pixmap_subimage[i]; //get_pixmap_addr(widget);
  //g_assert(pixmap != NULL);

  g_assert(i > 0);


  if( ( i == MAX_WINS+1) && sp->max_wins>1 &&
      settings_get_value("automatic mesh interpolation")) 
    { 
      show_warning("you cant edit this mesh - it is automatically generated as an interpolation\nof the input images meshes .\n(but if you really want to edit, unset 'automatic mesh interpolation' ");
      return FALSE;     
    }


  /* if the menu says "view", do not edit */
  if( (sp->im_editshow[i] == EDITSHOW_SHOWMESHES && i <= MAX_WINS) )
    {
      show_warning("\
you are currently viewing the warped version of the image\n\
you may not edit this mesh (which refers to the loaded image).\n\
To edit the mesh, select `edit mesh' in the menu (at top center).\n\
I have done it now for you"); 
      set_editshow(i, EDITSHOW_EDIT); 
      return FALSE; 
    }

  if (sp->im_editshow[i] == EDITSHOW_SHOW )
    {
      show_warning("\
To edit the mesh, select the appropriate voice in the menu (at top center).\n\
I have done it now for you "); 
      set_editshow(i, EDITSHOW_EDIT);
      return FALSE;
    }
  if(sp->im_editshow[i]==EDITSHOW_EYES  )     
    gdk_subimagesel_button_press_event (widget,event,user_data);  
  else
    {
      int mi,mj, action;
      gdk_mesh_button_press_event  (widget,event,
				    user_data, &(sp->im_mesh[i]),
				    &mi,&mj, &action);    
    }
  return TRUE;
}


gboolean
on_motion_notify_event                 (GtkWidget       *widget,
                                        GdkEventMotion  *event,
                                        gpointer         user_data)
{

  {
    int i=
      GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,"imagenum")); 
    //GdkPixmap *pixmap = sp->im_pixmap_subimage[i]; 
    // get_pixmap_addr(widget);
    //g_assert(pixmap != NULL);
    g_assert(i > 0);

    if( ( i == MAX_WINS+1) && sp->max_wins>1 &&
	settings_get_value("automatic mesh interpolation"))
      return FALSE;

    /* if the menu says "view", do not edit */
    if( (sp->im_editshow[i] == EDITSHOW_SHOWMESHES && i <= MAX_WINS) )
      return FALSE;
    if(sp->im_editshow[i]==EDITSHOW_SHOW )
      return FALSE;
  
    if(sp->im_editshow[i]==EDITSHOW_EYES )
      {
	//g_warning("subimasel");
	gdk_subimagesel_motion_notify_event (widget,event,user_data);	
      }
    else
      {
	int mi,mj;
	//g_warning("mesh");
	if(gdk_mesh_motion_notify_event   (widget,event,
					   user_data, &(sp->im_mesh[i]),
					   &mi,&mj))
	  {
	    //if ( 0==meshGetLabel(&(sp->im_mesh[i]), mi, mj))
	    if(settings_get_value("mesh auto sync")) {
	      int lp=MAX_WINS+1; 
	      for(; lp>=0; lp--) 
		if(sp->im_widget[lp] != NULL) {
		  //meshSetLabel(&(sp->im_mesh[lp]), mi, mj, -1);
		  /*gtk_widget_draw (sp->im_widget[lp] , NULL); */
		  all_images_need_redraw++;		
		  flash_point(sp->im_drawingarea_widget[lp]->window,
			      meshGetx(&sp->im_mesh[lp],mi,mj),
			      meshGety(&sp->im_mesh[lp],mi,mj)    );
		  
		}
	    }
	  }
      }
  }
  return TRUE;
}


gboolean
on_drawingarea_button_release_event    (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{

  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,"imagenum")); 

  g_assert(i > 0);

  if( ( i == MAX_WINS+1) && sp->max_wins>1 &&
      settings_get_value("automatic mesh interpolation"))
    return FALSE;

  /* if the menu says "view", do not edit */
  if( (sp->im_editshow[i] == EDITSHOW_SHOWMESHES && i <= MAX_WINS) )
    return FALSE;
  if(sp->im_editshow[i]==EDITSHOW_SHOW )
    return FALSE;

  if(//event->state & GDK_BUTTON1_MASK && 
     sp->im_editshow[i]==EDITSHOW_EYES )
    {
      return TRUE;
    }
  else
    { 
      int mi,mj;
      gdk_mesh_button_release_event    ( widget,event,
					 user_data, &(sp->im_mesh[i]),
					 &mi,&mj);      
      
      if( settings_get_value("automatic mesh interpolation")&& sp->max_wins>1)
	{
	  on_interpolate_meshes1_activate(NULL,NULL);
	  gtk_widget_draw (sp->im_drawingarea_widget[MAX_WINS+1] , NULL);
	}
    }

  if ( all_images_need_redraw) {
    int lp=MAX_WINS; for(; lp>=0; lp--) 
      if(sp->im_widget[lp] != NULL) {	 	
	gtk_widget_draw (sp->im_drawingarea_widget[lp] , NULL);	
      }
    all_images_need_redraw=0;
  }
  else
    gtk_widget_draw (widget , NULL);  
  return TRUE;
}




/***************************************************************************
**************************************************************************

                  handlebox of ranges 

              ****************************

  used to enter the numerical values for im_warp_factor
  and  im_dissolve_factor

**********************************************************************
 */



void
on_handlebox2_show                     (GtkWidget       *widget,
                                        gpointer         user_data)
{
  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,"imagenum")); 

  g_assert(i > 0);
  //FIXME this doesnt work so we use a different window in glade
  if ( i == MAX_WINS+1)
    gtk_widget_hide(widget);
}


void im_factor_normalize(double *p, int i)
{
  double t=0,tt=0;
  int lp;
  
  if((p==sp->mf.im_warp_factor && 
      0== settings_get_value("mesh factors sum to 1"))
     || 
     (p==sp->mf.im_dissolve_factor && 
      0== settings_get_value("image factors sum to 1")))
    return;

  for (lp=1 ; lp<=MAX_WINS ; lp++)
    if(sp->im_widget[lp] != NULL ) {
      tt += p[lp];
      if(i!=lp) t+= p[lp];
    }

  for (lp=1 ; lp<=MAX_WINS ; lp++)
    if(sp->im_widget[lp] != NULL ) {
      if(i!=lp) {
	if(sp->max_wins==2) 
	  p[lp] = 1-p[i];
	else {
	  if( ABS(t) > 0.01)
	    p[lp] = p[lp] * (1 - p[i]) / t;
	  else
	    p[lp] = (1 - p[i]) / ((double) sp->max_wins-1.0) ;
	}
      }
    }
  redraw_spins();
}



void
redraw_spins()
{
  int lp;
  GtkWidget *w;
  GtkSpinButton *s;
  for (lp=1 ; lp<=MAX_WINS ; lp++)
    if( (w=sp->im_widget[lp]) != NULL ) {
      s=GTK_SPIN_BUTTON(lookup_widget(w,"spinbutton_mesh"));
      gtk_spin_button_set_value (s,sp->mf.im_warp_factor[lp]);
      s=GTK_SPIN_BUTTON(lookup_widget(w,"spinbutton_image"));
      gtk_spin_button_set_value (s,sp->mf.im_dissolve_factor[lp]);
   }
}



void
on_spinbutton_mesh_changed             (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkSpinButton *spin = GTK_SPIN_BUTTON (editable);
  GtkRange *range=GTK_RANGE(user_data);
  double val;
  int i=GPOINTER_TO_UINT(gtk_widget_get_data_top(GTK_WIDGET(editable)
						 ,"imagenum"));

  //g_message ( "spin mesh %0.*f\n", spin->digits,
  //      gtk_spin_button_get_value_as_float (spin));
  
  sp->mf.im_warp_factor[i]=val=gtk_spin_button_get_value_as_float (spin);
  im_factor_normalize(sp->mf.im_warp_factor,i);
  
  range->adjustment->value=val;
  gtk_signal_emit_by_name (GTK_OBJECT (range->adjustment), "changed");

  if( settings_get_value("automatic mesh interpolation")&& sp->max_wins>1)
    on_interpolate_meshes1_activate        (NULL,NULL);
    
}


void
on_spinbutton_image_changed            (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkSpinButton *spin = GTK_SPIN_BUTTON (editable);
  GtkRange *range=GTK_RANGE(user_data);
  double val;
  int i=GPOINTER_TO_UINT(gtk_widget_get_data_top(GTK_WIDGET(editable),
						 "imagenum"));
    
  //g_message ( "spin image %0.*f\n", spin->digits,
  //	      gtk_spin_button_get_value_as_float (spin));
  
  sp->mf.im_dissolve_factor[i]=val=gtk_spin_button_get_value_as_float (spin);
  im_factor_normalize(sp->mf.im_dissolve_factor, i);

  range->adjustment->value=val;
  gtk_signal_emit_by_name (GTK_OBJECT (range->adjustment), "changed");
}


gboolean
on_hscale_mesh_button_release_event    (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkRange *range=GTK_RANGE(widget);
  GtkSpinButton *spin=GTK_SPIN_BUTTON(user_data);

  gtk_spin_button_set_value (spin, range->adjustment->value);

  return FALSE;
}

gboolean
on_hscale_image_button_release_event    (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkRange *range=GTK_RANGE(widget);
  GtkSpinButton *spin=GTK_SPIN_BUTTON(user_data);

  gtk_spin_button_set_value (spin, range->adjustment->value);
  return FALSE;
}






















/****************************************************************************/









void
on_settings1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}




void
on_warped_im_in_other_win1_activate    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  //extern int on_warped_im_in_other_win_val;
  //on_warped_im_in_other_win_val=GTK_CHECK_MENU_ITEM(menuitem)->active;
  abort();
}



gboolean
on_window_warped_delete_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,"imagenum")); 
  g_assert(i > 0);
  g_assert(sp->im_warped_widget[i] == widget);
  //gtk_widget_unref(sp->im_warped_widget[i]);
  sp->im_warped_widget[i]=NULL;
  return FALSE;
}


gboolean
on_drawingarea_warped_expose_event     (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  //  int w=sp->resulting_width, h=sp->resulting_height;
  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,"imagenum")); 
  GdkPixmap *pixmap = sp->im_warped_pixmap[i];

  g_assert(i > 0);
  g_assert(pixmap != NULL);
  gdk_gc_set_clip_rectangle (widget->style->fg_gc[widget->state],
			     &event->area);
  g_assert( pixmap != NULL);
  gdk_draw_pixmap(widget->window,
		  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		  pixmap,
		  event->area.x, event->area.y,
		  event->area.x, event->area.y,
		  event->area.width, event->area.height);

 
  return TRUE;
}



gboolean
on_drawingarea_warped_configure_event  (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{

  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,"imagenum")); 
  //GdkPixmap *pixmap = sp->im_pixmap_subimage[i];
  g_assert(i>0);
  
  return FALSE;
}














/*********************************************************************
**********************************************************************

 * warning dialog hook
 FIXME: I think this is not the right way to do it

**********************************************************************
**********************************************************************
**/


/* the text of the warning */
char dialogwarning_text[1001]="";

 
void
on_labelwarning_show                   (GtkWidget       *widget,
                                        gpointer         user_data)
{
  gtk_label_set_text              (GTK_LABEL(widget),
				   dialogwarning_text);
}

void
on_labelwarning_realize                (GtkWidget       *widget,
                                        gpointer         user_data)
{
  gtk_label_set_text              (GTK_LABEL(widget),
				   dialogwarning_text);
}





//GtkWidget *menu_image_num_g=NULL;

void show_warning(const char *str)
{
  strncpy(dialogwarning_text,str,1000);
  if(settings_get_value("no warnings")==0) {
    dialogwarning_g= create_dialogwarning();
    gtk_widget_show(dialogwarning_g);
  }
  else
    gdk_beep();
}

void
on_why_the_beep_1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
 if(*dialogwarning_text) {
   dialogwarning_g= create_dialogwarning();
   gtk_widget_show(dialogwarning_g);
 }
 *dialogwarning_text=0;
}









