/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.trace;

import com.icl.saxon.Context;
import com.icl.saxon.handlers.NodeHandler;
import com.icl.saxon.om.ElementInfo;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.trace.TraceListener;
import org.xml.sax.SAXException;

public class SimpleTraceListener
implements TraceListener {
    String indent = "";

    public void open() {
        System.err.println("<trace>");
    }

    public void close() {
        System.err.println("</trace>");
    }

    public void toplevel(NodeInfo nodeInfo) throws SAXException {
        StyleElement styleElement = (StyleElement)nodeInfo;
        System.err.println("<Top-level element=\"" + styleElement.getDisplayName() + "\" line=\"" + styleElement.getLineNumber() + "\" file=\"" + styleElement.getSystemId() + "\" precedence=\"" + styleElement.getPrecedence() + "\"/>");
    }

    public void enterSource(NodeHandler nodeHandler, Context context) throws SAXException {
        NodeInfo nodeInfo = context.getContextNode();
        System.err.println(this.indent + "<Source node=\"" + nodeInfo.getPath() + "\" line=\"" + nodeInfo.getLineNumber() + "\" mode=\"" + this.getModeName(context) + "\">");
        this.indent = this.indent + " ";
    }

    public void leaveSource(NodeHandler nodeHandler, Context context) throws SAXException {
        this.indent = this.indent.substring(0, this.indent.length() - 1);
        System.err.println(this.indent + "</Source><!-- " + context.getContextNode().getPath() + " -->");
    }

    public void enter(NodeInfo nodeInfo, Context context) throws SAXException {
        if (nodeInfo instanceof ElementInfo) {
            System.err.println(this.indent + "<Instruction element=\"" + nodeInfo.getDisplayName() + "\" line=\"" + nodeInfo.getLineNumber() + "\">");
            this.indent = this.indent + " ";
        }
    }

    public void leave(NodeInfo nodeInfo, Context context) throws SAXException {
        if (nodeInfo instanceof ElementInfo) {
            this.indent = this.indent.substring(0, this.indent.length() - 1);
            System.err.println(this.indent + "</Instruction> <!-- " + nodeInfo.getDisplayName() + " -->");
        }
    }

    String getModeName(Context context) {
        String string = context.getMode().getName();
        return string == null ? "*default*" : string;
    }
}

