(* This file was originally generated by why.
   It can be modified; only the generated parts will be overwritten. *)

Require Import Why.

Parameter gcd : Z -> Z -> Z.

Axiom gcd_asubb_b : forall a b:Z, gcd a b = gcd (a - b) b.
Axiom gcd_a_bsuba : forall a b:Z, gcd a b = gcd a (b - a).
Axiom gcd_a_a : forall a:Z, gcd a a = a.
Axiom gcd_a_0 : forall a:Z, gcd a 0 = a.
Axiom gcd_a_amodb : forall a b:Z, gcd a b = gcd b (a mod b).

Hint Resolve gcd_asubb_b gcd_a_bsuba gcd_a_a gcd_a_0 gcd_a_amodb .

Definition max (x y:Z) : Z :=
  match Z_le_gt_dec x y with
  | left _ => y
  | right _ => x
  end.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma gcd1_po_1 : 
  forall (a: Z),
  forall (b: Z),
  forall (HW_1: a > 0 /\ b > 0),
  0 < a /\ 0 < b /\ (gcd a b) = (gcd a b).
Proof.
intuition.
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma gcd1_po_2 : 
  forall (a: Z),
  forall (b: Z),
  forall (HW_1: a > 0 /\ b > 0),
  forall (HW_2: 0 < a /\ 0 < b /\ (gcd a b) = (gcd a b)),
  forall (x: Z),
  forall (y: Z),
  forall (HW_3: 0 < x /\ 0 < y /\ (gcd x y) = (gcd a b)),
  forall (HW_4: x <> y),
  forall (HW_5: x > y),
  forall (x0: Z),
  forall (HW_6: x0 = (x - y)),
  (0 < x0 /\ 0 < y /\ (gcd x0 y) = (gcd a b)) /\ (Zwf 0 (max x0 y) (max x y)).
Proof.
intuition.
subst.
transitivity (gcd x y); auto.
unfold Zwf, max.
case (Z_le_gt_dec x0 y); case (Z_le_gt_dec x y); intros; omega.
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma gcd1_po_3 : 
  forall (a: Z),
  forall (b: Z),
  forall (HW_1: a > 0 /\ b > 0),
  forall (HW_2: 0 < a /\ 0 < b /\ (gcd a b) = (gcd a b)),
  forall (x: Z),
  forall (y: Z),
  forall (HW_3: 0 < x /\ 0 < y /\ (gcd x y) = (gcd a b)),
  forall (HW_4: x <> y),
  forall (HW_7: x <= y),
  forall (y0: Z),
  forall (HW_8: y0 = (y - x)),
  (0 < x /\ 0 < y0 /\ (gcd x y0) = (gcd a b)) /\ (Zwf 0 (max x y0) (max x y)).
Proof.
intuition.
subst.
transitivity (gcd x y); auto.
unfold Zwf, max.
assert (h: x <> y).
 assumption.
 case (Z_le_gt_dec x y0); case (Z_le_gt_dec x y); intros; omega.
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma gcd1_po_4 : 
  forall (a: Z),
  forall (b: Z),
  forall (HW_1: a > 0 /\ b > 0),
  forall (HW_2: 0 < a /\ 0 < b /\ (gcd a b) = (gcd a b)),
  forall (x: Z),
  forall (y: Z),
  forall (HW_3: 0 < x /\ 0 < y /\ (gcd x y) = (gcd a b)),
  forall (HW_9: x = y),
  x = (gcd a b).
Proof.
intuition; subst.
transitivity (gcd y y); auto.
Save.

(*Why*) Parameter gcd1_valid :
  forall (a: Z), forall (b: Z), forall (_: a > 0 /\ b > 0),
  (sig_1 Z (fun (result: Z)  => (result = (gcd a b)))).

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma gcd2_po_1 : 
  forall (a: Z),
  forall (b: Z),
  forall (HW_1: a >= 0 /\ b >= 0),
  0 <= a /\ 0 <= b /\ (gcd a b) = (gcd a b).
Proof.
intuition.
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma gcd2_po_2 : 
  forall (a: Z),
  forall (b: Z),
  forall (HW_1: a >= 0 /\ b >= 0),
  forall (HW_2: 0 <= a /\ 0 <= b /\ (gcd a b) = (gcd a b)),
  forall (x: Z),
  forall (y: Z),
  forall (HW_3: 0 <= x /\ 0 <= y /\ (gcd x y) = (gcd a b)),
  forall (HW_4: y <> 0),
  forall (x0: Z),
  forall (HW_5: x0 = y),
  forall (y0: Z),
  forall (HW_6: y0 = ((Zmod x y))),
  (0 <= x0 /\ 0 <= y0 /\ (gcd x0 y0) = (gcd a b)) /\ (Zwf 0 y0 y).
Proof.
intuition.
assert (h_y0: y <> 0).
 assumption.
assert (h1_y0: (y > 0)).
 omega.
generalize (Z_mod_lt x y h1_y0); intro.
subst; tauto.
subst.
transitivity (gcd x y); auto.
unfold Zwf.
assert (h_y0: y <> 0).
 assumption.
assert (h1_y0: (y > 0)).
 omega.
generalize (Z_mod_lt x y h1_y0); omega.
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma gcd2_po_3 : 
  forall (a: Z),
  forall (b: Z),
  forall (HW_1: a >= 0 /\ b >= 0),
  forall (HW_2: 0 <= a /\ 0 <= b /\ (gcd a b) = (gcd a b)),
  forall (x: Z),
  forall (y: Z),
  forall (HW_3: 0 <= x /\ 0 <= y /\ (gcd x y) = (gcd a b)),
  forall (HW_7: y = 0),
  x = (gcd a b).
Proof.
intuition; subst.
transitivity (gcd x 0); auto.
Save.

(*Why*) Parameter gcd2_valid :
  forall (a: Z), forall (b: Z), forall (_: a >= 0 /\ b >= 0),
  (sig_1 Z (fun (result: Z)  => (result = (gcd a b)))).

